/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of edge packaging job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgePackagingJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgePackagingJobSummary.Builder, EdgePackagingJobSummary> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobArn").getter(getter(EdgePackagingJobSummary::edgePackagingJobArn))
            .setter(setter(Builder::edgePackagingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobArn").build())
            .build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobName").getter(getter(EdgePackagingJobSummary::edgePackagingJobName))
            .setter(setter(Builder::edgePackagingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build())
            .build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobStatus").getter(getter(EdgePackagingJobSummary::edgePackagingJobStatusAsString))
            .setter(setter(Builder::edgePackagingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatus").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(EdgePackagingJobSummary::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(EdgePackagingJobSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(EdgePackagingJobSummary::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(EdgePackagingJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EdgePackagingJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_ARN_FIELD,
            EDGE_PACKAGING_JOB_NAME_FIELD, EDGE_PACKAGING_JOB_STATUS_FIELD, COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD,
            MODEL_VERSION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String edgePackagingJobArn;

    private final String edgePackagingJobName;

    private final String edgePackagingJobStatus;

    private final String compilationJobName;

    private final String modelName;

    private final String modelVersion;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private EdgePackagingJobSummary(BuilderImpl builder) {
        this.edgePackagingJobArn = builder.edgePackagingJobArn;
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.edgePackagingJobStatus = builder.edgePackagingJobStatus;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the edge packaging job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the edge packaging job.
     */
    public final String edgePackagingJobArn() {
        return edgePackagingJobArn;
    }

    /**
     * <p>
     * The name of the edge packaging job.
     * </p>
     * 
     * @return The name of the edge packaging job.
     */
    public final String edgePackagingJobName() {
        return edgePackagingJobName;
    }

    /**
     * <p>
     * The status of the edge packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #edgePackagingJobStatus} will return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #edgePackagingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the edge packaging job.
     * @see EdgePackagingJobStatus
     */
    public final EdgePackagingJobStatus edgePackagingJobStatus() {
        return EdgePackagingJobStatus.fromValue(edgePackagingJobStatus);
    }

    /**
     * <p>
     * The status of the edge packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #edgePackagingJobStatus} will return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #edgePackagingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the edge packaging job.
     * @see EdgePackagingJobStatus
     */
    public final String edgePackagingJobStatusAsString() {
        return edgePackagingJobStatus;
    }

    /**
     * <p>
     * The name of the SageMaker Neo compilation job.
     * </p>
     * 
     * @return The name of the SageMaker Neo compilation job.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version of the model.
     * </p>
     * 
     * @return The version of the model.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The timestamp of when the job was created.
     * </p>
     * 
     * @return The timestamp of when the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of when the edge packaging job was last updated.
     * </p>
     * 
     * @return The timestamp of when the edge packaging job was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePackagingJobSummary)) {
            return false;
        }
        EdgePackagingJobSummary other = (EdgePackagingJobSummary) obj;
        return Objects.equals(edgePackagingJobArn(), other.edgePackagingJobArn())
                && Objects.equals(edgePackagingJobName(), other.edgePackagingJobName())
                && Objects.equals(edgePackagingJobStatusAsString(), other.edgePackagingJobStatusAsString())
                && Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgePackagingJobSummary").add("EdgePackagingJobArn", edgePackagingJobArn())
                .add("EdgePackagingJobName", edgePackagingJobName())
                .add("EdgePackagingJobStatus", edgePackagingJobStatusAsString()).add("CompilationJobName", compilationJobName())
                .add("ModelName", modelName()).add("ModelVersion", modelVersion()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgePackagingJobArn":
            return Optional.ofNullable(clazz.cast(edgePackagingJobArn()));
        case "EdgePackagingJobName":
            return Optional.ofNullable(clazz.cast(edgePackagingJobName()));
        case "EdgePackagingJobStatus":
            return Optional.ofNullable(clazz.cast(edgePackagingJobStatusAsString()));
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgePackagingJobSummary, T> g) {
        return obj -> g.apply((EdgePackagingJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgePackagingJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobArn
         *        The Amazon Resource Name (ARN) of the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobArn(String edgePackagingJobArn);

        /**
         * <p>
         * The name of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobName
         *        The name of the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobName(String edgePackagingJobName);

        /**
         * <p>
         * The status of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobStatus
         *        The status of the edge packaging job.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder edgePackagingJobStatus(String edgePackagingJobStatus);

        /**
         * <p>
         * The status of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobStatus
         *        The status of the edge packaging job.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus);

        /**
         * <p>
         * The name of the SageMaker Neo compilation job.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the SageMaker Neo compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version of the model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The timestamp of when the job was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of when the edge packaging job was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of when the edge packaging job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String edgePackagingJobArn;

        private String edgePackagingJobName;

        private String edgePackagingJobStatus;

        private String compilationJobName;

        private String modelName;

        private String modelVersion;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgePackagingJobSummary model) {
            edgePackagingJobArn(model.edgePackagingJobArn);
            edgePackagingJobName(model.edgePackagingJobName);
            edgePackagingJobStatus(model.edgePackagingJobStatus);
            compilationJobName(model.compilationJobName);
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEdgePackagingJobArn() {
            return edgePackagingJobArn;
        }

        public final void setEdgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
            return this;
        }

        public final String getEdgePackagingJobName() {
            return edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final String getEdgePackagingJobStatus() {
            return edgePackagingJobStatus;
        }

        public final void setEdgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus) {
            this.edgePackagingJobStatus(edgePackagingJobStatus == null ? null : edgePackagingJobStatus.toString());
            return this;
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        @Transient
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public EdgePackagingJobSummary build() {
            return new EdgePackagingJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
