/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of algorithms that were used to create a model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAlgorithmSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceAlgorithmSpecification.Builder, SourceAlgorithmSpecification> {
    private static final SdkField<List<SourceAlgorithm>> SOURCE_ALGORITHMS_FIELD = SdkField
            .<List<SourceAlgorithm>> builder(MarshallingType.LIST)
            .memberName("SourceAlgorithms")
            .getter(getter(SourceAlgorithmSpecification::sourceAlgorithms))
            .setter(setter(Builder::sourceAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAlgorithm> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAlgorithm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ALGORITHMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SourceAlgorithm> sourceAlgorithms;

    private SourceAlgorithmSpecification(BuilderImpl builder) {
        this.sourceAlgorithms = builder.sourceAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAlgorithms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAlgorithms() {
        return sourceAlgorithms != null && !(sourceAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the algorithms that were used to create a model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAlgorithms} method.
     * </p>
     * 
     * @return A list of the algorithms that were used to create a model package.
     */
    public final List<SourceAlgorithm> sourceAlgorithms() {
        return sourceAlgorithms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAlgorithms() ? sourceAlgorithms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAlgorithmSpecification)) {
            return false;
        }
        SourceAlgorithmSpecification other = (SourceAlgorithmSpecification) obj;
        return hasSourceAlgorithms() == other.hasSourceAlgorithms()
                && Objects.equals(sourceAlgorithms(), other.sourceAlgorithms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceAlgorithmSpecification")
                .add("SourceAlgorithms", hasSourceAlgorithms() ? sourceAlgorithms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAlgorithms":
            return Optional.ofNullable(clazz.cast(sourceAlgorithms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAlgorithmSpecification, T> g) {
        return obj -> g.apply((SourceAlgorithmSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAlgorithmSpecification> {
        /**
         * <p>
         * A list of the algorithms that were used to create a model package.
         * </p>
         * 
         * @param sourceAlgorithms
         *        A list of the algorithms that were used to create a model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithms(Collection<SourceAlgorithm> sourceAlgorithms);

        /**
         * <p>
         * A list of the algorithms that were used to create a model package.
         * </p>
         * 
         * @param sourceAlgorithms
         *        A list of the algorithms that were used to create a model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithms(SourceAlgorithm... sourceAlgorithms);

        /**
         * <p>
         * A list of the algorithms that were used to create a model package.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceAlgorithm>.Builder} avoiding the need
         * to create one manually via {@link List<SourceAlgorithm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceAlgorithm>.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceAlgorithms(List<SourceAlgorithm>)}.
         * 
         * @param sourceAlgorithms
         *        a consumer that will call methods on {@link List<SourceAlgorithm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAlgorithms(List<SourceAlgorithm>)
         */
        Builder sourceAlgorithms(Consumer<SourceAlgorithm.Builder>... sourceAlgorithms);
    }

    static final class BuilderImpl implements Builder {
        private List<SourceAlgorithm> sourceAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAlgorithmSpecification model) {
            sourceAlgorithms(model.sourceAlgorithms);
        }

        public final List<SourceAlgorithm.Builder> getSourceAlgorithms() {
            List<SourceAlgorithm.Builder> result = SourceAlgorithmListCopier.copyToBuilder(this.sourceAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAlgorithms(Collection<SourceAlgorithm.BuilderImpl> sourceAlgorithms) {
            this.sourceAlgorithms = SourceAlgorithmListCopier.copyFromBuilder(sourceAlgorithms);
        }

        @Override
        @Transient
        public final Builder sourceAlgorithms(Collection<SourceAlgorithm> sourceAlgorithms) {
            this.sourceAlgorithms = SourceAlgorithmListCopier.copy(sourceAlgorithms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceAlgorithms(SourceAlgorithm... sourceAlgorithms) {
            sourceAlgorithms(Arrays.asList(sourceAlgorithms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceAlgorithms(Consumer<SourceAlgorithm.Builder>... sourceAlgorithms) {
            sourceAlgorithms(Stream.of(sourceAlgorithms).map(c -> SourceAlgorithm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SourceAlgorithmSpecification build() {
            return new SourceAlgorithmSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
