/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID and ID type of an artifact source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactSourceType implements SdkPojo, Serializable,
        ToCopyableBuilder<ArtifactSourceType.Builder, ArtifactSourceType> {
    private static final SdkField<String> SOURCE_ID_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIdType").getter(getter(ArtifactSourceType::sourceIdTypeAsString))
            .setter(setter(Builder::sourceIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ArtifactSourceType::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_TYPE_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceIdType;

    private final String value;

    private ArtifactSourceType(BuilderImpl builder) {
        this.sourceIdType = builder.sourceIdType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceIdType} will
     * return {@link ArtifactSourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceIdTypeAsString}.
     * </p>
     * 
     * @return The type of ID.
     * @see ArtifactSourceIdType
     */
    public final ArtifactSourceIdType sourceIdType() {
        return ArtifactSourceIdType.fromValue(sourceIdType);
    }

    /**
     * <p>
     * The type of ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceIdType} will
     * return {@link ArtifactSourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceIdTypeAsString}.
     * </p>
     * 
     * @return The type of ID.
     * @see ArtifactSourceIdType
     */
    public final String sourceIdTypeAsString() {
        return sourceIdType;
    }

    /**
     * <p>
     * The ID.
     * </p>
     * 
     * @return The ID.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSourceType)) {
            return false;
        }
        ArtifactSourceType other = (ArtifactSourceType) obj;
        return Objects.equals(sourceIdTypeAsString(), other.sourceIdTypeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactSourceType").add("SourceIdType", sourceIdTypeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIdType":
            return Optional.ofNullable(clazz.cast(sourceIdTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactSourceType, T> g) {
        return obj -> g.apply((ArtifactSourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactSourceType> {
        /**
         * <p>
         * The type of ID.
         * </p>
         * 
         * @param sourceIdType
         *        The type of ID.
         * @see ArtifactSourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactSourceIdType
         */
        Builder sourceIdType(String sourceIdType);

        /**
         * <p>
         * The type of ID.
         * </p>
         * 
         * @param sourceIdType
         *        The type of ID.
         * @see ArtifactSourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactSourceIdType
         */
        Builder sourceIdType(ArtifactSourceIdType sourceIdType);

        /**
         * <p>
         * The ID.
         * </p>
         * 
         * @param value
         *        The ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIdType;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactSourceType model) {
            sourceIdType(model.sourceIdType);
            value(model.value);
        }

        public final String getSourceIdType() {
            return sourceIdType;
        }

        public final void setSourceIdType(String sourceIdType) {
            this.sourceIdType = sourceIdType;
        }

        @Override
        @Transient
        public final Builder sourceIdType(String sourceIdType) {
            this.sourceIdType = sourceIdType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceIdType(ArtifactSourceIdType sourceIdType) {
            this.sourceIdType(sourceIdType == null ? null : sourceIdType.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ArtifactSourceType build() {
            return new ArtifactSourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
