/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location of the input data objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobS3DataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobS3DataSource.Builder, LabelingJobS3DataSource> {
    private static final SdkField<String> MANIFEST_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestS3Uri").getter(getter(LabelingJobS3DataSource::manifestS3Uri))
            .setter(setter(Builder::manifestS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestS3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestS3Uri;

    private LabelingJobS3DataSource(BuilderImpl builder) {
        this.manifestS3Uri = builder.manifestS3Uri;
    }

    /**
     * <p>
     * The Amazon S3 location of the manifest file that describes the input data objects.
     * </p>
     * <p>
     * The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following keys:
     * <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use this value
     * when the object is a binary object, such as an image.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source</code>: The source of the object is the value. Use this value when the object is a text value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you are a new user of Ground Truth, it is recommended you review <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input Manifest
     * File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest file.
     * </p>
     * 
     * @return The Amazon S3 location of the manifest file that describes the input data objects. </p>
     *         <p>
     *         The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following keys:
     *         <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use
     *         this value when the object is a binary object, such as an image.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source</code>: The source of the object is the value. Use this value when the object is a text
     *         value.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you are a new user of Ground Truth, it is recommended you review <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input
     *         Manifest File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest file.
     */
    public final String manifestS3Uri() {
        return manifestS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestS3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobS3DataSource)) {
            return false;
        }
        LabelingJobS3DataSource other = (LabelingJobS3DataSource) obj;
        return Objects.equals(manifestS3Uri(), other.manifestS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobS3DataSource").add("ManifestS3Uri", manifestS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestS3Uri":
            return Optional.ofNullable(clazz.cast(manifestS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobS3DataSource, T> g) {
        return obj -> g.apply((LabelingJobS3DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobS3DataSource> {
        /**
         * <p>
         * The Amazon S3 location of the manifest file that describes the input data objects.
         * </p>
         * <p>
         * The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following keys:
         * <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use this
         * value when the object is a binary object, such as an image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source</code>: The source of the object is the value. Use this value when the object is a text value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you are a new user of Ground Truth, it is recommended you review <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input
         * Manifest File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest file.
         * </p>
         * 
         * @param manifestS3Uri
         *        The Amazon S3 location of the manifest file that describes the input data objects. </p>
         *        <p>
         *        The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following
         *        keys: <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as
         *        follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use
         *        this value when the object is a binary object, such as an image.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source</code>: The source of the object is the value. Use this value when the object is a text
         *        value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you are a new user of Ground Truth, it is recommended you review <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input
         *        Manifest File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest
         *        file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestS3Uri(String manifestS3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String manifestS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobS3DataSource model) {
            manifestS3Uri(model.manifestS3Uri);
        }

        public final String getManifestS3Uri() {
            return manifestS3Uri;
        }

        public final void setManifestS3Uri(String manifestS3Uri) {
            this.manifestS3Uri = manifestS3Uri;
        }

        @Override
        @Transient
        public final Builder manifestS3Uri(String manifestS3Uri) {
            this.manifestS3Uri = manifestS3Uri;
            return this;
        }

        @Override
        public LabelingJobS3DataSource build() {
            return new LabelingJobS3DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
