/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelinesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListPipelinesResponse.Builder, ListPipelinesResponse> {
    private static final SdkField<List<PipelineSummary>> PIPELINE_SUMMARIES_FIELD = SdkField
            .<List<PipelineSummary>> builder(MarshallingType.LIST)
            .memberName("PipelineSummaries")
            .getter(getter(ListPipelinesResponse::pipelineSummaries))
            .setter(setter(Builder::pipelineSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PipelineSummary> pipelineSummaries;

    private final String nextToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineSummaries = builder.pipelineSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineSummaries() {
        return pipelineSummaries != null && !(pipelineSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
     * <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription,
     * CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineSummaries} method.
     * </p>
     * 
     * @return Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
     *         <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription,
     *         CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
     */
    public final List<PipelineSummary> pipelineSummaries() {
        return pipelineSummaries;
    }

    /**
     * <p>
     * If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a
     *         <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineSummaries() ? pipelineSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse) obj;
        return hasPipelineSummaries() == other.hasPipelineSummaries()
                && Objects.equals(pipelineSummaries(), other.pipelineSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelinesResponse")
                .add("PipelineSummaries", hasPipelineSummaries() ? pipelineSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineSummaries":
            return Optional.ofNullable(clazz.cast(pipelineSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelinesResponse> {
        /**
         * <p>
         * Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
         * <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription,
         * CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
         * </p>
         * 
         * @param pipelineSummaries
         *        Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
         *        <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName,
         *        PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineSummaries(Collection<PipelineSummary> pipelineSummaries);

        /**
         * <p>
         * Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
         * <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription,
         * CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
         * </p>
         * 
         * @param pipelineSummaries
         *        Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
         *        <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName,
         *        PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineSummaries(PipelineSummary... pipelineSummaries);

        /**
         * <p>
         * Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each
         * <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription,
         * CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PipelineSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineSummaries(List<PipelineSummary>)}.
         * 
         * @param pipelineSummaries
         *        a consumer that will call methods on {@link List<PipelineSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineSummaries(List<PipelineSummary>)
         */
        Builder pipelineSummaries(Consumer<PipelineSummary.Builder>... pipelineSummaries);

        /**
         * <p>
         * If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a
         * <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListPipelines</code> request was truncated, the response includes
         *        a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<PipelineSummary> pipelineSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            pipelineSummaries(model.pipelineSummaries);
            nextToken(model.nextToken);
        }

        public final List<PipelineSummary.Builder> getPipelineSummaries() {
            List<PipelineSummary.Builder> result = PipelineSummaryListCopier.copyToBuilder(this.pipelineSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineSummaries(Collection<PipelineSummary.BuilderImpl> pipelineSummaries) {
            this.pipelineSummaries = PipelineSummaryListCopier.copyFromBuilder(pipelineSummaries);
        }

        @Override
        @Transient
        public final Builder pipelineSummaries(Collection<PipelineSummary> pipelineSummaries) {
            this.pipelineSummaries = PipelineSummaryListCopier.copy(pipelineSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineSummaries(PipelineSummary... pipelineSummaries) {
            pipelineSummaries(Arrays.asList(pipelineSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineSummaries(Consumer<PipelineSummary.Builder>... pipelineSummaries) {
            pipelineSummaries(Stream.of(pipelineSummaries).map(c -> PipelineSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
