/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainingJobsForHyperParameterTuningJobRequest extends SageMakerRequest
        implements
        ToCopyableBuilder<ListTrainingJobsForHyperParameterTuningJobRequest.Builder, ListTrainingJobsForHyperParameterTuningJobRequest> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobName")
            .getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::hyperParameterTuningJobName))
            .setter(setter(Builder::hyperParameterTuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName")
                    .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListTrainingJobsForHyperParameterTuningJobRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD,
            SORT_ORDER_FIELD));

    private final String hyperParameterTuningJobName;

    private final String nextToken;

    private final Integer maxResults;

    private final String statusEquals;

    private final String sortBy;

    private final String sortOrder;

    private ListTrainingJobsForHyperParameterTuningJobRequest(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The name of the tuning job whose training jobs you want to list.
     * </p>
     * 
     * @return The name of the tuning job whose training jobs you want to list.
     */
    public final String hyperParameterTuningJobName() {
        return hyperParameterTuningJobName;
    }

    /**
     * <p>
     * If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the
     * response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next
     * request.
     * </p>
     * 
     * @return If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was
     *         truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use
     *         the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of training jobs to return. The default value is 10.
     * </p>
     * 
     * @return The maximum number of training jobs to return. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter that returns only training jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only training jobs with the specified status.
     * @see TrainingJobStatus
     */
    public final TrainingJobStatus statusEquals() {
        return TrainingJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * A filter that returns only training jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only training jobs with the specified status.
     * @see TrainingJobStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>Name</code>.
     * </p>
     * <p>
     * If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return an
     * objective metric are not listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TrainingJobSortByOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>Name</code>.</p>
     *         <p>
     *         If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not
     *         return an objective metric are not listed.
     * @see TrainingJobSortByOptions
     */
    public final TrainingJobSortByOptions sortBy() {
        return TrainingJobSortByOptions.fromValue(sortBy);
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>Name</code>.
     * </p>
     * <p>
     * If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return an
     * objective metric are not listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TrainingJobSortByOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>Name</code>.</p>
     *         <p>
     *         If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not
     *         return an objective metric are not listed.
     * @see TrainingJobSortByOptions
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsForHyperParameterTuningJobRequest)) {
            return false;
        }
        ListTrainingJobsForHyperParameterTuningJobRequest other = (ListTrainingJobsForHyperParameterTuningJobRequest) obj;
        return Objects.equals(hyperParameterTuningJobName(), other.hyperParameterTuningJobName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrainingJobsForHyperParameterTuningJobRequest")
                .add("HyperParameterTuningJobName", hyperParameterTuningJobName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("StatusEquals", statusEqualsAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobName":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsForHyperParameterTuningJobRequest, T> g) {
        return obj -> g.apply((ListTrainingJobsForHyperParameterTuningJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobRequest> {
        /**
         * <p>
         * The name of the tuning job whose training jobs you want to list.
         * </p>
         * 
         * @param hyperParameterTuningJobName
         *        The name of the tuning job whose training jobs you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobName(String hyperParameterTuningJobName);

        /**
         * <p>
         * If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated,
         * the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in
         * the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was
         *        truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of training jobs to return. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of training jobs to return. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter that returns only training jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that returns only training jobs with the specified status.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * A filter that returns only training jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that returns only training jobs with the specified status.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder statusEquals(TrainingJobStatus statusEquals);

        /**
         * <p>
         * The field to sort results by. The default is <code>Name</code>.
         * </p>
         * <p>
         * If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return
         * an objective metric are not listed.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>Name</code>.</p>
         *        <p>
         *        If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not
         *        return an objective metric are not listed.
         * @see TrainingJobSortByOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobSortByOptions
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field to sort results by. The default is <code>Name</code>.
         * </p>
         * <p>
         * If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return
         * an objective metric are not listed.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>Name</code>.</p>
         *        <p>
         *        If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not
         *        return an objective metric are not listed.
         * @see TrainingJobSortByOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobSortByOptions
         */
        Builder sortBy(TrainingJobSortByOptions sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hyperParameterTuningJobName;

        private String nextToken;

        private Integer maxResults;

        private String statusEquals;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsForHyperParameterTuningJobRequest model) {
            super(model);
            hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            statusEquals(model.statusEquals);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getHyperParameterTuningJobName() {
            return hyperParameterTuningJobName;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        @Transient
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        @Transient
        public final Builder statusEquals(TrainingJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Transient
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Transient
        public final Builder sortBy(TrainingJobSortByOptions sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainingJobsForHyperParameterTuningJobRequest build() {
            return new ListTrainingJobsForHyperParameterTuningJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
