/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelPackageResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelPackageResponse.Builder, DescribeModelPackageResponse> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageName").getter(getter(DescribeModelPackageResponse::modelPackageName))
            .setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(DescribeModelPackageResponse::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<Integer> MODEL_PACKAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelPackageVersion").getter(getter(DescribeModelPackageResponse::modelPackageVersion))
            .setter(setter(Builder::modelPackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersion").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageArn").getter(getter(DescribeModelPackageResponse::modelPackageArn))
            .setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageDescription").getter(getter(DescribeModelPackageResponse::modelPackageDescription))
            .setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeModelPackageResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO).memberName("InferenceSpecification")
            .getter(getter(DescribeModelPackageResponse::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<SourceAlgorithmSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("SourceAlgorithmSpecification")
            .getter(getter(DescribeModelPackageResponse::sourceAlgorithmSpecification))
            .setter(setter(Builder::sourceAlgorithmSpecification))
            .constructor(SourceAlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification")
                    .build()).build();

    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField
            .<ModelPackageValidationSpecification> builder(MarshallingType.SDK_POJO).memberName("ValidationSpecification")
            .getter(getter(DescribeModelPackageResponse::validationSpecification))
            .setter(setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageStatus").getter(getter(DescribeModelPackageResponse::modelPackageStatusAsString))
            .setter(setter(Builder::modelPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build())
            .build();

    private static final SdkField<ModelPackageStatusDetails> MODEL_PACKAGE_STATUS_DETAILS_FIELD = SdkField
            .<ModelPackageStatusDetails> builder(MarshallingType.SDK_POJO).memberName("ModelPackageStatusDetails")
            .getter(getter(DescribeModelPackageResponse::modelPackageStatusDetails))
            .setter(setter(Builder::modelPackageStatusDetails)).constructor(ModelPackageStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatusDetails").build())
            .build();

    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CertifyForMarketplace").getter(getter(DescribeModelPackageResponse::certifyForMarketplace))
            .setter(setter(Builder::certifyForMarketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build())
            .build();

    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelApprovalStatus").getter(getter(DescribeModelPackageResponse::modelApprovalStatusAsString))
            .setter(setter(Builder::modelApprovalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build())
            .build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeModelPackageResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(DescribeModelPackageResponse::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<ModelMetrics> MODEL_METRICS_FIELD = SdkField.<ModelMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ModelMetrics").getter(getter(DescribeModelPackageResponse::modelMetrics))
            .setter(setter(Builder::modelMetrics)).constructor(ModelMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeModelPackageResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeModelPackageResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalDescription").getter(getter(DescribeModelPackageResponse::approvalDescription))
            .setter(setter(Builder::approvalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build())
            .build();

    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomerMetadataProperties")
            .getter(getter(DescribeModelPackageResponse::customerMetadataProperties))
            .setter(setter(Builder::customerMetadataProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD,
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_VERSION_FIELD, MODEL_PACKAGE_ARN_FIELD,
            MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD,
            SOURCE_ALGORITHM_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD,
            MODEL_PACKAGE_STATUS_DETAILS_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, MODEL_APPROVAL_STATUS_FIELD, CREATED_BY_FIELD,
            METADATA_PROPERTIES_FIELD, MODEL_METRICS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD,
            APPROVAL_DESCRIPTION_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD));

    private final String modelPackageName;

    private final String modelPackageGroupName;

    private final Integer modelPackageVersion;

    private final String modelPackageArn;

    private final String modelPackageDescription;

    private final Instant creationTime;

    private final InferenceSpecification inferenceSpecification;

    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;

    private final ModelPackageValidationSpecification validationSpecification;

    private final String modelPackageStatus;

    private final ModelPackageStatusDetails modelPackageStatusDetails;

    private final Boolean certifyForMarketplace;

    private final String modelApprovalStatus;

    private final UserContext createdBy;

    private final MetadataProperties metadataProperties;

    private final ModelMetrics modelMetrics;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final String approvalDescription;

    private final Map<String, String> customerMetadataProperties;

    private DescribeModelPackageResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageVersion = builder.modelPackageVersion;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.createdBy = builder.createdBy;
        this.metadataProperties = builder.metadataProperties;
        this.modelMetrics = builder.modelMetrics;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.approvalDescription = builder.approvalDescription;
        this.customerMetadataProperties = builder.customerMetadataProperties;
    }

    /**
     * <p>
     * The name of the model package being described.
     * </p>
     * 
     * @return The name of the model package being described.
     */
    public final String modelPackageName() {
        return modelPackageName;
    }

    /**
     * <p>
     * If the model is a versioned model, the name of the model group that the versioned model belongs to.
     * </p>
     * 
     * @return If the model is a versioned model, the name of the model group that the versioned model belongs to.
     */
    public final String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The version of the model package.
     * </p>
     * 
     * @return The version of the model package.
     */
    public final Integer modelPackageVersion() {
        return modelPackageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public final String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * A brief summary of the model package.
     * </p>
     * 
     * @return A brief summary of the model package.
     */
    public final String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * A timestamp specifying when the model package was created.
     * </p>
     * 
     * @return A timestamp specifying when the model package was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Details about inference jobs that can be run with models based on this model package.
     * </p>
     * 
     * @return Details about inference jobs that can be run with models based on this model package.
     */
    public final InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * Details about the algorithm that was used to create the model package.
     * </p>
     * 
     * @return Details about the algorithm that was used to create the model package.
     */
    public final SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return sourceAlgorithmSpecification;
    }

    /**
     * <p>
     * Configurations for one or more transform jobs that SageMaker runs to test the model package.
     * </p>
     * 
     * @return Configurations for one or more transform jobs that SageMaker runs to test the model package.
     */
    public final ModelPackageValidationSpecification validationSpecification() {
        return validationSpecification;
    }

    /**
     * <p>
     * The current status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The current status of the model package.
     * @see ModelPackageStatus
     */
    public final ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(modelPackageStatus);
    }

    /**
     * <p>
     * The current status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The current status of the model package.
     * @see ModelPackageStatus
     */
    public final String modelPackageStatusAsString() {
        return modelPackageStatus;
    }

    /**
     * <p>
     * Details about the current status of the model package.
     * </p>
     * 
     * @return Details about the current status of the model package.
     */
    public final ModelPackageStatusDetails modelPackageStatusDetails() {
        return modelPackageStatusDetails;
    }

    /**
     * <p>
     * Whether the model package is certified for listing on Amazon Web Services Marketplace.
     * </p>
     * 
     * @return Whether the model package is certified for listing on Amazon Web Services Marketplace.
     */
    public final Boolean certifyForMarketplace() {
        return certifyForMarketplace;
    }

    /**
     * <p>
     * The approval status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model package.
     * @see ModelApprovalStatus
     */
    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(modelApprovalStatus);
    }

    /**
     * <p>
     * The approval status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model package.
     * @see ModelApprovalStatus
     */
    public final String modelApprovalStatusAsString() {
        return modelApprovalStatus;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * <p>
     * Metrics for the model.
     * </p>
     * 
     * @return Metrics for the model.
     */
    public final ModelMetrics modelMetrics() {
        return modelMetrics;
    }

    /**
     * <p>
     * The last time the model package was modified.
     * </p>
     * 
     * @return The last time the model package was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * A description provided for the model approval.
     * </p>
     * 
     * @return A description provided for the model approval.
     */
    public final String approvalDescription() {
        return approvalDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerMetadataProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomerMetadataProperties() {
        return customerMetadataProperties != null && !(customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata properties associated with the model package versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerMetadataProperties} method.
     * </p>
     * 
     * @return The metadata properties associated with the model package versions.
     */
    public final Map<String, String> customerMetadataProperties() {
        return customerMetadataProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerMetadataProperties() ? customerMetadataProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackageResponse)) {
            return false;
        }
        DescribeModelPackageResponse other = (DescribeModelPackageResponse) obj;
        return Objects.equals(modelPackageName(), other.modelPackageName())
                && Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageVersion(), other.modelPackageVersion())
                && Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification())
                && Objects.equals(validationSpecification(), other.validationSpecification())
                && Objects.equals(modelPackageStatusAsString(), other.modelPackageStatusAsString())
                && Objects.equals(modelPackageStatusDetails(), other.modelPackageStatusDetails())
                && Objects.equals(certifyForMarketplace(), other.certifyForMarketplace())
                && Objects.equals(modelApprovalStatusAsString(), other.modelApprovalStatusAsString())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(metadataProperties(), other.metadataProperties())
                && Objects.equals(modelMetrics(), other.modelMetrics())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(approvalDescription(), other.approvalDescription())
                && hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties()
                && Objects.equals(customerMetadataProperties(), other.customerMetadataProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelPackageResponse").add("ModelPackageName", modelPackageName())
                .add("ModelPackageGroupName", modelPackageGroupName()).add("ModelPackageVersion", modelPackageVersion())
                .add("ModelPackageArn", modelPackageArn()).add("ModelPackageDescription", modelPackageDescription())
                .add("CreationTime", creationTime()).add("InferenceSpecification", inferenceSpecification())
                .add("SourceAlgorithmSpecification", sourceAlgorithmSpecification())
                .add("ValidationSpecification", validationSpecification())
                .add("ModelPackageStatus", modelPackageStatusAsString())
                .add("ModelPackageStatusDetails", modelPackageStatusDetails())
                .add("CertifyForMarketplace", certifyForMarketplace()).add("ModelApprovalStatus", modelApprovalStatusAsString())
                .add("CreatedBy", createdBy()).add("MetadataProperties", metadataProperties())
                .add("ModelMetrics", modelMetrics()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("ApprovalDescription", approvalDescription())
                .add("CustomerMetadataProperties", hasCustomerMetadataProperties() ? customerMetadataProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageVersion":
            return Optional.ofNullable(clazz.cast(modelPackageVersion()));
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "SourceAlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(sourceAlgorithmSpecification()));
        case "ValidationSpecification":
            return Optional.ofNullable(clazz.cast(validationSpecification()));
        case "ModelPackageStatus":
            return Optional.ofNullable(clazz.cast(modelPackageStatusAsString()));
        case "ModelPackageStatusDetails":
            return Optional.ofNullable(clazz.cast(modelPackageStatusDetails()));
        case "CertifyForMarketplace":
            return Optional.ofNullable(clazz.cast(certifyForMarketplace()));
        case "ModelApprovalStatus":
            return Optional.ofNullable(clazz.cast(modelApprovalStatusAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "ModelMetrics":
            return Optional.ofNullable(clazz.cast(modelMetrics()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "ApprovalDescription":
            return Optional.ofNullable(clazz.cast(approvalDescription()));
        case "CustomerMetadataProperties":
            return Optional.ofNullable(clazz.cast(customerMetadataProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackageResponse, T> g) {
        return obj -> g.apply((DescribeModelPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeModelPackageResponse> {
        /**
         * <p>
         * The name of the model package being described.
         * </p>
         * 
         * @param modelPackageName
         *        The name of the model package being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);

        /**
         * <p>
         * If the model is a versioned model, the name of the model group that the versioned model belongs to.
         * </p>
         * 
         * @param modelPackageGroupName
         *        If the model is a versioned model, the name of the model group that the versioned model belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The version of the model package.
         * </p>
         * 
         * @param modelPackageVersion
         *        The version of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersion(Integer modelPackageVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * A brief summary of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        A brief summary of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * A timestamp specifying when the model package was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp specifying when the model package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Details about inference jobs that can be run with models based on this model package.
         * </p>
         * 
         * @param inferenceSpecification
         *        Details about inference jobs that can be run with models based on this model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * <p>
         * Details about inference jobs that can be run with models based on this model package.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceSpecification.Builder} avoiding the
         * need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * 
         * @param sourceAlgorithmSpecification
         *        Details about the algorithm that was used to create the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification);

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceAlgorithmSpecification.Builder} avoiding
         * the need to create one manually via {@link SourceAlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAlgorithmSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAlgorithmSpecification(SourceAlgorithmSpecification)}.
         * 
         * @param sourceAlgorithmSpecification
         *        a consumer that will call methods on {@link SourceAlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAlgorithmSpecification(SourceAlgorithmSpecification)
         */
        default Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return sourceAlgorithmSpecification(SourceAlgorithmSpecification.builder()
                    .applyMutation(sourceAlgorithmSpecification).build());
        }

        /**
         * <p>
         * Configurations for one or more transform jobs that SageMaker runs to test the model package.
         * </p>
         * 
         * @param validationSpecification
         *        Configurations for one or more transform jobs that SageMaker runs to test the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSpecification(ModelPackageValidationSpecification validationSpecification);

        /**
         * <p>
         * Configurations for one or more transform jobs that SageMaker runs to test the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackageValidationSpecification.Builder}
         * avoiding the need to create one manually via {@link ModelPackageValidationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageValidationSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #validationSpecification(ModelPackageValidationSpecification)}
         * .
         * 
         * @param validationSpecification
         *        a consumer that will call methods on {@link ModelPackageValidationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSpecification(ModelPackageValidationSpecification)
         */
        default Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return validationSpecification(ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)
                    .build());
        }

        /**
         * <p>
         * The current status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The current status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(String modelPackageStatus);

        /**
         * <p>
         * The current status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The current status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(ModelPackageStatus modelPackageStatus);

        /**
         * <p>
         * Details about the current status of the model package.
         * </p>
         * 
         * @param modelPackageStatusDetails
         *        Details about the current status of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails);

        /**
         * <p>
         * Details about the current status of the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackageStatusDetails.Builder} avoiding the
         * need to create one manually via {@link ModelPackageStatusDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageStatusDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #modelPackageStatusDetails(ModelPackageStatusDetails)}.
         * 
         * @param modelPackageStatusDetails
         *        a consumer that will call methods on {@link ModelPackageStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageStatusDetails(ModelPackageStatusDetails)
         */
        default Builder modelPackageStatusDetails(Consumer<ModelPackageStatusDetails.Builder> modelPackageStatusDetails) {
            return modelPackageStatusDetails(ModelPackageStatusDetails.builder().applyMutation(modelPackageStatusDetails).build());
        }

        /**
         * <p>
         * Whether the model package is certified for listing on Amazon Web Services Marketplace.
         * </p>
         * 
         * @param certifyForMarketplace
         *        Whether the model package is certified for listing on Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifyForMarketplace(Boolean certifyForMarketplace);

        /**
         * <p>
         * The approval status of the model package.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model package.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(String modelApprovalStatus);

        /**
         * <p>
         * The approval status of the model package.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model package.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetadataProperties.Builder} avoiding the need to
         * create one manually via {@link MetadataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * Metrics for the model.
         * </p>
         * 
         * @param modelMetrics
         *        Metrics for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetrics(ModelMetrics modelMetrics);

        /**
         * <p>
         * Metrics for the model.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelMetrics.Builder} avoiding the need to
         * create one manually via {@link ModelMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #modelMetrics(ModelMetrics)}.
         * 
         * @param modelMetrics
         *        a consumer that will call methods on {@link ModelMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelMetrics(ModelMetrics)
         */
        default Builder modelMetrics(Consumer<ModelMetrics.Builder> modelMetrics) {
            return modelMetrics(ModelMetrics.builder().applyMutation(modelMetrics).build());
        }

        /**
         * <p>
         * The last time the model package was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the model package was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * A description provided for the model approval.
         * </p>
         * 
         * @param approvalDescription
         *        A description provided for the model approval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDescription(String approvalDescription);

        /**
         * <p>
         * The metadata properties associated with the model package versions.
         * </p>
         * 
         * @param customerMetadataProperties
         *        The metadata properties associated with the model package versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetadataProperties(Map<String, String> customerMetadataProperties);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String modelPackageName;

        private String modelPackageGroupName;

        private Integer modelPackageVersion;

        private String modelPackageArn;

        private String modelPackageDescription;

        private Instant creationTime;

        private InferenceSpecification inferenceSpecification;

        private SourceAlgorithmSpecification sourceAlgorithmSpecification;

        private ModelPackageValidationSpecification validationSpecification;

        private String modelPackageStatus;

        private ModelPackageStatusDetails modelPackageStatusDetails;

        private Boolean certifyForMarketplace;

        private String modelApprovalStatus;

        private UserContext createdBy;

        private MetadataProperties metadataProperties;

        private ModelMetrics modelMetrics;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private String approvalDescription;

        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackageResponse model) {
            super(model);
            modelPackageName(model.modelPackageName);
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageVersion(model.modelPackageVersion);
            modelPackageArn(model.modelPackageArn);
            modelPackageDescription(model.modelPackageDescription);
            creationTime(model.creationTime);
            inferenceSpecification(model.inferenceSpecification);
            sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            validationSpecification(model.validationSpecification);
            modelPackageStatus(model.modelPackageStatus);
            modelPackageStatusDetails(model.modelPackageStatusDetails);
            certifyForMarketplace(model.certifyForMarketplace);
            modelApprovalStatus(model.modelApprovalStatus);
            createdBy(model.createdBy);
            metadataProperties(model.metadataProperties);
            modelMetrics(model.modelMetrics);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            approvalDescription(model.approvalDescription);
            customerMetadataProperties(model.customerMetadataProperties);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        @Transient
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        @Transient
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final Integer getModelPackageVersion() {
            return modelPackageVersion;
        }

        public final void setModelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
        }

        @Override
        @Transient
        public final Builder modelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        @Transient
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        @Transient
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.toBuilder() : null;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return validationSpecification != null ? validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final String getModelPackageStatus() {
            return modelPackageStatus;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        @Override
        @Transient
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final ModelPackageStatusDetails.Builder getModelPackageStatusDetails() {
            return modelPackageStatusDetails != null ? modelPackageStatusDetails.toBuilder() : null;
        }

        public final void setModelPackageStatusDetails(ModelPackageStatusDetails.BuilderImpl modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails != null ? modelPackageStatusDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        @Transient
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final String getModelApprovalStatus() {
            return modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final ModelMetrics.Builder getModelMetrics() {
            return modelMetrics != null ? modelMetrics.toBuilder() : null;
        }

        public final void setModelMetrics(ModelMetrics.BuilderImpl modelMetrics) {
            this.modelMetrics = modelMetrics != null ? modelMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder modelMetrics(ModelMetrics modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getApprovalDescription() {
            return approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        @Transient
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        @Transient
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        @Override
        public DescribeModelPackageResponse build() {
            return new DescribeModelPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
