/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFlowDefinitionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateFlowDefinitionRequest.Builder, CreateFlowDefinitionRequest> {
    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowDefinitionName").getter(getter(CreateFlowDefinitionRequest::flowDefinitionName))
            .setter(setter(Builder::flowDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build())
            .build();

    private static final SdkField<HumanLoopRequestSource> HUMAN_LOOP_REQUEST_SOURCE_FIELD = SdkField
            .<HumanLoopRequestSource> builder(MarshallingType.SDK_POJO).memberName("HumanLoopRequestSource")
            .getter(getter(CreateFlowDefinitionRequest::humanLoopRequestSource)).setter(setter(Builder::humanLoopRequestSource))
            .constructor(HumanLoopRequestSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopRequestSource").build())
            .build();

    private static final SdkField<HumanLoopActivationConfig> HUMAN_LOOP_ACTIVATION_CONFIG_FIELD = SdkField
            .<HumanLoopActivationConfig> builder(MarshallingType.SDK_POJO).memberName("HumanLoopActivationConfig")
            .getter(getter(CreateFlowDefinitionRequest::humanLoopActivationConfig))
            .setter(setter(Builder::humanLoopActivationConfig)).constructor(HumanLoopActivationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConfig").build())
            .build();

    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField
            .<HumanLoopConfig> builder(MarshallingType.SDK_POJO).memberName("HumanLoopConfig")
            .getter(getter(CreateFlowDefinitionRequest::humanLoopConfig)).setter(setter(Builder::humanLoopConfig))
            .constructor(HumanLoopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()).build();

    private static final SdkField<FlowDefinitionOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<FlowDefinitionOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateFlowDefinitionRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(FlowDefinitionOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateFlowDefinitionRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFlowDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_NAME_FIELD,
            HUMAN_LOOP_REQUEST_SOURCE_FIELD, HUMAN_LOOP_ACTIVATION_CONFIG_FIELD, HUMAN_LOOP_CONFIG_FIELD, OUTPUT_CONFIG_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD));

    private final String flowDefinitionName;

    private final HumanLoopRequestSource humanLoopRequestSource;

    private final HumanLoopActivationConfig humanLoopActivationConfig;

    private final HumanLoopConfig humanLoopConfig;

    private final FlowDefinitionOutputConfig outputConfig;

    private final String roleArn;

    private final List<Tag> tags;

    private CreateFlowDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.flowDefinitionName = builder.flowDefinitionName;
        this.humanLoopRequestSource = builder.humanLoopRequestSource;
        this.humanLoopActivationConfig = builder.humanLoopActivationConfig;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of your flow definition.
     * </p>
     * 
     * @return The name of your flow definition.
     */
    public final String flowDefinitionName() {
        return flowDefinitionName;
    }

    /**
     * <p>
     * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon
     * Textract is used as an integration source.
     * </p>
     * 
     * @return Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or
     *         Amazon Textract is used as an integration source.
     */
    public final HumanLoopRequestSource humanLoopRequestSource() {
        return humanLoopRequestSource;
    }

    /**
     * <p>
     * An object containing information about the events that trigger a human workflow.
     * </p>
     * 
     * @return An object containing information about the events that trigger a human workflow.
     */
    public final HumanLoopActivationConfig humanLoopActivationConfig() {
        return humanLoopActivationConfig;
    }

    /**
     * <p>
     * An object containing information about the tasks the human reviewers will perform.
     * </p>
     * 
     * @return An object containing information about the tasks the human reviewers will perform.
     */
    public final HumanLoopConfig humanLoopConfig() {
        return humanLoopConfig;
    }

    /**
     * <p>
     * An object containing information about where the human review results will be uploaded.
     * </p>
     * 
     * @return An object containing information about where the human review results will be uploaded.
     */
    public final FlowDefinitionOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example,
     * <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example,
     *         <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag
     * consists of a key and a value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs that contain metadata to help you categorize and organize a flow definition.
     *         Each tag consists of a key and a value, both of which you define.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopRequestSource());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowDefinitionRequest)) {
            return false;
        }
        CreateFlowDefinitionRequest other = (CreateFlowDefinitionRequest) obj;
        return Objects.equals(flowDefinitionName(), other.flowDefinitionName())
                && Objects.equals(humanLoopRequestSource(), other.humanLoopRequestSource())
                && Objects.equals(humanLoopActivationConfig(), other.humanLoopActivationConfig())
                && Objects.equals(humanLoopConfig(), other.humanLoopConfig())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFlowDefinitionRequest").add("FlowDefinitionName", flowDefinitionName())
                .add("HumanLoopRequestSource", humanLoopRequestSource())
                .add("HumanLoopActivationConfig", humanLoopActivationConfig()).add("HumanLoopConfig", humanLoopConfig())
                .add("OutputConfig", outputConfig()).add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowDefinitionName":
            return Optional.ofNullable(clazz.cast(flowDefinitionName()));
        case "HumanLoopRequestSource":
            return Optional.ofNullable(clazz.cast(humanLoopRequestSource()));
        case "HumanLoopActivationConfig":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConfig()));
        case "HumanLoopConfig":
            return Optional.ofNullable(clazz.cast(humanLoopConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowDefinitionRequest, T> g) {
        return obj -> g.apply((CreateFlowDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFlowDefinitionRequest> {
        /**
         * <p>
         * The name of your flow definition.
         * </p>
         * 
         * @param flowDefinitionName
         *        The name of your flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionName(String flowDefinitionName);

        /**
         * <p>
         * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon
         * Textract is used as an integration source.
         * </p>
         * 
         * @param humanLoopRequestSource
         *        Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or
         *        Amazon Textract is used as an integration source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource);

        /**
         * <p>
         * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon
         * Textract is used as an integration source.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopRequestSource.Builder} avoiding the
         * need to create one manually via {@link HumanLoopRequestSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopRequestSource.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopRequestSource(HumanLoopRequestSource)}.
         * 
         * @param humanLoopRequestSource
         *        a consumer that will call methods on {@link HumanLoopRequestSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopRequestSource(HumanLoopRequestSource)
         */
        default Builder humanLoopRequestSource(Consumer<HumanLoopRequestSource.Builder> humanLoopRequestSource) {
            return humanLoopRequestSource(HumanLoopRequestSource.builder().applyMutation(humanLoopRequestSource).build());
        }

        /**
         * <p>
         * An object containing information about the events that trigger a human workflow.
         * </p>
         * 
         * @param humanLoopActivationConfig
         *        An object containing information about the events that trigger a human workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig);

        /**
         * <p>
         * An object containing information about the events that trigger a human workflow.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationConfig.Builder} avoiding the
         * need to create one manually via {@link HumanLoopActivationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationConfig(HumanLoopActivationConfig)}.
         * 
         * @param humanLoopActivationConfig
         *        a consumer that will call methods on {@link HumanLoopActivationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationConfig(HumanLoopActivationConfig)
         */
        default Builder humanLoopActivationConfig(Consumer<HumanLoopActivationConfig.Builder> humanLoopActivationConfig) {
            return humanLoopActivationConfig(HumanLoopActivationConfig.builder().applyMutation(humanLoopActivationConfig).build());
        }

        /**
         * <p>
         * An object containing information about the tasks the human reviewers will perform.
         * </p>
         * 
         * @param humanLoopConfig
         *        An object containing information about the tasks the human reviewers will perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopConfig(HumanLoopConfig humanLoopConfig);

        /**
         * <p>
         * An object containing information about the tasks the human reviewers will perform.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopConfig.Builder} avoiding the need to
         * create one manually via {@link HumanLoopConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #humanLoopConfig(HumanLoopConfig)}.
         * 
         * @param humanLoopConfig
         *        a consumer that will call methods on {@link HumanLoopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopConfig(HumanLoopConfig)
         */
        default Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return humanLoopConfig(HumanLoopConfig.builder().applyMutation(humanLoopConfig).build());
        }

        /**
         * <p>
         * An object containing information about where the human review results will be uploaded.
         * </p>
         * 
         * @param outputConfig
         *        An object containing information about where the human review results will be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(FlowDefinitionOutputConfig outputConfig);

        /**
         * <p>
         * An object containing information about where the human review results will be uploaded.
         * </p>
         * This is a convenience that creates an instance of the {@link FlowDefinitionOutputConfig.Builder} avoiding the
         * need to create one manually via {@link FlowDefinitionOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlowDefinitionOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(FlowDefinitionOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link FlowDefinitionOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(FlowDefinitionOutputConfig)
         */
        default Builder outputConfig(Consumer<FlowDefinitionOutputConfig.Builder> outputConfig) {
            return outputConfig(FlowDefinitionOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example,
         * <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example,
         *        <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each
         * tag consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize a flow
         *        definition. Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each
         * tag consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize a flow
         *        definition. Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each
         * tag consists of a key and a value, both of which you define.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String flowDefinitionName;

        private HumanLoopRequestSource humanLoopRequestSource;

        private HumanLoopActivationConfig humanLoopActivationConfig;

        private HumanLoopConfig humanLoopConfig;

        private FlowDefinitionOutputConfig outputConfig;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowDefinitionRequest model) {
            super(model);
            flowDefinitionName(model.flowDefinitionName);
            humanLoopRequestSource(model.humanLoopRequestSource);
            humanLoopActivationConfig(model.humanLoopActivationConfig);
            humanLoopConfig(model.humanLoopConfig);
            outputConfig(model.outputConfig);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getFlowDefinitionName() {
            return flowDefinitionName;
        }

        @Override
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        public final HumanLoopRequestSource.Builder getHumanLoopRequestSource() {
            return humanLoopRequestSource != null ? humanLoopRequestSource.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource;
            return this;
        }

        public final void setHumanLoopRequestSource(HumanLoopRequestSource.BuilderImpl humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource != null ? humanLoopRequestSource.build() : null;
        }

        public final HumanLoopActivationConfig.Builder getHumanLoopActivationConfig() {
            return humanLoopActivationConfig != null ? humanLoopActivationConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig;
            return this;
        }

        public final void setHumanLoopActivationConfig(HumanLoopActivationConfig.BuilderImpl humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig != null ? humanLoopActivationConfig.build() : null;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return humanLoopConfig != null ? humanLoopConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        public final FlowDefinitionOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(FlowDefinitionOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(FlowDefinitionOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowDefinitionRequest build() {
            return new CreateFlowDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
