/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data quality constraints and statistics for a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDataQuality implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDataQuality.Builder, ModelDataQuality> {
    private static final SdkField<MetricsSource> STATISTICS_FIELD = SdkField.<MetricsSource> builder(MarshallingType.SDK_POJO)
            .memberName("Statistics").getter(getter(ModelDataQuality::statistics)).setter(setter(Builder::statistics))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final SdkField<MetricsSource> CONSTRAINTS_FIELD = SdkField.<MetricsSource> builder(MarshallingType.SDK_POJO)
            .memberName("Constraints").getter(getter(ModelDataQuality::constraints)).setter(setter(Builder::constraints))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD,
            CONSTRAINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricsSource statistics;

    private final MetricsSource constraints;

    private ModelDataQuality(BuilderImpl builder) {
        this.statistics = builder.statistics;
        this.constraints = builder.constraints;
    }

    /**
     * <p>
     * Data quality statistics for a model.
     * </p>
     * 
     * @return Data quality statistics for a model.
     */
    public final MetricsSource statistics() {
        return statistics;
    }

    /**
     * <p>
     * Data quality constraints for a model.
     * </p>
     * 
     * @return Data quality constraints for a model.
     */
    public final MetricsSource constraints() {
        return constraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(constraints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDataQuality)) {
            return false;
        }
        ModelDataQuality other = (ModelDataQuality) obj;
        return Objects.equals(statistics(), other.statistics()) && Objects.equals(constraints(), other.constraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDataQuality").add("Statistics", statistics()).add("Constraints", constraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "Constraints":
            return Optional.ofNullable(clazz.cast(constraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDataQuality, T> g) {
        return obj -> g.apply((ModelDataQuality) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDataQuality> {
        /**
         * <p>
         * Data quality statistics for a model.
         * </p>
         * 
         * @param statistics
         *        Data quality statistics for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(MetricsSource statistics);

        /**
         * <p>
         * Data quality statistics for a model.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricsSource.Builder} avoiding the need to
         * create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(MetricsSource)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(MetricsSource)
         */
        default Builder statistics(Consumer<MetricsSource.Builder> statistics) {
            return statistics(MetricsSource.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * Data quality constraints for a model.
         * </p>
         * 
         * @param constraints
         *        Data quality constraints for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(MetricsSource constraints);

        /**
         * <p>
         * Data quality constraints for a model.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricsSource.Builder} avoiding the need to
         * create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #constraints(MetricsSource)}.
         * 
         * @param constraints
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraints(MetricsSource)
         */
        default Builder constraints(Consumer<MetricsSource.Builder> constraints) {
            return constraints(MetricsSource.builder().applyMutation(constraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricsSource statistics;

        private MetricsSource constraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDataQuality model) {
            statistics(model.statistics);
            constraints(model.constraints);
        }

        public final MetricsSource.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(MetricsSource statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(MetricsSource.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final MetricsSource.Builder getConstraints() {
            return constraints != null ? constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(MetricsSource constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(MetricsSource.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public ModelDataQuality build() {
            return new ModelDataQuality(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
