/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or <code>KMSKeyId</code>, for at
 * rest data encryption. You can turn <code>OnlineStore</code> on or off by specifying the
 * <code>EnableOnlineStore</code> flag at General Assembly; the default value is <code>False</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnlineStoreConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OnlineStoreConfig.Builder, OnlineStoreConfig> {
    private static final SdkField<OnlineStoreSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<OnlineStoreSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(OnlineStoreConfig::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(OnlineStoreSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<Boolean> ENABLE_ONLINE_STORE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableOnlineStore").getter(getter(OnlineStoreConfig::enableOnlineStore))
            .setter(setter(Builder::enableOnlineStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableOnlineStore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIG_FIELD,
            ENABLE_ONLINE_STORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final OnlineStoreSecurityConfig securityConfig;

    private final Boolean enableOnlineStore;

    private OnlineStoreConfig(BuilderImpl builder) {
        this.securityConfig = builder.securityConfig;
        this.enableOnlineStore = builder.enableOnlineStore;
    }

    /**
     * <p>
     * Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.
     * </p>
     * 
     * @return Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>
     *         .
     */
    public final OnlineStoreSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag.
     * Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag.
     * </p>
     * <p>
     * The default value is <code>False</code>.
     * </p>
     * 
     * @return Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code>
     *         flag. Turn <code>OnlineStore</code> on by specifying <code>True</code> for the
     *         <code>EnableOnlineStore</code> flag. </p>
     *         <p>
     *         The default value is <code>False</code>.
     */
    public final Boolean enableOnlineStore() {
        return enableOnlineStore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(enableOnlineStore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineStoreConfig)) {
            return false;
        }
        OnlineStoreConfig other = (OnlineStoreConfig) obj;
        return Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(enableOnlineStore(), other.enableOnlineStore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnlineStoreConfig").add("SecurityConfig", securityConfig())
                .add("EnableOnlineStore", enableOnlineStore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "EnableOnlineStore":
            return Optional.ofNullable(clazz.cast(enableOnlineStore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnlineStoreConfig, T> g) {
        return obj -> g.apply((OnlineStoreConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnlineStoreConfig> {
        /**
         * <p>
         * Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.
         * </p>
         * 
         * @param securityConfig
         *        Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your
         *        <code>OnlineStore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(OnlineStoreSecurityConfig securityConfig);

        /**
         * <p>
         * Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link OnlineStoreSecurityConfig.Builder} avoiding the
         * need to create one manually via {@link OnlineStoreSecurityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnlineStoreSecurityConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #securityConfig(OnlineStoreSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link OnlineStoreSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(OnlineStoreSecurityConfig)
         */
        default Builder securityConfig(Consumer<OnlineStoreSecurityConfig.Builder> securityConfig) {
            return securityConfig(OnlineStoreSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code>
         * flag. Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code>
         * flag.
         * </p>
         * <p>
         * The default value is <code>False</code>.
         * </p>
         * 
         * @param enableOnlineStore
         *        Turn <code>OnlineStore</code> off by specifying <code>False</code> for the
         *        <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code> on by specifying <code>True</code>
         *        for the <code>EnableOnlineStore</code> flag. </p>
         *        <p>
         *        The default value is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableOnlineStore(Boolean enableOnlineStore);
    }

    static final class BuilderImpl implements Builder {
        private OnlineStoreSecurityConfig securityConfig;

        private Boolean enableOnlineStore;

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineStoreConfig model) {
            securityConfig(model.securityConfig);
            enableOnlineStore(model.enableOnlineStore);
        }

        public final OnlineStoreSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        @Override
        public final Builder securityConfig(OnlineStoreSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final void setSecurityConfig(OnlineStoreSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        public final Boolean getEnableOnlineStore() {
            return enableOnlineStore;
        }

        @Override
        public final Builder enableOnlineStore(Boolean enableOnlineStore) {
            this.enableOnlineStore = enableOnlineStore;
            return this;
        }

        public final void setEnableOnlineStore(Boolean enableOnlineStore) {
            this.enableOnlineStore = enableOnlineStore;
        }

        @Override
        public OnlineStoreConfig build() {
            return new OnlineStoreConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
