/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdatePipelineRequest.Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(UpdatePipelineRequest::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDisplayName").getter(getter(UpdatePipelineRequest::pipelineDisplayName))
            .setter(setter(Builder::pipelineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDefinition").getter(getter(UpdatePipelineRequest::pipelineDefinition))
            .setter(setter(Builder::pipelineDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build())
            .build();

    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDescription").getter(getter(UpdatePipelineRequest::pipelineDescription))
            .setter(setter(Builder::pipelineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdatePipelineRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD));

    private final String pipelineName;

    private final String pipelineDisplayName;

    private final String pipelineDefinition;

    private final String pipelineDescription;

    private final String roleArn;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the pipeline to update.
     * </p>
     * 
     * @return The name of the pipeline to update.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline.
     * </p>
     * 
     * @return The display name of the pipeline.
     */
    public final String pipelineDisplayName() {
        return pipelineDisplayName;
    }

    /**
     * <p>
     * The JSON pipeline definition.
     * </p>
     * 
     * @return The JSON pipeline definition.
     */
    public final String pipelineDefinition() {
        return pipelineDefinition;
    }

    /**
     * <p>
     * The description of the pipeline.
     * </p>
     * 
     * @return The description of the pipeline.
     */
    public final String pipelineDescription() {
        return pipelineDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that the pipeline uses to execute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that the pipeline uses to execute.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineDisplayName(), other.pipelineDisplayName())
                && Objects.equals(pipelineDefinition(), other.pipelineDefinition())
                && Objects.equals(pipelineDescription(), other.pipelineDescription())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineRequest").add("PipelineName", pipelineName())
                .add("PipelineDisplayName", pipelineDisplayName()).add("PipelineDefinition", pipelineDefinition())
                .add("PipelineDescription", pipelineDescription()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineDisplayName()));
        case "PipelineDefinition":
            return Optional.ofNullable(clazz.cast(pipelineDefinition()));
        case "PipelineDescription":
            return Optional.ofNullable(clazz.cast(pipelineDescription()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline to update.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline.
         * </p>
         * 
         * @param pipelineDisplayName
         *        The display name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDisplayName(String pipelineDisplayName);

        /**
         * <p>
         * The JSON pipeline definition.
         * </p>
         * 
         * @param pipelineDefinition
         *        The JSON pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDefinition(String pipelineDefinition);

        /**
         * <p>
         * The description of the pipeline.
         * </p>
         * 
         * @param pipelineDescription
         *        The description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescription(String pipelineDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that the pipeline uses to execute.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that the pipeline uses to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String pipelineDisplayName;

        private String pipelineDefinition;

        private String pipelineDescription;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineDisplayName(model.pipelineDisplayName);
            pipelineDefinition(model.pipelineDefinition);
            pipelineDescription(model.pipelineDescription);
            roleArn(model.roleArn);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineDisplayName() {
            return pipelineDisplayName;
        }

        @Override
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        public final String getPipelineDefinition() {
            return pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        public final String getPipelineDescription() {
            return pipelineDescription;
        }

        @Override
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
