/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantCoreDumpConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantCoreDumpConfig> {
    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationS3Uri").getter(ProductionVariantCoreDumpConfig.getter(ProductionVariantCoreDumpConfig::destinationS3Uri)).setter(ProductionVariantCoreDumpConfig.setter(Builder::destinationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ProductionVariantCoreDumpConfig.getter(ProductionVariantCoreDumpConfig::kmsKeyId)).setter(ProductionVariantCoreDumpConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_S3_URI_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationS3Uri;
    private final String kmsKeyId;

    private ProductionVariantCoreDumpConfig(BuilderImpl builder) {
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String destinationS3Uri() {
        return this.destinationS3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantCoreDumpConfig)) {
            return false;
        }
        ProductionVariantCoreDumpConfig other = (ProductionVariantCoreDumpConfig)obj;
        return Objects.equals(this.destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantCoreDumpConfig").add("DestinationS3Uri", (Object)this.destinationS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantCoreDumpConfig, T> g) {
        return obj -> g.apply((ProductionVariantCoreDumpConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationS3Uri;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantCoreDumpConfig model) {
            this.destinationS3Uri(model.destinationS3Uri);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getDestinationS3Uri() {
            return this.destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public ProductionVariantCoreDumpConfig build() {
            return new ProductionVariantCoreDumpConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantCoreDumpConfig> {
        public Builder destinationS3Uri(String var1);

        public Builder kmsKeyId(String var1);
    }
}

