/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.AppImageConfigDetails;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;

public class ListAppImageConfigsIterable
implements SdkIterable<ListAppImageConfigsResponse> {
    private final SageMakerClient client;
    private final ListAppImageConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppImageConfigsIterable(SageMakerClient client, ListAppImageConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppImageConfigsResponseFetcher();
    }

    public Iterator<ListAppImageConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AppImageConfigDetails> appImageConfigs() {
        Function<ListAppImageConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appImageConfigs() != null) {
                return response.appImageConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppImageConfigsResponseFetcher
    implements SyncPageFetcher<ListAppImageConfigsResponse> {
        private ListAppImageConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppImageConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppImageConfigsResponse nextPage(ListAppImageConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListAppImageConfigsIterable.this.client.listAppImageConfigs(ListAppImageConfigsIterable.this.firstRequest);
            }
            return ListAppImageConfigsIterable.this.client.listAppImageConfigs((ListAppImageConfigsRequest)((Object)ListAppImageConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

