/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ImageStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeImageResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeImageResponse.getter(DescribeImageResponse::creationTime)).setter(DescribeImageResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeImageResponse.getter(DescribeImageResponse::description)).setter(DescribeImageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeImageResponse.getter(DescribeImageResponse::displayName)).setter(DescribeImageResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeImageResponse.getter(DescribeImageResponse::failureReason)).setter(DescribeImageResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageArn").getter(DescribeImageResponse.getter(DescribeImageResponse::imageArn)).setter(DescribeImageResponse.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(DescribeImageResponse.getter(DescribeImageResponse::imageName)).setter(DescribeImageResponse.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageStatus").getter(DescribeImageResponse.getter(DescribeImageResponse::imageStatusAsString)).setter(DescribeImageResponse.setter(Builder::imageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeImageResponse.getter(DescribeImageResponse::lastModifiedTime)).setter(DescribeImageResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeImageResponse.getter(DescribeImageResponse::roleArn)).setter(DescribeImageResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_NAME_FIELD, IMAGE_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD));
    private final Instant creationTime;
    private final String description;
    private final String displayName;
    private final String failureReason;
    private final String imageArn;
    private final String imageName;
    private final String imageStatus;
    private final Instant lastModifiedTime;
    private final String roleArn;

    private DescribeImageResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageName = builder.imageName;
        this.imageStatus = builder.imageStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String imageArn() {
        return this.imageArn;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final ImageStatus imageStatus() {
        return ImageStatus.fromValue(this.imageStatus);
    }

    public final String imageStatusAsString() {
        return this.imageStatus;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageResponse)) {
            return false;
        }
        DescribeImageResponse other = (DescribeImageResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageStatusAsString(), other.imageStatusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageResponse").add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("FailureReason", (Object)this.failureReason()).add("ImageArn", (Object)this.imageArn()).add("ImageName", (Object)this.imageName()).add("ImageStatus", (Object)this.imageStatusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageStatus": {
                return Optional.ofNullable(clazz.cast(this.imageStatusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageResponse, T> g) {
        return obj -> g.apply((DescribeImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String description;
        private String displayName;
        private String failureReason;
        private String imageArn;
        private String imageName;
        private String imageStatus;
        private Instant lastModifiedTime;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.displayName(model.displayName);
            this.failureReason(model.failureReason);
            this.imageArn(model.imageArn);
            this.imageName(model.imageName);
            this.imageStatus(model.imageStatus);
            this.lastModifiedTime(model.lastModifiedTime);
            this.roleArn(model.roleArn);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        @Transient
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        @Transient
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageStatus() {
            return this.imageStatus;
        }

        public final void setImageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
        }

        @Override
        @Transient
        public final Builder imageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder imageStatus(ImageStatus imageStatus) {
            this.imageStatus(imageStatus == null ? null : imageStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DescribeImageResponse build() {
            return new DescribeImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageResponse> {
        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder failureReason(String var1);

        public Builder imageArn(String var1);

        public Builder imageName(String var1);

        public Builder imageStatus(String var1);

        public Builder imageStatus(ImageStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder roleArn(String var1);
    }
}

