/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A version of a SageMaker <code>Image</code>. A version represents an existing container image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageVersion implements SdkPojo, Serializable, ToCopyableBuilder<ImageVersion.Builder, ImageVersion> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ImageVersion::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(ImageVersion::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(ImageVersion::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionArn").getter(getter(ImageVersion::imageVersionArn)).setter(setter(Builder::imageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionStatus").getter(getter(ImageVersion::imageVersionStatusAsString))
            .setter(setter(Builder::imageVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionStatus").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ImageVersion::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(ImageVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_VERSION_ARN_FIELD, IMAGE_VERSION_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD,
            VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String failureReason;

    private final String imageArn;

    private final String imageVersionArn;

    private final String imageVersionStatus;

    private final Instant lastModifiedTime;

    private final Integer version;

    private ImageVersion(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageVersionArn = builder.imageVersionArn;
        this.imageVersionStatus = builder.imageVersionStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.version = builder.version;
    }

    /**
     * <p>
     * When the version was created.
     * </p>
     * 
     * @return When the version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When a create or delete operation fails, the reason for the failure.
     * </p>
     * 
     * @return When a create or delete operation fails, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image the version is based on.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image the version is based on.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The ARN of the version.
     * </p>
     * 
     * @return The ARN of the version.
     */
    public final String imageVersionArn() {
        return imageVersionArn;
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final ImageVersionStatus imageVersionStatus() {
        return ImageVersionStatus.fromValue(imageVersionStatus);
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final String imageVersionStatusAsString() {
        return imageVersionStatus;
    }

    /**
     * <p>
     * When the version was last modified.
     * </p>
     * 
     * @return When the version was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(imageVersionArn(), other.imageVersionArn())
                && Objects.equals(imageVersionStatusAsString(), other.imageVersionStatusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageVersion").add("CreationTime", creationTime()).add("FailureReason", failureReason())
                .add("ImageArn", imageArn()).add("ImageVersionArn", imageVersionArn())
                .add("ImageVersionStatus", imageVersionStatusAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "ImageVersionArn":
            return Optional.ofNullable(clazz.cast(imageVersionArn()));
        case "ImageVersionStatus":
            return Optional.ofNullable(clazz.cast(imageVersionStatusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageVersion> {
        /**
         * <p>
         * When the version was created.
         * </p>
         * 
         * @param creationTime
         *        When the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When a create or delete operation fails, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        When a create or delete operation fails, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image the version is based on.
         * </p>
         * 
         * @param imageArn
         *        The Amazon Resource Name (ARN) of the image the version is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The ARN of the version.
         * </p>
         * 
         * @param imageVersionArn
         *        The ARN of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionArn(String imageVersionArn);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(String imageVersionStatus);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(ImageVersionStatus imageVersionStatus);

        /**
         * <p>
         * When the version was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the version was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String failureReason;

        private String imageArn;

        private String imageVersionArn;

        private String imageVersionStatus;

        private Instant lastModifiedTime;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            imageArn(model.imageArn);
            imageVersionArn(model.imageVersionArn);
            imageVersionStatus(model.imageVersionStatus);
            lastModifiedTime(model.lastModifiedTime);
            version(model.version);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        @Transient
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageVersionArn() {
            return imageVersionArn;
        }

        public final void setImageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
        }

        @Override
        @Transient
        public final Builder imageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
            return this;
        }

        public final String getImageVersionStatus() {
            return imageVersionStatus;
        }

        public final void setImageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
        }

        @Override
        @Transient
        public final Builder imageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder imageVersionStatus(ImageVersionStatus imageVersionStatus) {
            this.imageVersionStatus(imageVersionStatus == null ? null : imageVersionStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        @Override
        public ImageVersion build() {
            return new ImageVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
