/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of artifacts for an AutoML candidate job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CandidateArtifactLocations implements SdkPojo, Serializable,
        ToCopyableBuilder<CandidateArtifactLocations.Builder, CandidateArtifactLocations> {
    private static final SdkField<String> EXPLAINABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Explainability").getter(getter(CandidateArtifactLocations::explainability))
            .setter(setter(Builder::explainability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String explainability;

    private CandidateArtifactLocations(BuilderImpl builder) {
        this.explainability = builder.explainability;
    }

    /**
     * <p>
     * The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.
     * </p>
     * 
     * @return The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.
     */
    public final String explainability() {
        return explainability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(explainability());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateArtifactLocations)) {
            return false;
        }
        CandidateArtifactLocations other = (CandidateArtifactLocations) obj;
        return Objects.equals(explainability(), other.explainability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CandidateArtifactLocations").add("Explainability", explainability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Explainability":
            return Optional.ofNullable(clazz.cast(explainability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CandidateArtifactLocations, T> g) {
        return obj -> g.apply((CandidateArtifactLocations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CandidateArtifactLocations> {
        /**
         * <p>
         * The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.
         * </p>
         * 
         * @param explainability
         *        The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainability(String explainability);
    }

    static final class BuilderImpl implements Builder {
        private String explainability;

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateArtifactLocations model) {
            explainability(model.explainability);
        }

        public final String getExplainability() {
            return explainability;
        }

        public final void setExplainability(String explainability) {
            this.explainability = explainability;
        }

        @Override
        @Transient
        public final Builder explainability(String explainability) {
            this.explainability = explainability;
            return this;
        }

        @Override
        public CandidateArtifactLocations build() {
            return new CandidateArtifactLocations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
