/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the steps for a candidate and what step it is working on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLCandidateStep implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLCandidateStep.Builder, AutoMLCandidateStep> {
    private static final SdkField<String> CANDIDATE_STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateStepType").getter(getter(AutoMLCandidateStep::candidateStepTypeAsString))
            .setter(setter(Builder::candidateStepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepType").build()).build();

    private static final SdkField<String> CANDIDATE_STEP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateStepArn").getter(getter(AutoMLCandidateStep::candidateStepArn))
            .setter(setter(Builder::candidateStepArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepArn").build()).build();

    private static final SdkField<String> CANDIDATE_STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateStepName").getter(getter(AutoMLCandidateStep::candidateStepName))
            .setter(setter(Builder::candidateStepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_STEP_TYPE_FIELD,
            CANDIDATE_STEP_ARN_FIELD, CANDIDATE_STEP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String candidateStepType;

    private final String candidateStepArn;

    private final String candidateStepName;

    private AutoMLCandidateStep(BuilderImpl builder) {
        this.candidateStepType = builder.candidateStepType;
        this.candidateStepArn = builder.candidateStepArn;
        this.candidateStepName = builder.candidateStepName;
    }

    /**
     * <p>
     * Whether the candidate is at the transform, training, or processing step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStepType}
     * will return {@link CandidateStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStepTypeAsString}.
     * </p>
     * 
     * @return Whether the candidate is at the transform, training, or processing step.
     * @see CandidateStepType
     */
    public final CandidateStepType candidateStepType() {
        return CandidateStepType.fromValue(candidateStepType);
    }

    /**
     * <p>
     * Whether the candidate is at the transform, training, or processing step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStepType}
     * will return {@link CandidateStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStepTypeAsString}.
     * </p>
     * 
     * @return Whether the candidate is at the transform, training, or processing step.
     * @see CandidateStepType
     */
    public final String candidateStepTypeAsString() {
        return candidateStepType;
    }

    /**
     * <p>
     * The ARN for the candidate's step.
     * </p>
     * 
     * @return The ARN for the candidate's step.
     */
    public final String candidateStepArn() {
        return candidateStepArn;
    }

    /**
     * <p>
     * The name for the candidate's step.
     * </p>
     * 
     * @return The name for the candidate's step.
     */
    public final String candidateStepName() {
        return candidateStepName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateStepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(candidateStepArn());
        hashCode = 31 * hashCode + Objects.hashCode(candidateStepName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidateStep)) {
            return false;
        }
        AutoMLCandidateStep other = (AutoMLCandidateStep) obj;
        return Objects.equals(candidateStepTypeAsString(), other.candidateStepTypeAsString())
                && Objects.equals(candidateStepArn(), other.candidateStepArn())
                && Objects.equals(candidateStepName(), other.candidateStepName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLCandidateStep").add("CandidateStepType", candidateStepTypeAsString())
                .add("CandidateStepArn", candidateStepArn()).add("CandidateStepName", candidateStepName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateStepType":
            return Optional.ofNullable(clazz.cast(candidateStepTypeAsString()));
        case "CandidateStepArn":
            return Optional.ofNullable(clazz.cast(candidateStepArn()));
        case "CandidateStepName":
            return Optional.ofNullable(clazz.cast(candidateStepName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidateStep, T> g) {
        return obj -> g.apply((AutoMLCandidateStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLCandidateStep> {
        /**
         * <p>
         * Whether the candidate is at the transform, training, or processing step.
         * </p>
         * 
         * @param candidateStepType
         *        Whether the candidate is at the transform, training, or processing step.
         * @see CandidateStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStepType
         */
        Builder candidateStepType(String candidateStepType);

        /**
         * <p>
         * Whether the candidate is at the transform, training, or processing step.
         * </p>
         * 
         * @param candidateStepType
         *        Whether the candidate is at the transform, training, or processing step.
         * @see CandidateStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStepType
         */
        Builder candidateStepType(CandidateStepType candidateStepType);

        /**
         * <p>
         * The ARN for the candidate's step.
         * </p>
         * 
         * @param candidateStepArn
         *        The ARN for the candidate's step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateStepArn(String candidateStepArn);

        /**
         * <p>
         * The name for the candidate's step.
         * </p>
         * 
         * @param candidateStepName
         *        The name for the candidate's step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateStepName(String candidateStepName);
    }

    static final class BuilderImpl implements Builder {
        private String candidateStepType;

        private String candidateStepArn;

        private String candidateStepName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidateStep model) {
            candidateStepType(model.candidateStepType);
            candidateStepArn(model.candidateStepArn);
            candidateStepName(model.candidateStepName);
        }

        public final String getCandidateStepType() {
            return candidateStepType;
        }

        public final void setCandidateStepType(String candidateStepType) {
            this.candidateStepType = candidateStepType;
        }

        @Override
        @Transient
        public final Builder candidateStepType(String candidateStepType) {
            this.candidateStepType = candidateStepType;
            return this;
        }

        @Override
        @Transient
        public final Builder candidateStepType(CandidateStepType candidateStepType) {
            this.candidateStepType(candidateStepType == null ? null : candidateStepType.toString());
            return this;
        }

        public final String getCandidateStepArn() {
            return candidateStepArn;
        }

        public final void setCandidateStepArn(String candidateStepArn) {
            this.candidateStepArn = candidateStepArn;
        }

        @Override
        @Transient
        public final Builder candidateStepArn(String candidateStepArn) {
            this.candidateStepArn = candidateStepArn;
            return this;
        }

        public final String getCandidateStepName() {
            return candidateStepName;
        }

        public final void setCandidateStepName(String candidateStepName) {
            this.candidateStepName = candidateStepName;
        }

        @Override
        @Transient
        public final Builder candidateStepName(String candidateStepName) {
            this.candidateStepName = candidateStepName;
            return this;
        }

        @Override
        public AutoMLCandidateStep build() {
            return new AutoMLCandidateStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
