/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retention policy for data stored on an Amazon Elastic File System (EFS) volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionPolicy implements SdkPojo, Serializable, ToCopyableBuilder<RetentionPolicy.Builder, RetentionPolicy> {
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeEfsFileSystem").getter(getter(RetentionPolicy::homeEfsFileSystemAsString))
            .setter(setter(Builder::homeEfsFileSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_EFS_FILE_SYSTEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String homeEfsFileSystem;

    private RetentionPolicy(BuilderImpl builder) {
        this.homeEfsFileSystem = builder.homeEfsFileSystem;
    }

    /**
     * <p>
     * The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.
     * </p>
     * <p>
     * Specify <code>Delete</code> to delete the data stored on the EFS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeEfsFileSystem}
     * will return {@link RetentionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #homeEfsFileSystemAsString}.
     * </p>
     * 
     * @return The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p>
     *         <p>
     *         Specify <code>Delete</code> to delete the data stored on the EFS volume.
     * @see RetentionType
     */
    public final RetentionType homeEfsFileSystem() {
        return RetentionType.fromValue(homeEfsFileSystem);
    }

    /**
     * <p>
     * The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.
     * </p>
     * <p>
     * Specify <code>Delete</code> to delete the data stored on the EFS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeEfsFileSystem}
     * will return {@link RetentionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #homeEfsFileSystemAsString}.
     * </p>
     * 
     * @return The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p>
     *         <p>
     *         Specify <code>Delete</code> to delete the data stored on the EFS volume.
     * @see RetentionType
     */
    public final String homeEfsFileSystemAsString() {
        return homeEfsFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionPolicy)) {
            return false;
        }
        RetentionPolicy other = (RetentionPolicy) obj;
        return Objects.equals(homeEfsFileSystemAsString(), other.homeEfsFileSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionPolicy").add("HomeEfsFileSystem", homeEfsFileSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeEfsFileSystem":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionPolicy, T> g) {
        return obj -> g.apply((RetentionPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionPolicy> {
        /**
         * <p>
         * The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.
         * </p>
         * <p>
         * Specify <code>Delete</code> to delete the data stored on the EFS volume.
         * </p>
         * 
         * @param homeEfsFileSystem
         *        The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p>
         *        <p>
         *        Specify <code>Delete</code> to delete the data stored on the EFS volume.
         * @see RetentionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionType
         */
        Builder homeEfsFileSystem(String homeEfsFileSystem);

        /**
         * <p>
         * The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.
         * </p>
         * <p>
         * Specify <code>Delete</code> to delete the data stored on the EFS volume.
         * </p>
         * 
         * @param homeEfsFileSystem
         *        The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p>
         *        <p>
         *        Specify <code>Delete</code> to delete the data stored on the EFS volume.
         * @see RetentionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionType
         */
        Builder homeEfsFileSystem(RetentionType homeEfsFileSystem);
    }

    static final class BuilderImpl implements Builder {
        private String homeEfsFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionPolicy model) {
            homeEfsFileSystem(model.homeEfsFileSystem);
        }

        public final String getHomeEfsFileSystem() {
            return homeEfsFileSystem;
        }

        public final void setHomeEfsFileSystem(String homeEfsFileSystem) {
            this.homeEfsFileSystem = homeEfsFileSystem;
        }

        @Override
        @Transient
        public final Builder homeEfsFileSystem(String homeEfsFileSystem) {
            this.homeEfsFileSystem = homeEfsFileSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder homeEfsFileSystem(RetentionType homeEfsFileSystem) {
            this.homeEfsFileSystem(homeEfsFileSystem == null ? null : homeEfsFileSystem.toString());
            return this;
        }

        @Override
        public RetentionPolicy build() {
            return new RetentionPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
