/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitoringScheduleRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateMonitoringScheduleRequest.Builder, CreateMonitoringScheduleRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(CreateMonitoringScheduleRequest::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField
            .<MonitoringScheduleConfig> builder(MarshallingType.SDK_POJO).memberName("MonitoringScheduleConfig")
            .getter(getter(CreateMonitoringScheduleRequest::monitoringScheduleConfig))
            .setter(setter(Builder::monitoringScheduleConfig)).constructor(MonitoringScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMonitoringScheduleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD, TAGS_FIELD));

    private final String monitoringScheduleName;

    private final MonitoringScheduleConfig monitoringScheduleConfig;

    private final List<Tag> tags;

    private CreateMonitoringScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an
     * Amazon Web Services account.
     * </p>
     * 
     * @return The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within
     *         an Amazon Web Services account.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     * </p>
     * 
     * @return The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    public final MonitoringScheduleConfig monitoringScheduleConfig() {
        return monitoringScheduleConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitoringScheduleRequest)) {
            return false;
        }
        CreateMonitoringScheduleRequest other = (CreateMonitoringScheduleRequest) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleConfig(), other.monitoringScheduleConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMonitoringScheduleRequest").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleConfig", monitoringScheduleConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleConfig":
            return Optional.ofNullable(clazz.cast(monitoringScheduleConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitoringScheduleRequest, T> g) {
        return obj -> g.apply((CreateMonitoringScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMonitoringScheduleRequest> {
        /**
         * <p>
         * The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an
         * Amazon Web Services account.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region
         *        within an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * 
         * @param monitoringScheduleConfig
         *        The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringScheduleConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringScheduleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringScheduleConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringScheduleConfig(MonitoringScheduleConfig)}.
         * 
         * @param monitoringScheduleConfig
         *        a consumer that will call methods on {@link MonitoringScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleConfig(MonitoringScheduleConfig)
         */
        default Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return monitoringScheduleConfig(MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a href=
         * " https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
         * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        " https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a href=
         * " https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
         * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        " https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a href=
         * " https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
         * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private MonitoringScheduleConfig monitoringScheduleConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitoringScheduleRequest model) {
            super(model);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleConfig(model.monitoringScheduleConfig);
            tags(model.tags);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        @Transient
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return monitoringScheduleConfig != null ? monitoringScheduleConfig.toBuilder() : null;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitoringScheduleRequest build() {
            return new CreateMonitoringScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
