/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSearchSuggestionsResponse extends SageMakerResponse implements
        ToCopyableBuilder<GetSearchSuggestionsResponse.Builder, GetSearchSuggestionsResponse> {
    private static final SdkField<List<PropertyNameSuggestion>> PROPERTY_NAME_SUGGESTIONS_FIELD = SdkField
            .<List<PropertyNameSuggestion>> builder(MarshallingType.LIST)
            .memberName("PropertyNameSuggestions")
            .getter(getter(GetSearchSuggestionsResponse::propertyNameSuggestions))
            .setter(setter(Builder::propertyNameSuggestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyNameSuggestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyNameSuggestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyNameSuggestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROPERTY_NAME_SUGGESTIONS_FIELD));

    private final List<PropertyNameSuggestion> propertyNameSuggestions;

    private GetSearchSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.propertyNameSuggestions = builder.propertyNameSuggestions;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyNameSuggestions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropertyNameSuggestions() {
        return propertyNameSuggestions != null && !(propertyNameSuggestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyNameSuggestions} method.
     * </p>
     * 
     * @return A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
     */
    public final List<PropertyNameSuggestion> propertyNameSuggestions() {
        return propertyNameSuggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyNameSuggestions() ? propertyNameSuggestions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchSuggestionsResponse)) {
            return false;
        }
        GetSearchSuggestionsResponse other = (GetSearchSuggestionsResponse) obj;
        return hasPropertyNameSuggestions() == other.hasPropertyNameSuggestions()
                && Objects.equals(propertyNameSuggestions(), other.propertyNameSuggestions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSearchSuggestionsResponse")
                .add("PropertyNameSuggestions", hasPropertyNameSuggestions() ? propertyNameSuggestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyNameSuggestions":
            return Optional.ofNullable(clazz.cast(propertyNameSuggestions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSearchSuggestionsResponse, T> g) {
        return obj -> g.apply((GetSearchSuggestionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSearchSuggestionsResponse> {
        /**
         * <p>
         * A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
         * </p>
         * 
         * @param propertyNameSuggestions
         *        A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNameSuggestions(Collection<PropertyNameSuggestion> propertyNameSuggestions);

        /**
         * <p>
         * A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
         * </p>
         * 
         * @param propertyNameSuggestions
         *        A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNameSuggestions(PropertyNameSuggestion... propertyNameSuggestions);

        /**
         * <p>
         * A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PropertyNameSuggestion>.Builder} avoiding
         * the need to create one manually via {@link List<PropertyNameSuggestion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PropertyNameSuggestion>.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyNameSuggestions(List<PropertyNameSuggestion>)}.
         * 
         * @param propertyNameSuggestions
         *        a consumer that will call methods on {@link List<PropertyNameSuggestion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyNameSuggestions(List<PropertyNameSuggestion>)
         */
        Builder propertyNameSuggestions(Consumer<PropertyNameSuggestion.Builder>... propertyNameSuggestions);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<PropertyNameSuggestion> propertyNameSuggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchSuggestionsResponse model) {
            super(model);
            propertyNameSuggestions(model.propertyNameSuggestions);
        }

        public final List<PropertyNameSuggestion.Builder> getPropertyNameSuggestions() {
            List<PropertyNameSuggestion.Builder> result = PropertyNameSuggestionListCopier
                    .copyToBuilder(this.propertyNameSuggestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyNameSuggestions(Collection<PropertyNameSuggestion.BuilderImpl> propertyNameSuggestions) {
            this.propertyNameSuggestions = PropertyNameSuggestionListCopier.copyFromBuilder(propertyNameSuggestions);
        }

        @Override
        @Transient
        public final Builder propertyNameSuggestions(Collection<PropertyNameSuggestion> propertyNameSuggestions) {
            this.propertyNameSuggestions = PropertyNameSuggestionListCopier.copy(propertyNameSuggestions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder propertyNameSuggestions(PropertyNameSuggestion... propertyNameSuggestions) {
            propertyNameSuggestions(Arrays.asList(propertyNameSuggestions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder propertyNameSuggestions(Consumer<PropertyNameSuggestion.Builder>... propertyNameSuggestions) {
            propertyNameSuggestions(Stream.of(propertyNameSuggestions)
                    .map(c -> PropertyNameSuggestion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSearchSuggestionsResponse build() {
            return new GetSearchSuggestionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
