/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of an in-progress deployment when an endpoint is creating or updating with a new endpoint configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingDeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingDeploymentSummary.Builder, PendingDeploymentSummary> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(PendingDeploymentSummary::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<List<PendingProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<PendingProductionVariantSummary>> builder(MarshallingType.LIST)
            .memberName("ProductionVariants")
            .getter(getter(PendingDeploymentSummary::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingProductionVariantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingProductionVariantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PendingDeploymentSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD,
            PRODUCTION_VARIANTS_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointConfigName;

    private final List<PendingProductionVariantSummary> productionVariants;

    private final Instant startTime;

    private PendingDeploymentSummary(BuilderImpl builder) {
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The name of the endpoint configuration used in the deployment.
     * </p>
     * 
     * @return The name of the endpoint configuration used in the deployment.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductionVariants property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductionVariants() {
        return productionVariants != null && !(productionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>PendingProductionVariantSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductionVariants} method.
     * </p>
     * 
     * @return List of <code>PendingProductionVariantSummary</code> objects.
     */
    public final List<PendingProductionVariantSummary> productionVariants() {
        return productionVariants;
    }

    /**
     * <p>
     * The start time of the deployment.
     * </p>
     * 
     * @return The start time of the deployment.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductionVariants() ? productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingDeploymentSummary)) {
            return false;
        }
        PendingDeploymentSummary other = (PendingDeploymentSummary) obj;
        return Objects.equals(endpointConfigName(), other.endpointConfigName())
                && hasProductionVariants() == other.hasProductionVariants()
                && Objects.equals(productionVariants(), other.productionVariants())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingDeploymentSummary").add("EndpointConfigName", endpointConfigName())
                .add("ProductionVariants", hasProductionVariants() ? productionVariants() : null).add("StartTime", startTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingDeploymentSummary, T> g) {
        return obj -> g.apply((PendingDeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingDeploymentSummary> {
        /**
         * <p>
         * The name of the endpoint configuration used in the deployment.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration used in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * List of <code>PendingProductionVariantSummary</code> objects.
         * </p>
         * 
         * @param productionVariants
         *        List of <code>PendingProductionVariantSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<PendingProductionVariantSummary> productionVariants);

        /**
         * <p>
         * List of <code>PendingProductionVariantSummary</code> objects.
         * </p>
         * 
         * @param productionVariants
         *        List of <code>PendingProductionVariantSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(PendingProductionVariantSummary... productionVariants);

        /**
         * <p>
         * List of <code>PendingProductionVariantSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PendingProductionVariantSummary>.Builder}
         * avoiding the need to create one manually via {@link List<PendingProductionVariantSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingProductionVariantSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #productionVariants(List<PendingProductionVariantSummary>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on {@link List<PendingProductionVariantSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(List<PendingProductionVariantSummary>)
         */
        Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder>... productionVariants);

        /**
         * <p>
         * The start time of the deployment.
         * </p>
         * 
         * @param startTime
         *        The start time of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String endpointConfigName;

        private List<PendingProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingDeploymentSummary model) {
            endpointConfigName(model.endpointConfigName);
            productionVariants(model.productionVariants);
            startTime(model.startTime);
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        @Transient
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<PendingProductionVariantSummary.Builder> getProductionVariants() {
            List<PendingProductionVariantSummary.Builder> result = PendingProductionVariantSummaryListCopier
                    .copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<PendingProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        @Transient
        public final Builder productionVariants(Collection<PendingProductionVariantSummary> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productionVariants(PendingProductionVariantSummary... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants)
                    .map(c -> PendingProductionVariantSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public PendingDeploymentSummary build() {
            return new PendingDeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
