/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the names of the experiment and trial created by a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExperimentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExperimentConfig.Builder, PipelineExperimentConfig> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(PipelineExperimentConfig::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(PipelineExperimentConfig::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD,
            TRIAL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String experimentName;

    private final String trialName;

    private PipelineExperimentConfig(BuilderImpl builder) {
        this.experimentName = builder.experimentName;
        this.trialName = builder.trialName;
    }

    /**
     * <p>
     * The name of the experiment.
     * </p>
     * 
     * @return The name of the experiment.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * The name of the trial.
     * </p>
     * 
     * @return The name of the trial.
     */
    public final String trialName() {
        return trialName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExperimentConfig)) {
            return false;
        }
        PipelineExperimentConfig other = (PipelineExperimentConfig) obj;
        return Objects.equals(experimentName(), other.experimentName()) && Objects.equals(trialName(), other.trialName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExperimentConfig").add("ExperimentName", experimentName()).add("TrialName", trialName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExperimentConfig, T> g) {
        return obj -> g.apply((PipelineExperimentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExperimentConfig> {
        /**
         * <p>
         * The name of the experiment.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * The name of the trial.
         * </p>
         * 
         * @param trialName
         *        The name of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);
    }

    static final class BuilderImpl implements Builder {
        private String experimentName;

        private String trialName;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExperimentConfig model) {
            experimentName(model.experimentName);
            trialName(model.trialName);
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        @Transient
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getTrialName() {
            return trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        @Transient
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        @Override
        public PipelineExperimentConfig build() {
            return new PipelineExperimentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
