/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCompilationJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeCompilationJobResponse.Builder, DescribeCompilationJobResponse> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(DescribeCompilationJobResponse::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobArn").getter(getter(DescribeCompilationJobResponse::compilationJobArn))
            .setter(setter(Builder::compilationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()).build();

    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobStatus").getter(getter(DescribeCompilationJobResponse::compilationJobStatusAsString))
            .setter(setter(Builder::compilationJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build())
            .build();

    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompilationStartTime").getter(getter(DescribeCompilationJobResponse::compilationStartTime))
            .setter(setter(Builder::compilationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build())
            .build();

    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompilationEndTime").getter(getter(DescribeCompilationJobResponse::compilationEndTime))
            .setter(setter(Builder::compilationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build())
            .build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(DescribeCompilationJobResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<String> INFERENCE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceImage").getter(getter(DescribeCompilationJobResponse::inferenceImage))
            .setter(setter(Builder::inferenceImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceImage").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageVersionArn").getter(getter(DescribeCompilationJobResponse::modelPackageVersionArn))
            .setter(setter(Builder::modelPackageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeCompilationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeCompilationJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeCompilationJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField
            .<ModelArtifacts> builder(MarshallingType.SDK_POJO).memberName("ModelArtifacts")
            .getter(getter(DescribeCompilationJobResponse::modelArtifacts)).setter(setter(Builder::modelArtifacts))
            .constructor(ModelArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()).build();

    private static final SdkField<ModelDigests> MODEL_DIGESTS_FIELD = SdkField.<ModelDigests> builder(MarshallingType.SDK_POJO)
            .memberName("ModelDigests").getter(getter(DescribeCompilationJobResponse::modelDigests))
            .setter(setter(Builder::modelDigests)).constructor(ModelDigests::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDigests").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeCompilationJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.<InputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("InputConfig").getter(getter(DescribeCompilationJobResponse::inputConfig))
            .setter(setter(Builder::inputConfig)).constructor(InputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(DescribeCompilationJobResponse::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<NeoVpcConfig> VPC_CONFIG_FIELD = SdkField.<NeoVpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(DescribeCompilationJobResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(NeoVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD,
            COMPILATION_JOB_ARN_FIELD, COMPILATION_JOB_STATUS_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD,
            STOPPING_CONDITION_FIELD, INFERENCE_IMAGE_FIELD, MODEL_PACKAGE_VERSION_ARN_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, MODEL_ARTIFACTS_FIELD, MODEL_DIGESTS_FIELD, ROLE_ARN_FIELD,
            INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, VPC_CONFIG_FIELD));

    private final String compilationJobName;

    private final String compilationJobArn;

    private final String compilationJobStatus;

    private final Instant compilationStartTime;

    private final Instant compilationEndTime;

    private final StoppingCondition stoppingCondition;

    private final String inferenceImage;

    private final String modelPackageVersionArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final ModelArtifacts modelArtifacts;

    private final ModelDigests modelDigests;

    private final String roleArn;

    private final InputConfig inputConfig;

    private final OutputConfig outputConfig;

    private final NeoVpcConfig vpcConfig;

    private DescribeCompilationJobResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.compilationJobStatus = builder.compilationJobStatus;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.stoppingCondition = builder.stoppingCondition;
        this.inferenceImage = builder.inferenceImage;
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.modelArtifacts = builder.modelArtifacts;
        this.modelDigests = builder.modelDigests;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The name of the model compilation job.
     * </p>
     * 
     * @return The name of the model compilation job.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model compilation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model compilation job.
     */
    public final String compilationJobArn() {
        return compilationJobArn;
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public final CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(compilationJobStatus);
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public final String compilationJobStatusAsString() {
        return compilationJobStatus;
    }

    /**
     * <p>
     * The time when the model compilation job started the <code>CompilationJob</code> instances.
     * </p>
     * <p>
     * You are billed for the time between this timestamp and the timestamp in the
     * <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time might
     * be later than this time. That's because it takes time to download the compilation job, which depends on the size
     * of the compilation job container.
     * </p>
     * 
     * @return The time when the model compilation job started the <code>CompilationJob</code> instances. </p>
     *         <p>
     *         You are billed for the time between this timestamp and the timestamp in the
     *         <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time
     *         might be later than this time. That's because it takes time to download the compilation job, which
     *         depends on the size of the compilation job container.
     */
    public final Instant compilationStartTime() {
        return compilationStartTime;
    }

    /**
     * <p>
     * The time when the model compilation job on a compilation job instance ended. For a successful or stopped job,
     * this is when the job's model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker
     * detected that the job failed.
     * </p>
     * 
     * @return The time when the model compilation job on a compilation job instance ended. For a successful or stopped
     *         job, this is when the job's model artifacts have finished uploading. For a failed job, this is when
     *         Amazon SageMaker detected that the job failed.
     */
    public final Instant compilationEndTime() {
        return compilationEndTime;
    }

    /**
     * <p>
     * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
     * SageMaker ends the compilation job. Use this API to cap model training costs.
     * </p>
     * 
     * @return Specifies a limit to how long a model compilation job can run. When the job reaches the time limit,
     *         Amazon SageMaker ends the compilation job. Use this API to cap model training costs.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * The inference image to use when compiling a model. Specify an image only if the target device is a cloud
     * instance.
     * </p>
     * 
     * @return The inference image to use when compiling a model. Specify an image only if the target device is a cloud
     *         instance.
     */
    public final String inferenceImage() {
        return inferenceImage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you
     * initiated a compilation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you
     *         initiated a compilation job.
     */
    public final String modelPackageVersionArn() {
        return modelPackageVersionArn;
    }

    /**
     * <p>
     * The time that the model compilation job was created.
     * </p>
     * 
     * @return The time that the model compilation job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that the status of the model compilation job was last modified.
     * </p>
     * 
     * @return The time that the status of the model compilation job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If a model compilation job failed, the reason it failed.
     * </p>
     * 
     * @return If a model compilation job failed, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the
     * compilation job.
     * </p>
     * 
     * @return Information about the location in Amazon S3 that has been configured for storing the model artifacts used
     *         in the compilation job.
     */
    public final ModelArtifacts modelArtifacts() {
        return modelArtifacts;
    }

    /**
     * <p>
     * Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
     * </p>
     * 
     * @return Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
     */
    public final ModelDigests modelDigests() {
        return modelDigests;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model compilation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model
     *         compilation job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data
     * inputs, and the framework in which the model was trained.
     * </p>
     * 
     * @return Information about the location in Amazon S3 of the input model artifacts, the name and shape of the
     *         expected data inputs, and the framework in which the model was trained.
     */
    public final InputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * Information about the output location for the compiled model and the target device that the model runs on.
     * </p>
     * 
     * @return Information about the output location for the compiled model and the target device that the model runs
     *         on.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access
     * to your models by configuring the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon
     * Virtual Private Cloud</a>.
     * </p>
     * 
     * @return A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to.
     *         Control access to your models by configuring the VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
     *         Amazon Virtual Private Cloud</a>.
     */
    public final NeoVpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceImage());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(modelDigests());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCompilationJobResponse)) {
            return false;
        }
        DescribeCompilationJobResponse other = (DescribeCompilationJobResponse) obj;
        return Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(compilationJobArn(), other.compilationJobArn())
                && Objects.equals(compilationJobStatusAsString(), other.compilationJobStatusAsString())
                && Objects.equals(compilationStartTime(), other.compilationStartTime())
                && Objects.equals(compilationEndTime(), other.compilationEndTime())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(inferenceImage(), other.inferenceImage())
                && Objects.equals(modelPackageVersionArn(), other.modelPackageVersionArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(modelArtifacts(), other.modelArtifacts())
                && Objects.equals(modelDigests(), other.modelDigests()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCompilationJobResponse").add("CompilationJobName", compilationJobName())
                .add("CompilationJobArn", compilationJobArn()).add("CompilationJobStatus", compilationJobStatusAsString())
                .add("CompilationStartTime", compilationStartTime()).add("CompilationEndTime", compilationEndTime())
                .add("StoppingCondition", stoppingCondition()).add("InferenceImage", inferenceImage())
                .add("ModelPackageVersionArn", modelPackageVersionArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .add("ModelArtifacts", modelArtifacts()).add("ModelDigests", modelDigests()).add("RoleArn", roleArn())
                .add("InputConfig", inputConfig()).add("OutputConfig", outputConfig()).add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "CompilationJobArn":
            return Optional.ofNullable(clazz.cast(compilationJobArn()));
        case "CompilationJobStatus":
            return Optional.ofNullable(clazz.cast(compilationJobStatusAsString()));
        case "CompilationStartTime":
            return Optional.ofNullable(clazz.cast(compilationStartTime()));
        case "CompilationEndTime":
            return Optional.ofNullable(clazz.cast(compilationEndTime()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "InferenceImage":
            return Optional.ofNullable(clazz.cast(inferenceImage()));
        case "ModelPackageVersionArn":
            return Optional.ofNullable(clazz.cast(modelPackageVersionArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ModelArtifacts":
            return Optional.ofNullable(clazz.cast(modelArtifacts()));
        case "ModelDigests":
            return Optional.ofNullable(clazz.cast(modelDigests()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCompilationJobResponse, T> g) {
        return obj -> g.apply((DescribeCompilationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCompilationJobResponse> {
        /**
         * <p>
         * The name of the model compilation job.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model compilation job.
         * </p>
         * 
         * @param compilationJobArn
         *        The Amazon Resource Name (ARN) of the model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobArn(String compilationJobArn);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(String compilationJobStatus);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(CompilationJobStatus compilationJobStatus);

        /**
         * <p>
         * The time when the model compilation job started the <code>CompilationJob</code> instances.
         * </p>
         * <p>
         * You are billed for the time between this timestamp and the timestamp in the
         * <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time
         * might be later than this time. That's because it takes time to download the compilation job, which depends on
         * the size of the compilation job container.
         * </p>
         * 
         * @param compilationStartTime
         *        The time when the model compilation job started the <code>CompilationJob</code> instances. </p>
         *        <p>
         *        You are billed for the time between this timestamp and the timestamp in the
         *        <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start
         *        time might be later than this time. That's because it takes time to download the compilation job,
         *        which depends on the size of the compilation job container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationStartTime(Instant compilationStartTime);

        /**
         * <p>
         * The time when the model compilation job on a compilation job instance ended. For a successful or stopped job,
         * this is when the job's model artifacts have finished uploading. For a failed job, this is when Amazon
         * SageMaker detected that the job failed.
         * </p>
         * 
         * @param compilationEndTime
         *        The time when the model compilation job on a compilation job instance ended. For a successful or
         *        stopped job, this is when the job's model artifacts have finished uploading. For a failed job, this is
         *        when Amazon SageMaker detected that the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationEndTime(Instant compilationEndTime);

        /**
         * <p>
         * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
         * SageMaker ends the compilation job. Use this API to cap model training costs.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model compilation job can run. When the job reaches the time limit,
         *        Amazon SageMaker ends the compilation job. Use this API to cap model training costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
         * SageMaker ends the compilation job. Use this API to cap model training costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * The inference image to use when compiling a model. Specify an image only if the target device is a cloud
         * instance.
         * </p>
         * 
         * @param inferenceImage
         *        The inference image to use when compiling a model. Specify an image only if the target device is a
         *        cloud instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceImage(String inferenceImage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you
         * initiated a compilation job.
         * </p>
         * 
         * @param modelPackageVersionArn
         *        The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when
         *        you initiated a compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersionArn(String modelPackageVersionArn);

        /**
         * <p>
         * The time that the model compilation job was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the model compilation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that the status of the model compilation job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time that the status of the model compilation job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If a model compilation job failed, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If a model compilation job failed, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Information about the location in Amazon S3 that has been configured for storing the model artifacts used in
         * the compilation job.
         * </p>
         * 
         * @param modelArtifacts
         *        Information about the location in Amazon S3 that has been configured for storing the model artifacts
         *        used in the compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArtifacts(ModelArtifacts modelArtifacts);

        /**
         * <p>
         * Information about the location in Amazon S3 that has been configured for storing the model artifacts used in
         * the compilation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelArtifacts.Builder} avoiding the need
         * to create one manually via {@link ModelArtifacts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #modelArtifacts(ModelArtifacts)}.
         * 
         * @param modelArtifacts
         *        a consumer that will call methods on {@link ModelArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelArtifacts(ModelArtifacts)
         */
        default Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return modelArtifacts(ModelArtifacts.builder().applyMutation(modelArtifacts).build());
        }

        /**
         * <p>
         * Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
         * </p>
         * 
         * @param modelDigests
         *        Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDigests(ModelDigests modelDigests);

        /**
         * <p>
         * Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDigests.Builder} avoiding the need
         * to create one manually via {@link ModelDigests#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDigests.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDigests(ModelDigests)}.
         * 
         * @param modelDigests
         *        a consumer that will call methods on {@link ModelDigests.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDigests(ModelDigests)
         */
        default Builder modelDigests(Consumer<ModelDigests.Builder> modelDigests) {
            return modelDigests(ModelDigests.builder().applyMutation(modelDigests).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model compilation
         * job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model
         *        compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected
         * data inputs, and the framework in which the model was trained.
         * </p>
         * 
         * @param inputConfig
         *        Information about the location in Amazon S3 of the input model artifacts, the name and shape of the
         *        expected data inputs, and the framework in which the model was trained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(InputConfig inputConfig);

        /**
         * <p>
         * Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected
         * data inputs, and the framework in which the model was trained.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConfig.Builder} avoiding the need to
         * create one manually via {@link InputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #inputConfig(InputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link InputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(InputConfig)
         */
        default Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return inputConfig(InputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * Information about the output location for the compiled model and the target device that the model runs on.
         * </p>
         * 
         * @param outputConfig
         *        Information about the output location for the compiled model and the target device that the model runs
         *        on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * Information about the output location for the compiled model and the target device that the model runs on.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control
         * access to your models by configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * 
         * @param vpcConfig
         *        A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to.
         *        Control access to your models by configuring the VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using
         *        an Amazon Virtual Private Cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(NeoVpcConfig vpcConfig);

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control
         * access to your models by configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeoVpcConfig.Builder} avoiding the need
         * to create one manually via {@link NeoVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeoVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(NeoVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link NeoVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(NeoVpcConfig)
         */
        default Builder vpcConfig(Consumer<NeoVpcConfig.Builder> vpcConfig) {
            return vpcConfig(NeoVpcConfig.builder().applyMutation(vpcConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String compilationJobName;

        private String compilationJobArn;

        private String compilationJobStatus;

        private Instant compilationStartTime;

        private Instant compilationEndTime;

        private StoppingCondition stoppingCondition;

        private String inferenceImage;

        private String modelPackageVersionArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private ModelArtifacts modelArtifacts;

        private ModelDigests modelDigests;

        private String roleArn;

        private InputConfig inputConfig;

        private OutputConfig outputConfig;

        private NeoVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCompilationJobResponse model) {
            super(model);
            compilationJobName(model.compilationJobName);
            compilationJobArn(model.compilationJobArn);
            compilationJobStatus(model.compilationJobStatus);
            compilationStartTime(model.compilationStartTime);
            compilationEndTime(model.compilationEndTime);
            stoppingCondition(model.stoppingCondition);
            inferenceImage(model.inferenceImage);
            modelPackageVersionArn(model.modelPackageVersionArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            modelArtifacts(model.modelArtifacts);
            modelDigests(model.modelDigests);
            roleArn(model.roleArn);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            vpcConfig(model.vpcConfig);
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getCompilationJobArn() {
            return compilationJobArn;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final String getCompilationJobStatus() {
            return compilationJobStatus;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public final Instant getCompilationStartTime() {
            return compilationStartTime;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final Instant getCompilationEndTime() {
            return compilationEndTime;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final String getInferenceImage() {
            return inferenceImage;
        }

        public final void setInferenceImage(String inferenceImage) {
            this.inferenceImage = inferenceImage;
        }

        @Override
        public final Builder inferenceImage(String inferenceImage) {
            this.inferenceImage = inferenceImage;
            return this;
        }

        public final String getModelPackageVersionArn() {
            return modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return modelArtifacts != null ? modelArtifacts.toBuilder() : null;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final ModelDigests.Builder getModelDigests() {
            return modelDigests != null ? modelDigests.toBuilder() : null;
        }

        public final void setModelDigests(ModelDigests.BuilderImpl modelDigests) {
            this.modelDigests = modelDigests != null ? modelDigests.build() : null;
        }

        @Override
        public final Builder modelDigests(ModelDigests modelDigests) {
            this.modelDigests = modelDigests;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final InputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final NeoVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(NeoVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(NeoVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public DescribeCompilationJobResponse build() {
            return new DescribeCompilationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
