/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the deployment options of a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVariantConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelVariantConfig.Builder, ModelVariantConfig> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ModelVariantConfig::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(ModelVariantConfig::variantName)).setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<ModelInfrastructureConfig> INFRASTRUCTURE_CONFIG_FIELD = SdkField
            .<ModelInfrastructureConfig> builder(MarshallingType.SDK_POJO).memberName("InfrastructureConfig")
            .getter(getter(ModelVariantConfig::infrastructureConfig)).setter(setter(Builder::infrastructureConfig))
            .constructor(ModelInfrastructureConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            VARIANT_NAME_FIELD, INFRASTRUCTURE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String variantName;

    private final ModelInfrastructureConfig infrastructureConfig;

    private ModelVariantConfig(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.variantName = builder.variantName;
        this.infrastructureConfig = builder.infrastructureConfig;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The name of the variant.
     * </p>
     * 
     * @return The name of the variant.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * The configuration for the infrastructure that the model will be deployed to.
     * </p>
     * 
     * @return The configuration for the infrastructure that the model will be deployed to.
     */
    public final ModelInfrastructureConfig infrastructureConfig() {
        return infrastructureConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVariantConfig)) {
            return false;
        }
        ModelVariantConfig other = (ModelVariantConfig) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(variantName(), other.variantName())
                && Objects.equals(infrastructureConfig(), other.infrastructureConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelVariantConfig").add("ModelName", modelName()).add("VariantName", variantName())
                .add("InfrastructureConfig", infrastructureConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "InfrastructureConfig":
            return Optional.ofNullable(clazz.cast(infrastructureConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVariantConfig, T> g) {
        return obj -> g.apply((ModelVariantConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVariantConfig> {
        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The name of the variant.
         * </p>
         * 
         * @param variantName
         *        The name of the variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * The configuration for the infrastructure that the model will be deployed to.
         * </p>
         * 
         * @param infrastructureConfig
         *        The configuration for the infrastructure that the model will be deployed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfig(ModelInfrastructureConfig infrastructureConfig);

        /**
         * <p>
         * The configuration for the infrastructure that the model will be deployed to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInfrastructureConfig.Builder}
         * avoiding the need to create one manually via {@link ModelInfrastructureConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInfrastructureConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #infrastructureConfig(ModelInfrastructureConfig)}.
         * 
         * @param infrastructureConfig
         *        a consumer that will call methods on {@link ModelInfrastructureConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infrastructureConfig(ModelInfrastructureConfig)
         */
        default Builder infrastructureConfig(Consumer<ModelInfrastructureConfig.Builder> infrastructureConfig) {
            return infrastructureConfig(ModelInfrastructureConfig.builder().applyMutation(infrastructureConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String variantName;

        private ModelInfrastructureConfig infrastructureConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVariantConfig model) {
            modelName(model.modelName);
            variantName(model.variantName);
            infrastructureConfig(model.infrastructureConfig);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final ModelInfrastructureConfig.Builder getInfrastructureConfig() {
            return infrastructureConfig != null ? infrastructureConfig.toBuilder() : null;
        }

        public final void setInfrastructureConfig(ModelInfrastructureConfig.BuilderImpl infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig != null ? infrastructureConfig.build() : null;
        }

        @Override
        public final Builder infrastructureConfig(ModelInfrastructureConfig infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig;
            return this;
        }

        @Override
        public ModelVariantConfig build() {
            return new ModelVariantConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
