/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateDomainRequest.Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UpdateDomainRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField
            .<UserSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultUserSettings")
            .getter(getter(UpdateDomainRequest::defaultUserSettings)).setter(setter(Builder::defaultUserSettings))
            .constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build())
            .build();

    private static final SdkField<DomainSettingsForUpdate> DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<DomainSettingsForUpdate> builder(MarshallingType.SDK_POJO).memberName("DomainSettingsForUpdate")
            .getter(getter(UpdateDomainRequest::domainSettingsForUpdate)).setter(setter(Builder::domainSettingsForUpdate))
            .constructor(DomainSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettingsForUpdate").build())
            .build();

    private static final SdkField<DefaultSpaceSettings> DEFAULT_SPACE_SETTINGS_FIELD = SdkField
            .<DefaultSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultSpaceSettings")
            .getter(getter(UpdateDomainRequest::defaultSpaceSettings)).setter(setter(Builder::defaultSpaceSettings))
            .constructor(DefaultSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSpaceSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            DEFAULT_USER_SETTINGS_FIELD, DOMAIN_SETTINGS_FOR_UPDATE_FIELD, DEFAULT_SPACE_SETTINGS_FIELD));

    private final String domainId;

    private final UserSettings defaultUserSettings;

    private final DomainSettingsForUpdate domainSettingsForUpdate;

    private final DefaultSpaceSettings defaultSpaceSettings;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.domainSettingsForUpdate = builder.domainSettingsForUpdate;
        this.defaultSpaceSettings = builder.defaultSpaceSettings;
    }

    /**
     * <p>
     * The ID of the domain to be updated.
     * </p>
     * 
     * @return The ID of the domain to be updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * A collection of settings.
     * </p>
     * 
     * @return A collection of settings.
     */
    public final UserSettings defaultUserSettings() {
        return defaultUserSettings;
    }

    /**
     * <p>
     * A collection of <code>DomainSettings</code> configuration values to update.
     * </p>
     * 
     * @return A collection of <code>DomainSettings</code> configuration values to update.
     */
    public final DomainSettingsForUpdate domainSettingsForUpdate() {
        return domainSettingsForUpdate;
    }

    /**
     * <p>
     * The default settings used to create a space within the Domain.
     * </p>
     * 
     * @return The default settings used to create a space within the Domain.
     */
    public final DefaultSpaceSettings defaultSpaceSettings() {
        return defaultSpaceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(domainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSpaceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(defaultUserSettings(), other.defaultUserSettings())
                && Objects.equals(domainSettingsForUpdate(), other.domainSettingsForUpdate())
                && Objects.equals(defaultSpaceSettings(), other.defaultSpaceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainRequest").add("DomainId", domainId())
                .add("DefaultUserSettings", defaultUserSettings()).add("DomainSettingsForUpdate", domainSettingsForUpdate())
                .add("DefaultSpaceSettings", defaultSpaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DefaultUserSettings":
            return Optional.ofNullable(clazz.cast(defaultUserSettings()));
        case "DomainSettingsForUpdate":
            return Optional.ofNullable(clazz.cast(domainSettingsForUpdate()));
        case "DefaultSpaceSettings":
            return Optional.ofNullable(clazz.cast(defaultSpaceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainRequest> {
        /**
         * <p>
         * The ID of the domain to be updated.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * 
         * @param defaultUserSettings
         *        A collection of settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUserSettings(UserSettings defaultUserSettings);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserSettings.Builder} avoiding the need
         * to create one manually via {@link UserSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultUserSettings(UserSettings)}.
         * 
         * @param defaultUserSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultUserSettings(UserSettings)
         */
        default Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return defaultUserSettings(UserSettings.builder().applyMutation(defaultUserSettings).build());
        }

        /**
         * <p>
         * A collection of <code>DomainSettings</code> configuration values to update.
         * </p>
         * 
         * @param domainSettingsForUpdate
         *        A collection of <code>DomainSettings</code> configuration values to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate);

        /**
         * <p>
         * A collection of <code>DomainSettings</code> configuration values to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainSettingsForUpdate.Builder} avoiding
         * the need to create one manually via {@link DomainSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainSettingsForUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #domainSettingsForUpdate(DomainSettingsForUpdate)}.
         * 
         * @param domainSettingsForUpdate
         *        a consumer that will call methods on {@link DomainSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainSettingsForUpdate(DomainSettingsForUpdate)
         */
        default Builder domainSettingsForUpdate(Consumer<DomainSettingsForUpdate.Builder> domainSettingsForUpdate) {
            return domainSettingsForUpdate(DomainSettingsForUpdate.builder().applyMutation(domainSettingsForUpdate).build());
        }

        /**
         * <p>
         * The default settings used to create a space within the Domain.
         * </p>
         * 
         * @param defaultSpaceSettings
         *        The default settings used to create a space within the Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings);

        /**
         * <p>
         * The default settings used to create a space within the Domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultSpaceSettings.Builder} avoiding
         * the need to create one manually via {@link DefaultSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultSpaceSettings(DefaultSpaceSettings)}.
         * 
         * @param defaultSpaceSettings
         *        a consumer that will call methods on {@link DefaultSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSpaceSettings(DefaultSpaceSettings)
         */
        default Builder defaultSpaceSettings(Consumer<DefaultSpaceSettings.Builder> defaultSpaceSettings) {
            return defaultSpaceSettings(DefaultSpaceSettings.builder().applyMutation(defaultSpaceSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private UserSettings defaultUserSettings;

        private DomainSettingsForUpdate domainSettingsForUpdate;

        private DefaultSpaceSettings defaultSpaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            domainId(model.domainId);
            defaultUserSettings(model.defaultUserSettings);
            domainSettingsForUpdate(model.domainSettingsForUpdate);
            defaultSpaceSettings(model.defaultSpaceSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return defaultUserSettings != null ? defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final DomainSettingsForUpdate.Builder getDomainSettingsForUpdate() {
            return domainSettingsForUpdate != null ? domainSettingsForUpdate.toBuilder() : null;
        }

        public final void setDomainSettingsForUpdate(DomainSettingsForUpdate.BuilderImpl domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate != null ? domainSettingsForUpdate.build() : null;
        }

        @Override
        public final Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate;
            return this;
        }

        public final DefaultSpaceSettings.Builder getDefaultSpaceSettings() {
            return defaultSpaceSettings != null ? defaultSpaceSettings.toBuilder() : null;
        }

        public final void setDefaultSpaceSettings(DefaultSpaceSettings.BuilderImpl defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings != null ? defaultSpaceSettings.build() : null;
        }

        @Override
        public final Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
