/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the config information for how a candidate is generated (optional).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLCandidateGenerationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLCandidateGenerationConfig.Builder, AutoMLCandidateGenerationConfig> {
    private static final SdkField<String> FEATURE_SPECIFICATION_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureSpecificationS3Uri").getter(getter(AutoMLCandidateGenerationConfig::featureSpecificationS3Uri))
            .setter(setter(Builder::featureSpecificationS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureSpecificationS3Uri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FEATURE_SPECIFICATION_S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featureSpecificationS3Uri;

    private AutoMLCandidateGenerationConfig(BuilderImpl builder) {
        this.featureSpecificationS3Uri = builder.featureSpecificationS3Uri;
    }

    /**
     * <p>
     * A URL to the Amazon S3 data source containing selected features from the input data source to run an Autopilot
     * job. You can input <code>FeatureAttributeNames</code> (optional) in JSON format as shown below:
     * </p>
     * <p>
     * <code>{ "FeatureAttributeNames":["col1", "col2", ...] }</code>.
     * </p>
     * <p>
     * You can also specify the data type of the feature (optional) in the format shown below:
     * </p>
     * <p>
     * <code>{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }</code>
     * </p>
     * <note>
     * <p>
     * These column keys may not include the target column.
     * </p>
     * </note>
     * <p>
     * In ensembling mode, Autopilot will only support the following data types: <code>numeric</code>,
     * <code>categorical</code>, <code>text</code> and <code>datetime</code>. In HPO mode, Autopilot can support
     * <code>numeric</code>, <code>categorical</code>, <code>text</code>, <code>datetime</code> and
     * <code>sequence</code>.
     * </p>
     * <p>
     * If only <code>FeatureDataTypes</code> is provided, the column keys (<code>col1</code>, <code>col2</code>,..)
     * should be a subset of the column names in the input data.
     * </p>
     * <p>
     * If both <code>FeatureDataTypes</code> and <code>FeatureAttributeNames</code> are provided, then the column keys
     * should be a subset of the column names provided in <code>FeatureAttributeNames</code>.
     * </p>
     * <p>
     * The key name <code>FeatureAttributeNames</code> is fixed. The values listed in <code>["col1", "col2", ...]</code>
     * is case sensitive and should be a list of strings containing unique values that are a subset of the column names
     * in the input data. The list of columns provided must not include the target column.
     * </p>
     * 
     * @return A URL to the Amazon S3 data source containing selected features from the input data source to run an
     *         Autopilot job. You can input <code>FeatureAttributeNames</code> (optional) in JSON format as shown below:
     *         </p>
     *         <p>
     *         <code>{ "FeatureAttributeNames":["col1", "col2", ...] }</code>.
     *         </p>
     *         <p>
     *         You can also specify the data type of the feature (optional) in the format shown below:
     *         </p>
     *         <p>
     *         <code>{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }</code>
     *         </p>
     *         <note>
     *         <p>
     *         These column keys may not include the target column.
     *         </p>
     *         </note>
     *         <p>
     *         In ensembling mode, Autopilot will only support the following data types: <code>numeric</code>,
     *         <code>categorical</code>, <code>text</code> and <code>datetime</code>. In HPO mode, Autopilot can support
     *         <code>numeric</code>, <code>categorical</code>, <code>text</code>, <code>datetime</code> and
     *         <code>sequence</code>.
     *         </p>
     *         <p>
     *         If only <code>FeatureDataTypes</code> is provided, the column keys (<code>col1</code>, <code>col2</code>
     *         ,..) should be a subset of the column names in the input data.
     *         </p>
     *         <p>
     *         If both <code>FeatureDataTypes</code> and <code>FeatureAttributeNames</code> are provided, then the
     *         column keys should be a subset of the column names provided in <code>FeatureAttributeNames</code>.
     *         </p>
     *         <p>
     *         The key name <code>FeatureAttributeNames</code> is fixed. The values listed in
     *         <code>["col1", "col2", ...]</code> is case sensitive and should be a list of strings containing unique
     *         values that are a subset of the column names in the input data. The list of columns provided must not
     *         include the target column.
     */
    public final String featureSpecificationS3Uri() {
        return featureSpecificationS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureSpecificationS3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidateGenerationConfig)) {
            return false;
        }
        AutoMLCandidateGenerationConfig other = (AutoMLCandidateGenerationConfig) obj;
        return Objects.equals(featureSpecificationS3Uri(), other.featureSpecificationS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLCandidateGenerationConfig").add("FeatureSpecificationS3Uri", featureSpecificationS3Uri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureSpecificationS3Uri":
            return Optional.ofNullable(clazz.cast(featureSpecificationS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidateGenerationConfig, T> g) {
        return obj -> g.apply((AutoMLCandidateGenerationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLCandidateGenerationConfig> {
        /**
         * <p>
         * A URL to the Amazon S3 data source containing selected features from the input data source to run an
         * Autopilot job. You can input <code>FeatureAttributeNames</code> (optional) in JSON format as shown below:
         * </p>
         * <p>
         * <code>{ "FeatureAttributeNames":["col1", "col2", ...] }</code>.
         * </p>
         * <p>
         * You can also specify the data type of the feature (optional) in the format shown below:
         * </p>
         * <p>
         * <code>{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }</code>
         * </p>
         * <note>
         * <p>
         * These column keys may not include the target column.
         * </p>
         * </note>
         * <p>
         * In ensembling mode, Autopilot will only support the following data types: <code>numeric</code>,
         * <code>categorical</code>, <code>text</code> and <code>datetime</code>. In HPO mode, Autopilot can support
         * <code>numeric</code>, <code>categorical</code>, <code>text</code>, <code>datetime</code> and
         * <code>sequence</code>.
         * </p>
         * <p>
         * If only <code>FeatureDataTypes</code> is provided, the column keys (<code>col1</code>, <code>col2</code>,..)
         * should be a subset of the column names in the input data.
         * </p>
         * <p>
         * If both <code>FeatureDataTypes</code> and <code>FeatureAttributeNames</code> are provided, then the column
         * keys should be a subset of the column names provided in <code>FeatureAttributeNames</code>.
         * </p>
         * <p>
         * The key name <code>FeatureAttributeNames</code> is fixed. The values listed in
         * <code>["col1", "col2", ...]</code> is case sensitive and should be a list of strings containing unique values
         * that are a subset of the column names in the input data. The list of columns provided must not include the
         * target column.
         * </p>
         * 
         * @param featureSpecificationS3Uri
         *        A URL to the Amazon S3 data source containing selected features from the input data source to run an
         *        Autopilot job. You can input <code>FeatureAttributeNames</code> (optional) in JSON format as shown
         *        below: </p>
         *        <p>
         *        <code>{ "FeatureAttributeNames":["col1", "col2", ...] }</code>.
         *        </p>
         *        <p>
         *        You can also specify the data type of the feature (optional) in the format shown below:
         *        </p>
         *        <p>
         *        <code>{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }</code>
         *        </p>
         *        <note>
         *        <p>
         *        These column keys may not include the target column.
         *        </p>
         *        </note>
         *        <p>
         *        In ensembling mode, Autopilot will only support the following data types: <code>numeric</code>,
         *        <code>categorical</code>, <code>text</code> and <code>datetime</code>. In HPO mode, Autopilot can
         *        support <code>numeric</code>, <code>categorical</code>, <code>text</code>, <code>datetime</code> and
         *        <code>sequence</code>.
         *        </p>
         *        <p>
         *        If only <code>FeatureDataTypes</code> is provided, the column keys (<code>col1</code>,
         *        <code>col2</code>,..) should be a subset of the column names in the input data.
         *        </p>
         *        <p>
         *        If both <code>FeatureDataTypes</code> and <code>FeatureAttributeNames</code> are provided, then the
         *        column keys should be a subset of the column names provided in <code>FeatureAttributeNames</code>.
         *        </p>
         *        <p>
         *        The key name <code>FeatureAttributeNames</code> is fixed. The values listed in
         *        <code>["col1", "col2", ...]</code> is case sensitive and should be a list of strings containing unique
         *        values that are a subset of the column names in the input data. The list of columns provided must not
         *        include the target column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureSpecificationS3Uri(String featureSpecificationS3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String featureSpecificationS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidateGenerationConfig model) {
            featureSpecificationS3Uri(model.featureSpecificationS3Uri);
        }

        public final String getFeatureSpecificationS3Uri() {
            return featureSpecificationS3Uri;
        }

        public final void setFeatureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
        }

        @Override
        public final Builder featureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
            return this;
        }

        @Override
        public AutoMLCandidateGenerationConfig build() {
            return new AutoMLCandidateGenerationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
