/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the training jobs launched by a hyperparameter tuning job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTrainingJobDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTrainingJobDefinition.Builder, HyperParameterTrainingJobDefinition> {
    private static final SdkField<String> DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefinitionName").getter(getter(HyperParameterTrainingJobDefinition::definitionName))
            .setter(setter(Builder::definitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionName").build()).build();

    private static final SdkField<HyperParameterTuningJobObjective> TUNING_OBJECTIVE_FIELD = SdkField
            .<HyperParameterTuningJobObjective> builder(MarshallingType.SDK_POJO).memberName("TuningObjective")
            .getter(getter(HyperParameterTrainingJobDefinition::tuningObjective)).setter(setter(Builder::tuningObjective))
            .constructor(HyperParameterTuningJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningObjective").build()).build();

    private static final SdkField<ParameterRanges> HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<ParameterRanges> builder(MarshallingType.SDK_POJO).memberName("HyperParameterRanges")
            .getter(getter(HyperParameterTrainingJobDefinition::hyperParameterRanges))
            .setter(setter(Builder::hyperParameterRanges)).constructor(ParameterRanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterRanges").build())
            .build();

    private static final SdkField<Map<String, String>> STATIC_HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StaticHyperParameters")
            .getter(getter(HyperParameterTrainingJobDefinition::staticHyperParameters))
            .setter(setter(Builder::staticHyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticHyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<HyperParameterAlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<HyperParameterAlgorithmSpecification> builder(MarshallingType.SDK_POJO).memberName("AlgorithmSpecification")
            .getter(getter(HyperParameterTrainingJobDefinition::algorithmSpecification))
            .setter(setter(Builder::algorithmSpecification)).constructor(HyperParameterAlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(HyperParameterTrainingJobDefinition::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<Channel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(HyperParameterTrainingJobDefinition::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Channel> builder(MarshallingType.SDK_POJO)
                                            .constructor(Channel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(HyperParameterTrainingJobDefinition::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(HyperParameterTrainingJobDefinition::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(HyperParameterTrainingJobDefinition::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(HyperParameterTrainingJobDefinition::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableNetworkIsolation").getter(getter(HyperParameterTrainingJobDefinition::enableNetworkIsolation))
            .setter(setter(Builder::enableNetworkIsolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build())
            .build();

    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInterContainerTrafficEncryption")
            .getter(getter(HyperParameterTrainingJobDefinition::enableInterContainerTrafficEncryption))
            .setter(setter(Builder::enableInterContainerTrafficEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableInterContainerTrafficEncryption").build()).build();

    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableManagedSpotTraining")
            .getter(getter(HyperParameterTrainingJobDefinition::enableManagedSpotTraining))
            .setter(setter(Builder::enableManagedSpotTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build())
            .build();

    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField
            .<CheckpointConfig> builder(MarshallingType.SDK_POJO).memberName("CheckpointConfig")
            .getter(getter(HyperParameterTrainingJobDefinition::checkpointConfig)).setter(setter(Builder::checkpointConfig))
            .constructor(CheckpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()).build();

    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<RetryStrategy> builder(MarshallingType.SDK_POJO).memberName("RetryStrategy")
            .getter(getter(HyperParameterTrainingJobDefinition::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(RetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()).build();

    private static final SdkField<HyperParameterTuningResourceConfig> HYPER_PARAMETER_TUNING_RESOURCE_CONFIG_FIELD = SdkField
            .<HyperParameterTuningResourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HyperParameterTuningResourceConfig")
            .getter(getter(HyperParameterTrainingJobDefinition::hyperParameterTuningResourceConfig))
            .setter(setter(Builder::hyperParameterTuningResourceConfig))
            .constructor(HyperParameterTuningResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningResourceConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_NAME_FIELD,
            TUNING_OBJECTIVE_FIELD, HYPER_PARAMETER_RANGES_FIELD, STATIC_HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD,
            ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, VPC_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD,
            STOPPING_CONDITION_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD,
            ENABLE_MANAGED_SPOT_TRAINING_FIELD, CHECKPOINT_CONFIG_FIELD, RETRY_STRATEGY_FIELD,
            HYPER_PARAMETER_TUNING_RESOURCE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String definitionName;

    private final HyperParameterTuningJobObjective tuningObjective;

    private final ParameterRanges hyperParameterRanges;

    private final Map<String, String> staticHyperParameters;

    private final HyperParameterAlgorithmSpecification algorithmSpecification;

    private final String roleArn;

    private final List<Channel> inputDataConfig;

    private final VpcConfig vpcConfig;

    private final OutputDataConfig outputDataConfig;

    private final ResourceConfig resourceConfig;

    private final StoppingCondition stoppingCondition;

    private final Boolean enableNetworkIsolation;

    private final Boolean enableInterContainerTrafficEncryption;

    private final Boolean enableManagedSpotTraining;

    private final CheckpointConfig checkpointConfig;

    private final RetryStrategy retryStrategy;

    private final HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig;

    private HyperParameterTrainingJobDefinition(BuilderImpl builder) {
        this.definitionName = builder.definitionName;
        this.tuningObjective = builder.tuningObjective;
        this.hyperParameterRanges = builder.hyperParameterRanges;
        this.staticHyperParameters = builder.staticHyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.vpcConfig = builder.vpcConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.retryStrategy = builder.retryStrategy;
        this.hyperParameterTuningResourceConfig = builder.hyperParameterTuningResourceConfig;
    }

    /**
     * <p>
     * The job definition name.
     * </p>
     * 
     * @return The job definition name.
     */
    public final String definitionName() {
        return definitionName;
    }

    /**
     * Returns the value of the TuningObjective property for this object.
     * 
     * @return The value of the TuningObjective property for this object.
     */
    public final HyperParameterTuningJobObjective tuningObjective() {
        return tuningObjective;
    }

    /**
     * Returns the value of the HyperParameterRanges property for this object.
     * 
     * @return The value of the HyperParameterRanges property for this object.
     */
    public final ParameterRanges hyperParameterRanges() {
        return hyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticHyperParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStaticHyperParameters() {
        return staticHyperParameters != null && !(staticHyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the values of hyperparameters that do not change for the tuning job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticHyperParameters} method.
     * </p>
     * 
     * @return Specifies the values of hyperparameters that do not change for the tuning job.
     */
    public final Map<String, String> staticHyperParameters() {
        return staticHyperParameters;
    }

    /**
     * <p>
     * The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the
     * training jobs that the tuning job launches.
     * </p>
     * 
     * @return The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for
     *         the training jobs that the tuning job launches.
     */
    public final HyperParameterAlgorithmSpecification algorithmSpecification() {
        return algorithmSpecification;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job
     *         launches.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDataConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDataConfig} method.
     * </p>
     * 
     * @return An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job
     *         launches.
     */
    public final List<Channel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter
     * tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For
     * more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training
     * Jobs by Using an Amazon Virtual Private Cloud</a>.
     * </p>
     * 
     * @return The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this
     *         hyperparameter tuning job launches to connect to. Control access to and from your training container by
     *         configuring the VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an
     *         Amazon Virtual Private Cloud</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning
     * job launches.
     * </p>
     * 
     * @return Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that
     *         the tuning job launches.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning
     * job launches.
     * </p>
     * <p>
     * Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes
     * for scratch space. If you want SageMaker to use the storage volume to store the training data, choose
     * <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training
     * algorithms, specify an instance count greater than 1.
     * </p>
     * <note>
     * <p>
     * If you want to use hyperparameter optimization with instance type flexibility, use
     * <code>HyperParameterTuningResourceConfig</code> instead.
     * </p>
     * </note>
     * 
     * @return The resources, including the compute instances and storage volumes, to use for the training jobs that the
     *         tuning job launches.</p>
     *         <p>
     *         Storage volumes store model artifacts and incremental states. Training algorithms might also use storage
     *         volumes for scratch space. If you want SageMaker to use the storage volume to store the training data,
     *         choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For
     *         distributed training algorithms, specify an instance count greater than 1.
     *         </p>
     *         <note>
     *         <p>
     *         If you want to use hyperparameter optimization with instance type flexibility, use
     *         <code>HyperParameterTuningResourceConfig</code> instead.
     *         </p>
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a managed
     * spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this
     * API to cap model training costs.
     * </p>
     * 
     * @return Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a
     *         managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the
     *         training job. Use this API to cap model training costs.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers
     * within a training cluster for distributed training. If network isolation is used for training jobs that are
     * configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified
     * VPC, but the training container does not have network access.
     * </p>
     * 
     * @return Isolates the training container. No inbound or outbound network calls can be made, except for calls
     *         between peers within a training cluster for distributed training. If network isolation is used for
     *         training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model
     *         artifacts through the specified VPC, but the training container does not have network access.
     */
    public final Boolean enableNetworkIsolation() {
        return enableNetworkIsolation;
    }

    /**
     * <p>
     * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
     * Encryption provides greater security for distributed training, but training might take longer. How long it takes
     * depends on the amount of communication between compute instances, especially if you use a deep learning algorithm
     * in distributed training.
     * </p>
     * 
     * @return To encrypt all communications between ML compute instances in distributed training, choose
     *         <code>True</code>. Encryption provides greater security for distributed training, but training might take
     *         longer. How long it takes depends on the amount of communication between compute instances, especially if
     *         you use a deep learning algorithm in distributed training.
     */
    public final Boolean enableInterContainerTrafficEncryption() {
        return enableInterContainerTrafficEncryption;
    }

    /**
     * <p>
     * A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).
     * </p>
     * 
     * @return A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (
     *         <code>False</code>).
     */
    public final Boolean enableManagedSpotTraining() {
        return enableManagedSpotTraining;
    }

    /**
     * Returns the value of the CheckpointConfig property for this object.
     * 
     * @return The value of the CheckpointConfig property for this object.
     */
    public final CheckpointConfig checkpointConfig() {
        return checkpointConfig;
    }

    /**
     * <p>
     * The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.
     * </p>
     * 
     * @return The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.
     */
    public final RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The configuration for the hyperparameter tuning resources, including the compute instances and storage volumes,
     * used for training jobs launched by the tuning job. By default, storage volumes hold model artifacts and
     * incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the
     * <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage volume
     * (optional).
     * </p>
     * 
     * @return The configuration for the hyperparameter tuning resources, including the compute instances and storage
     *         volumes, used for training jobs launched by the tuning job. By default, storage volumes hold model
     *         artifacts and incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the
     *         <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage volume
     *         (optional).
     */
    public final HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig() {
        return hyperParameterTuningResourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definitionName());
        hashCode = 31 * hashCode + Objects.hashCode(tuningObjective());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticHyperParameters() ? staticHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningResourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobDefinition)) {
            return false;
        }
        HyperParameterTrainingJobDefinition other = (HyperParameterTrainingJobDefinition) obj;
        return Objects.equals(definitionName(), other.definitionName())
                && Objects.equals(tuningObjective(), other.tuningObjective())
                && Objects.equals(hyperParameterRanges(), other.hyperParameterRanges())
                && hasStaticHyperParameters() == other.hasStaticHyperParameters()
                && Objects.equals(staticHyperParameters(), other.staticHyperParameters())
                && Objects.equals(algorithmSpecification(), other.algorithmSpecification())
                && Objects.equals(roleArn(), other.roleArn()) && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(enableNetworkIsolation(), other.enableNetworkIsolation())
                && Objects.equals(enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption())
                && Objects.equals(enableManagedSpotTraining(), other.enableManagedSpotTraining())
                && Objects.equals(checkpointConfig(), other.checkpointConfig())
                && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(hyperParameterTuningResourceConfig(), other.hyperParameterTuningResourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTrainingJobDefinition").add("DefinitionName", definitionName())
                .add("TuningObjective", tuningObjective()).add("HyperParameterRanges", hyperParameterRanges())
                .add("StaticHyperParameters", hasStaticHyperParameters() ? staticHyperParameters() : null)
                .add("AlgorithmSpecification", algorithmSpecification()).add("RoleArn", roleArn())
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null).add("VpcConfig", vpcConfig())
                .add("OutputDataConfig", outputDataConfig()).add("ResourceConfig", resourceConfig())
                .add("StoppingCondition", stoppingCondition()).add("EnableNetworkIsolation", enableNetworkIsolation())
                .add("EnableInterContainerTrafficEncryption", enableInterContainerTrafficEncryption())
                .add("EnableManagedSpotTraining", enableManagedSpotTraining()).add("CheckpointConfig", checkpointConfig())
                .add("RetryStrategy", retryStrategy())
                .add("HyperParameterTuningResourceConfig", hyperParameterTuningResourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefinitionName":
            return Optional.ofNullable(clazz.cast(definitionName()));
        case "TuningObjective":
            return Optional.ofNullable(clazz.cast(tuningObjective()));
        case "HyperParameterRanges":
            return Optional.ofNullable(clazz.cast(hyperParameterRanges()));
        case "StaticHyperParameters":
            return Optional.ofNullable(clazz.cast(staticHyperParameters()));
        case "AlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(algorithmSpecification()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "EnableNetworkIsolation":
            return Optional.ofNullable(clazz.cast(enableNetworkIsolation()));
        case "EnableInterContainerTrafficEncryption":
            return Optional.ofNullable(clazz.cast(enableInterContainerTrafficEncryption()));
        case "EnableManagedSpotTraining":
            return Optional.ofNullable(clazz.cast(enableManagedSpotTraining()));
        case "CheckpointConfig":
            return Optional.ofNullable(clazz.cast(checkpointConfig()));
        case "RetryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "HyperParameterTuningResourceConfig":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningResourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTrainingJobDefinition, T> g) {
        return obj -> g.apply((HyperParameterTrainingJobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTrainingJobDefinition> {
        /**
         * <p>
         * The job definition name.
         * </p>
         * 
         * @param definitionName
         *        The job definition name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionName(String definitionName);

        /**
         * Sets the value of the TuningObjective property for this object.
         *
         * @param tuningObjective
         *        The new value for the TuningObjective property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningObjective(HyperParameterTuningJobObjective tuningObjective);

        /**
         * Sets the value of the TuningObjective property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HyperParameterTuningJobObjective.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTuningJobObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobObjective.Builder#build()} is called
         * immediately and its result is passed to {@link #tuningObjective(HyperParameterTuningJobObjective)}.
         * 
         * @param tuningObjective
         *        a consumer that will call methods on {@link HyperParameterTuningJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tuningObjective(HyperParameterTuningJobObjective)
         */
        default Builder tuningObjective(Consumer<HyperParameterTuningJobObjective.Builder> tuningObjective) {
            return tuningObjective(HyperParameterTuningJobObjective.builder().applyMutation(tuningObjective).build());
        }

        /**
         * Sets the value of the HyperParameterRanges property for this object.
         *
         * @param hyperParameterRanges
         *        The new value for the HyperParameterRanges property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterRanges(ParameterRanges hyperParameterRanges);

        /**
         * Sets the value of the HyperParameterRanges property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParameterRanges.Builder} avoiding the
         * need to create one manually via {@link ParameterRanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterRanges.Builder#build()} is called immediately and its
         * result is passed to {@link #hyperParameterRanges(ParameterRanges)}.
         * 
         * @param hyperParameterRanges
         *        a consumer that will call methods on {@link ParameterRanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterRanges(ParameterRanges)
         */
        default Builder hyperParameterRanges(Consumer<ParameterRanges.Builder> hyperParameterRanges) {
            return hyperParameterRanges(ParameterRanges.builder().applyMutation(hyperParameterRanges).build());
        }

        /**
         * <p>
         * Specifies the values of hyperparameters that do not change for the tuning job.
         * </p>
         * 
         * @param staticHyperParameters
         *        Specifies the values of hyperparameters that do not change for the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticHyperParameters(Map<String, String> staticHyperParameters);

        /**
         * <p>
         * The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the
         * training jobs that the tuning job launches.
         * </p>
         * 
         * @param algorithmSpecification
         *        The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use
         *        for the training jobs that the tuning job launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification);

        /**
         * <p>
         * The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the
         * training jobs that the tuning job launches.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterAlgorithmSpecification.Builder} avoiding the need to create one manually via
         * {@link HyperParameterAlgorithmSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterAlgorithmSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #algorithmSpecification(HyperParameterAlgorithmSpecification)}.
         * 
         * @param algorithmSpecification
         *        a consumer that will call methods on {@link HyperParameterAlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSpecification(HyperParameterAlgorithmSpecification)
         */
        default Builder algorithmSpecification(Consumer<HyperParameterAlgorithmSpecification.Builder> algorithmSpecification) {
            return algorithmSpecification(HyperParameterAlgorithmSpecification.builder().applyMutation(algorithmSpecification)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job
         * launches.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job
         *        launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job
         *        launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<Channel> inputDataConfig);

        /**
         * <p>
         * An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job
         *        launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Channel... inputDataConfig);

        /**
         * <p>
         * An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Channel.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Channel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Channel.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(List<Channel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Channel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(java.util.Collection<Channel>)
         */
        Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig);

        /**
         * <p>
         * The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter
         * tuning job launches to connect to. Control access to and from your training container by configuring the VPC.
         * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect
         * Training Jobs by Using an Amazon Virtual Private Cloud</a>.
         * </p>
         * 
         * @param vpcConfig
         *        The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this
         *        hyperparameter tuning job launches to connect to. Control access to and from your training container
         *        by configuring the VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using
         *        an Amazon Virtual Private Cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter
         * tuning job launches to connect to. Control access to and from your training container by configuring the VPC.
         * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect
         * Training Jobs by Using an Amazon Virtual Private Cloud</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the
         * tuning job launches.
         * </p>
         * 
         * @param outputDataConfig
         *        Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that
         *        the tuning job launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the
         * tuning job launches.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The resources, including the compute instances and storage volumes, to use for the training jobs that the
         * tuning job launches.
         * </p>
         * <p>
         * Storage volumes store model artifacts and incremental states. Training algorithms might also use storage
         * volumes for scratch space. If you want SageMaker to use the storage volume to store the training data, choose
         * <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed
         * training algorithms, specify an instance count greater than 1.
         * </p>
         * <note>
         * <p>
         * If you want to use hyperparameter optimization with instance type flexibility, use
         * <code>HyperParameterTuningResourceConfig</code> instead.
         * </p>
         * </note>
         * 
         * @param resourceConfig
         *        The resources, including the compute instances and storage volumes, to use for the training jobs that
         *        the tuning job launches.</p>
         *        <p>
         *        Storage volumes store model artifacts and incremental states. Training algorithms might also use
         *        storage volumes for scratch space. If you want SageMaker to use the storage volume to store the
         *        training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm
         *        specification. For distributed training algorithms, specify an instance count greater than 1.
         *        </p>
         *        <note>
         *        <p>
         *        If you want to use hyperparameter optimization with instance type flexibility, use
         *        <code>HyperParameterTuningResourceConfig</code> instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * The resources, including the compute instances and storage volumes, to use for the training jobs that the
         * tuning job launches.
         * </p>
         * <p>
         * Storage volumes store model artifacts and incremental states. Training algorithms might also use storage
         * volumes for scratch space. If you want SageMaker to use the storage volume to store the training data, choose
         * <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed
         * training algorithms, specify an instance count greater than 1.
         * </p>
         * <note>
         * <p>
         * If you want to use hyperparameter optimization with instance type flexibility, use
         * <code>HyperParameterTuningResourceConfig</code> instead.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ResourceConfig.Builder} avoiding
         * the need to create one manually via {@link ResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a
         * managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training
         * job. Use this API to cap model training costs.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long
         *        a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the
         *        training job. Use this API to cap model training costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a
         * managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training
         * job. Use this API to cap model training costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * Isolates the training container. No inbound or outbound network calls can be made, except for calls between
         * peers within a training cluster for distributed training. If network isolation is used for training jobs that
         * are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the
         * specified VPC, but the training container does not have network access.
         * </p>
         * 
         * @param enableNetworkIsolation
         *        Isolates the training container. No inbound or outbound network calls can be made, except for calls
         *        between peers within a training cluster for distributed training. If network isolation is used for
         *        training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and
         *        model artifacts through the specified VPC, but the training container does not have network access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNetworkIsolation(Boolean enableNetworkIsolation);

        /**
         * <p>
         * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
         * Encryption provides greater security for distributed training, but training might take longer. How long it
         * takes depends on the amount of communication between compute instances, especially if you use a deep learning
         * algorithm in distributed training.
         * </p>
         * 
         * @param enableInterContainerTrafficEncryption
         *        To encrypt all communications between ML compute instances in distributed training, choose
         *        <code>True</code>. Encryption provides greater security for distributed training, but training might
         *        take longer. How long it takes depends on the amount of communication between compute instances,
         *        especially if you use a deep learning algorithm in distributed training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption);

        /**
         * <p>
         * A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>
         * ).
         * </p>
         * 
         * @param enableManagedSpotTraining
         *        A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (
         *        <code>False</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining);

        /**
         * Sets the value of the CheckpointConfig property for this object.
         *
         * @param checkpointConfig
         *        The new value for the CheckpointConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfig(CheckpointConfig checkpointConfig);

        /**
         * Sets the value of the CheckpointConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CheckpointConfig.Builder} avoiding the
         * need to create one manually via {@link CheckpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CheckpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #checkpointConfig(CheckpointConfig)}.
         * 
         * @param checkpointConfig
         *        a consumer that will call methods on {@link CheckpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfig(CheckpointConfig)
         */
        default Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return checkpointConfig(CheckpointConfig.builder().applyMutation(checkpointConfig).build());
        }

        /**
         * <p>
         * The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.
         * </p>
         * 
         * @param retryStrategy
         *        The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryStrategy.Builder} avoiding the need
         * to create one manually via {@link RetryStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The configuration for the hyperparameter tuning resources, including the compute instances and storage
         * volumes, used for training jobs launched by the tuning job. By default, storage volumes hold model artifacts
         * and incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the
         * <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage volume
         * (optional).
         * </p>
         * 
         * @param hyperParameterTuningResourceConfig
         *        The configuration for the hyperparameter tuning resources, including the compute instances and storage
         *        volumes, used for training jobs launched by the tuning job. By default, storage volumes hold model
         *        artifacts and incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the
         *        <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage
         *        volume (optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig);

        /**
         * <p>
         * The configuration for the hyperparameter tuning resources, including the compute instances and storage
         * volumes, used for training jobs launched by the tuning job. By default, storage volumes hold model artifacts
         * and incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the
         * <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage volume
         * (optional).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterTuningResourceConfig.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTuningResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningResourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #hyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig)}.
         * 
         * @param hyperParameterTuningResourceConfig
         *        a consumer that will call methods on {@link HyperParameterTuningResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig)
         */
        default Builder hyperParameterTuningResourceConfig(
                Consumer<HyperParameterTuningResourceConfig.Builder> hyperParameterTuningResourceConfig) {
            return hyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig.builder()
                    .applyMutation(hyperParameterTuningResourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String definitionName;

        private HyperParameterTuningJobObjective tuningObjective;

        private ParameterRanges hyperParameterRanges;

        private Map<String, String> staticHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private HyperParameterAlgorithmSpecification algorithmSpecification;

        private String roleArn;

        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private OutputDataConfig outputDataConfig;

        private ResourceConfig resourceConfig;

        private StoppingCondition stoppingCondition;

        private Boolean enableNetworkIsolation;

        private Boolean enableInterContainerTrafficEncryption;

        private Boolean enableManagedSpotTraining;

        private CheckpointConfig checkpointConfig;

        private RetryStrategy retryStrategy;

        private HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobDefinition model) {
            definitionName(model.definitionName);
            tuningObjective(model.tuningObjective);
            hyperParameterRanges(model.hyperParameterRanges);
            staticHyperParameters(model.staticHyperParameters);
            algorithmSpecification(model.algorithmSpecification);
            roleArn(model.roleArn);
            inputDataConfig(model.inputDataConfig);
            vpcConfig(model.vpcConfig);
            outputDataConfig(model.outputDataConfig);
            resourceConfig(model.resourceConfig);
            stoppingCondition(model.stoppingCondition);
            enableNetworkIsolation(model.enableNetworkIsolation);
            enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            enableManagedSpotTraining(model.enableManagedSpotTraining);
            checkpointConfig(model.checkpointConfig);
            retryStrategy(model.retryStrategy);
            hyperParameterTuningResourceConfig(model.hyperParameterTuningResourceConfig);
        }

        public final String getDefinitionName() {
            return definitionName;
        }

        public final void setDefinitionName(String definitionName) {
            this.definitionName = definitionName;
        }

        @Override
        public final Builder definitionName(String definitionName) {
            this.definitionName = definitionName;
            return this;
        }

        public final HyperParameterTuningJobObjective.Builder getTuningObjective() {
            return tuningObjective != null ? tuningObjective.toBuilder() : null;
        }

        public final void setTuningObjective(HyperParameterTuningJobObjective.BuilderImpl tuningObjective) {
            this.tuningObjective = tuningObjective != null ? tuningObjective.build() : null;
        }

        @Override
        public final Builder tuningObjective(HyperParameterTuningJobObjective tuningObjective) {
            this.tuningObjective = tuningObjective;
            return this;
        }

        public final ParameterRanges.Builder getHyperParameterRanges() {
            return hyperParameterRanges != null ? hyperParameterRanges.toBuilder() : null;
        }

        public final void setHyperParameterRanges(ParameterRanges.BuilderImpl hyperParameterRanges) {
            this.hyperParameterRanges = hyperParameterRanges != null ? hyperParameterRanges.build() : null;
        }

        @Override
        public final Builder hyperParameterRanges(ParameterRanges hyperParameterRanges) {
            this.hyperParameterRanges = hyperParameterRanges;
            return this;
        }

        public final Map<String, String> getStaticHyperParameters() {
            if (staticHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return staticHyperParameters;
        }

        public final void setStaticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
        }

        @Override
        public final Builder staticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
            return this;
        }

        public final HyperParameterAlgorithmSpecification.Builder getAlgorithmSpecification() {
            return algorithmSpecification != null ? algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(HyperParameterAlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Channel.Builder> getInputDataConfig() {
            List<Channel.Builder> result = InputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> Channel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return enableInterContainerTrafficEncryption;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return enableManagedSpotTraining;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return checkpointConfig != null ? checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final HyperParameterTuningResourceConfig.Builder getHyperParameterTuningResourceConfig() {
            return hyperParameterTuningResourceConfig != null ? hyperParameterTuningResourceConfig.toBuilder() : null;
        }

        public final void setHyperParameterTuningResourceConfig(
                HyperParameterTuningResourceConfig.BuilderImpl hyperParameterTuningResourceConfig) {
            this.hyperParameterTuningResourceConfig = hyperParameterTuningResourceConfig != null ? hyperParameterTuningResourceConfig
                    .build() : null;
        }

        @Override
        public final Builder hyperParameterTuningResourceConfig(
                HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig) {
            this.hyperParameterTuningResourceConfig = hyperParameterTuningResourceConfig;
            return this;
        }

        @Override
        public HyperParameterTrainingJobDefinition build() {
            return new HyperParameterTrainingJobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
