/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelCardRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateModelCardRequest.Builder, UpdateModelCardRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(UpdateModelCardRequest::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(UpdateModelCardRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(UpdateModelCardRequest::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD,
            CONTENT_FIELD, MODEL_CARD_STATUS_FIELD));

    private final String modelCardName;

    private final String content;

    private final String modelCardStatus;

    private UpdateModelCardRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.content = builder.content;
        this.modelCardStatus = builder.modelCardStatus;
    }

    /**
     * <p>
     * The name of the model card to update.
     * </p>
     * 
     * @return The name of the model card to update.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The updated model card content. Content must be in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html">model card JSON
     * schema</a> and provided as a string.
     * </p>
     * <p>
     * When updating model card content, be sure to include the full content and not just updated content.
     * </p>
     * 
     * @return The updated model card content. Content must be in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html">model card JSON
     *         schema</a> and provided as a string.</p>
     *         <p>
     *         When updating model card content, be sure to include the full content and not just updated content.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelCardRequest)) {
            return false;
        }
        UpdateModelCardRequest other = (UpdateModelCardRequest) obj;
        return Objects.equals(modelCardName(), other.modelCardName()) && Objects.equals(content(), other.content())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateModelCardRequest").add("ModelCardName", modelCardName())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelCardStatus", modelCardStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelCardRequest, T> g) {
        return obj -> g.apply((UpdateModelCardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelCardRequest> {
        /**
         * <p>
         * The name of the model card to update.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The updated model card content. Content must be in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html">model card JSON
         * schema</a> and provided as a string.
         * </p>
         * <p>
         * When updating model card content, be sure to include the full content and not just updated content.
         * </p>
         * 
         * @param content
         *        The updated model card content. Content must be in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html">model card
         *        JSON schema</a> and provided as a string.</p>
         *        <p>
         *        When updating model card content, be sure to include the full content and not just updated content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelCardName;

        private String content;

        private String modelCardStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelCardRequest model) {
            super(model);
            modelCardName(model.modelCardName);
            content(model.content);
            modelCardStatus(model.modelCardStatus);
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelCardRequest build() {
            return new UpdateModelCardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
