/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings used for an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobConfig implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLJobConfig.Builder, AutoMLJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO).memberName("CompletionCriteria")
            .getter(getter(AutoMLJobConfig::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<AutoMLSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(AutoMLJobConfig::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(AutoMLSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField
            .<AutoMLDataSplitConfig> builder(MarshallingType.SDK_POJO).memberName("DataSplitConfig")
            .getter(getter(AutoMLJobConfig::dataSplitConfig)).setter(setter(Builder::dataSplitConfig))
            .constructor(AutoMLDataSplitConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()).build();

    private static final SdkField<AutoMLCandidateGenerationConfig> CANDIDATE_GENERATION_CONFIG_FIELD = SdkField
            .<AutoMLCandidateGenerationConfig> builder(MarshallingType.SDK_POJO).memberName("CandidateGenerationConfig")
            .getter(getter(AutoMLJobConfig::candidateGenerationConfig)).setter(setter(Builder::candidateGenerationConfig))
            .constructor(AutoMLCandidateGenerationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateGenerationConfig").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(AutoMLJobConfig::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD,
            SECURITY_CONFIG_FIELD, DATA_SPLIT_CONFIG_FIELD, CANDIDATE_GENERATION_CONFIG_FIELD, MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private final AutoMLSecurityConfig securityConfig;

    private final AutoMLDataSplitConfig dataSplitConfig;

    private final AutoMLCandidateGenerationConfig candidateGenerationConfig;

    private final String mode;

    private AutoMLJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.securityConfig = builder.securityConfig;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.candidateGenerationConfig = builder.candidateGenerationConfig;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
     * </p>
     * 
     * @return How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public final AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    /**
     * <p>
     * The security configuration for traffic encryption or Amazon VPC settings.
     * </p>
     * 
     * @return The security configuration for traffic encryption or Amazon VPC settings.
     */
    public final AutoMLSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * The configuration for splitting the input training dataset.
     * </p>
     * <p>
     * Type: AutoMLDataSplitConfig
     * </p>
     * 
     * @return The configuration for splitting the input training dataset.</p>
     *         <p>
     *         Type: AutoMLDataSplitConfig
     */
    public final AutoMLDataSplitConfig dataSplitConfig() {
        return dataSplitConfig;
    }

    /**
     * <p>
     * The configuration for generating a candidate for an AutoML job (optional).
     * </p>
     * 
     * @return The configuration for generating a candidate for an AutoML job (optional).
     */
    public final AutoMLCandidateGenerationConfig candidateGenerationConfig() {
        return candidateGenerationConfig;
    }

    /**
     * <p>
     * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot
     * choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot
     * chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for
     * larger ones.
     * </p>
     * <p>
     * The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression tasks
     * directly from your dataset. This machine learning mode combines several base models to produce an optimal
     * predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A
     * multi-stack ensemble model can provide better performance over a single model by combining the predictive
     * capabilities of multiple models. See <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     * >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
     * </p>
     * <p>
     * The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of a
     * model. HPO will automatically select an algorithm for the type of problem you want to solve. Then HPO finds the
     * best hyperparameters according to your objective metric. See <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     * >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AutoMLMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The method that Autopilot uses to train the data. You can either specify the mode manually or let
     *         Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code>
     *         mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and
     *         <code>HYPERPARAMETER_TUNING</code> for larger ones.</p>
     *         <p>
     *         The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and
     *         regression tasks directly from your dataset. This machine learning mode combines several base models to
     *         produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from
     *         contributing members. A multi-stack ensemble model can provide better performance over a single model by
     *         combining the predictive capabilities of multiple models. See <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     *         >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
     *         </p>
     *         <p>
     *         The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version
     *         of a model. HPO will automatically select an algorithm for the type of problem you want to solve. Then
     *         HPO finds the best hyperparameters according to your objective metric. See <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     *         >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code>
     *         mode.
     * @see AutoMLMode
     */
    public final AutoMLMode mode() {
        return AutoMLMode.fromValue(mode);
    }

    /**
     * <p>
     * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot
     * choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot
     * chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for
     * larger ones.
     * </p>
     * <p>
     * The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression tasks
     * directly from your dataset. This machine learning mode combines several base models to produce an optimal
     * predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A
     * multi-stack ensemble model can provide better performance over a single model by combining the predictive
     * capabilities of multiple models. See <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     * >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
     * </p>
     * <p>
     * The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of a
     * model. HPO will automatically select an algorithm for the type of problem you want to solve. Then HPO finds the
     * best hyperparameters according to your objective metric. See <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     * >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AutoMLMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The method that Autopilot uses to train the data. You can either specify the mode manually or let
     *         Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code>
     *         mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and
     *         <code>HYPERPARAMETER_TUNING</code> for larger ones.</p>
     *         <p>
     *         The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and
     *         regression tasks directly from your dataset. This machine learning mode combines several base models to
     *         produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from
     *         contributing members. A multi-stack ensemble model can provide better performance over a single model by
     *         combining the predictive capabilities of multiple models. See <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     *         >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
     *         </p>
     *         <p>
     *         The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version
     *         of a model. HPO will automatically select an algorithm for the type of problem you want to solve. Then
     *         HPO finds the best hyperparameters according to your objective metric. See <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
     *         >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code>
     *         mode.
     * @see AutoMLMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(candidateGenerationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobConfig)) {
            return false;
        }
        AutoMLJobConfig other = (AutoMLJobConfig) obj;
        return Objects.equals(completionCriteria(), other.completionCriteria())
                && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(dataSplitConfig(), other.dataSplitConfig())
                && Objects.equals(candidateGenerationConfig(), other.candidateGenerationConfig())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLJobConfig").add("CompletionCriteria", completionCriteria())
                .add("SecurityConfig", securityConfig()).add("DataSplitConfig", dataSplitConfig())
                .add("CandidateGenerationConfig", candidateGenerationConfig()).add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "DataSplitConfig":
            return Optional.ofNullable(clazz.cast(dataSplitConfig()));
        case "CandidateGenerationConfig":
            return Optional.ofNullable(clazz.cast(candidateGenerationConfig()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobConfig, T> g) {
        return obj -> g.apply((AutoMLJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobConfig> {
        /**
         * <p>
         * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * 
         * @param completionCriteria
         *        How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * <p>
         * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * 
         * @param securityConfig
         *        The security configuration for traffic encryption or Amazon VPC settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(AutoMLSecurityConfig securityConfig);

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLSecurityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfig(AutoMLSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link AutoMLSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(AutoMLSecurityConfig)
         */
        default Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return securityConfig(AutoMLSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * The configuration for splitting the input training dataset.
         * </p>
         * <p>
         * Type: AutoMLDataSplitConfig
         * </p>
         * 
         * @param dataSplitConfig
         *        The configuration for splitting the input training dataset.</p>
         *        <p>
         *        Type: AutoMLDataSplitConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig);

        /**
         * <p>
         * The configuration for splitting the input training dataset.
         * </p>
         * <p>
         * Type: AutoMLDataSplitConfig
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLDataSplitConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLDataSplitConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLDataSplitConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSplitConfig(AutoMLDataSplitConfig)}.
         * 
         * @param dataSplitConfig
         *        a consumer that will call methods on {@link AutoMLDataSplitConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSplitConfig(AutoMLDataSplitConfig)
         */
        default Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return dataSplitConfig(AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig).build());
        }

        /**
         * <p>
         * The configuration for generating a candidate for an AutoML job (optional).
         * </p>
         * 
         * @param candidateGenerationConfig
         *        The configuration for generating a candidate for an AutoML job (optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateGenerationConfig(AutoMLCandidateGenerationConfig candidateGenerationConfig);

        /**
         * <p>
         * The configuration for generating a candidate for an AutoML job (optional).
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLCandidateGenerationConfig.Builder}
         * avoiding the need to create one manually via {@link AutoMLCandidateGenerationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLCandidateGenerationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #candidateGenerationConfig(AutoMLCandidateGenerationConfig)}.
         * 
         * @param candidateGenerationConfig
         *        a consumer that will call methods on {@link AutoMLCandidateGenerationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateGenerationConfig(AutoMLCandidateGenerationConfig)
         */
        default Builder candidateGenerationConfig(Consumer<AutoMLCandidateGenerationConfig.Builder> candidateGenerationConfig) {
            return candidateGenerationConfig(AutoMLCandidateGenerationConfig.builder().applyMutation(candidateGenerationConfig)
                    .build());
        }

        /**
         * <p>
         * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot
         * choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot
         * chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for
         * larger ones.
         * </p>
         * <p>
         * The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression
         * tasks directly from your dataset. This machine learning mode combines several base models to produce an
         * optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing
         * members. A multi-stack ensemble model can provide better performance over a single model by combining the
         * predictive capabilities of multiple models. See <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         * >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
         * </p>
         * <p>
         * The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of
         * a model. HPO will automatically select an algorithm for the type of problem you want to solve. Then HPO finds
         * the best hyperparameters according to your objective metric. See <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         * >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code>
         * mode.
         * </p>
         * 
         * @param mode
         *        The method that Autopilot uses to train the data. You can either specify the mode manually or let
         *        Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In
         *        <code>AUTO</code> mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB,
         *        and <code>HYPERPARAMETER_TUNING</code> for larger ones.</p>
         *        <p>
         *        The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and
         *        regression tasks directly from your dataset. This machine learning mode combines several base models
         *        to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions
         *        from contributing members. A multi-stack ensemble model can provide better performance over a single
         *        model by combining the predictive capabilities of multiple models. See <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         *        >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
         *        </p>
         *        <p>
         *        The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best
         *        version of a model. HPO will automatically select an algorithm for the type of problem you want to
         *        solve. Then HPO finds the best hyperparameters according to your objective metric. See <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         *        >Autopilot algorithm support</a> for a list of algorithms supported by
         *        <code>HYPERPARAMETER_TUNING</code> mode.
         * @see AutoMLMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot
         * choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot
         * chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for
         * larger ones.
         * </p>
         * <p>
         * The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression
         * tasks directly from your dataset. This machine learning mode combines several base models to produce an
         * optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing
         * members. A multi-stack ensemble model can provide better performance over a single model by combining the
         * predictive capabilities of multiple models. See <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         * >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
         * </p>
         * <p>
         * The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of
         * a model. HPO will automatically select an algorithm for the type of problem you want to solve. Then HPO finds
         * the best hyperparameters according to your objective metric. See <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         * >Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code>
         * mode.
         * </p>
         * 
         * @param mode
         *        The method that Autopilot uses to train the data. You can either specify the mode manually or let
         *        Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In
         *        <code>AUTO</code> mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB,
         *        and <code>HYPERPARAMETER_TUNING</code> for larger ones.</p>
         *        <p>
         *        The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and
         *        regression tasks directly from your dataset. This machine learning mode combines several base models
         *        to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions
         *        from contributing members. A multi-stack ensemble model can provide better performance over a single
         *        model by combining the predictive capabilities of multiple models. See <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         *        >Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.
         *        </p>
         *        <p>
         *        The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best
         *        version of a model. HPO will automatically select an algorithm for the type of problem you want to
         *        solve. Then HPO finds the best hyperparameters according to your objective metric. See <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-suppprt"
         *        >Autopilot algorithm support</a> for a list of algorithms supported by
         *        <code>HYPERPARAMETER_TUNING</code> mode.
         * @see AutoMLMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMode
         */
        Builder mode(AutoMLMode mode);
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;

        private AutoMLSecurityConfig securityConfig;

        private AutoMLDataSplitConfig dataSplitConfig;

        private AutoMLCandidateGenerationConfig candidateGenerationConfig;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobConfig model) {
            completionCriteria(model.completionCriteria);
            securityConfig(model.securityConfig);
            dataSplitConfig(model.dataSplitConfig);
            candidateGenerationConfig(model.candidateGenerationConfig);
            mode(model.mode);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return dataSplitConfig != null ? dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final AutoMLCandidateGenerationConfig.Builder getCandidateGenerationConfig() {
            return candidateGenerationConfig != null ? candidateGenerationConfig.toBuilder() : null;
        }

        public final void setCandidateGenerationConfig(AutoMLCandidateGenerationConfig.BuilderImpl candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig != null ? candidateGenerationConfig.build() : null;
        }

        @Override
        public final Builder candidateGenerationConfig(AutoMLCandidateGenerationConfig candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AutoMLMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public AutoMLJobConfig build() {
            return new AutoMLJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
