/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the model configuration. Includes the specification name and environment parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelConfiguration.Builder, ModelConfiguration> {
    private static final SdkField<String> INFERENCE_SPECIFICATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceSpecificationName")
            .getter(getter(ModelConfiguration::inferenceSpecificationName))
            .setter(setter(Builder::inferenceSpecificationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecificationName").build())
            .build();

    private static final SdkField<List<EnvironmentParameter>> ENVIRONMENT_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentParameter>> builder(MarshallingType.LIST)
            .memberName("EnvironmentParameters")
            .getter(getter(ModelConfiguration::environmentParameters))
            .setter(setter(Builder::environmentParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_SPECIFICATION_NAME_FIELD, ENVIRONMENT_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inferenceSpecificationName;

    private final List<EnvironmentParameter> environmentParameters;

    private ModelConfiguration(BuilderImpl builder) {
        this.inferenceSpecificationName = builder.inferenceSpecificationName;
        this.environmentParameters = builder.environmentParameters;
    }

    /**
     * <p>
     * The inference specification name in the model package version.
     * </p>
     * 
     * @return The inference specification name in the model package version.
     */
    public final String inferenceSpecificationName() {
        return inferenceSpecificationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentParameters() {
        return environmentParameters != null && !(environmentParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the environment parameters that includes key, value types, and values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentParameters} method.
     * </p>
     * 
     * @return Defines the environment parameters that includes key, value types, and values.
     */
    public final List<EnvironmentParameter> environmentParameters() {
        return environmentParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecificationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentParameters() ? environmentParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelConfiguration)) {
            return false;
        }
        ModelConfiguration other = (ModelConfiguration) obj;
        return Objects.equals(inferenceSpecificationName(), other.inferenceSpecificationName())
                && hasEnvironmentParameters() == other.hasEnvironmentParameters()
                && Objects.equals(environmentParameters(), other.environmentParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelConfiguration").add("InferenceSpecificationName", inferenceSpecificationName())
                .add("EnvironmentParameters", hasEnvironmentParameters() ? environmentParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceSpecificationName":
            return Optional.ofNullable(clazz.cast(inferenceSpecificationName()));
        case "EnvironmentParameters":
            return Optional.ofNullable(clazz.cast(environmentParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelConfiguration, T> g) {
        return obj -> g.apply((ModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelConfiguration> {
        /**
         * <p>
         * The inference specification name in the model package version.
         * </p>
         * 
         * @param inferenceSpecificationName
         *        The inference specification name in the model package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecificationName(String inferenceSpecificationName);

        /**
         * <p>
         * Defines the environment parameters that includes key, value types, and values.
         * </p>
         * 
         * @param environmentParameters
         *        Defines the environment parameters that includes key, value types, and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters);

        /**
         * <p>
         * Defines the environment parameters that includes key, value types, and values.
         * </p>
         * 
         * @param environmentParameters
         *        Defines the environment parameters that includes key, value types, and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentParameters(EnvironmentParameter... environmentParameters);

        /**
         * <p>
         * Defines the environment parameters that includes key, value types, and values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentParameters(List<EnvironmentParameter>)}.
         * 
         * @param environmentParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentParameters(java.util.Collection<EnvironmentParameter>)
         */
        Builder environmentParameters(Consumer<EnvironmentParameter.Builder>... environmentParameters);
    }

    static final class BuilderImpl implements Builder {
        private String inferenceSpecificationName;

        private List<EnvironmentParameter> environmentParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelConfiguration model) {
            inferenceSpecificationName(model.inferenceSpecificationName);
            environmentParameters(model.environmentParameters);
        }

        public final String getInferenceSpecificationName() {
            return inferenceSpecificationName;
        }

        public final void setInferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
        }

        @Override
        public final Builder inferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getEnvironmentParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersCopier.copyToBuilder(this.environmentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentParameters(Collection<EnvironmentParameter.BuilderImpl> environmentParameters) {
            this.environmentParameters = EnvironmentParametersCopier.copyFromBuilder(environmentParameters);
        }

        @Override
        public final Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters) {
            this.environmentParameters = EnvironmentParametersCopier.copy(environmentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(EnvironmentParameter... environmentParameters) {
            environmentParameters(Arrays.asList(environmentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(Consumer<EnvironmentParameter.Builder>... environmentParameters) {
            environmentParameters(Stream.of(environmentParameters)
                    .map(c -> EnvironmentParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModelConfiguration build() {
            return new ModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
