/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the configuration information for the text classification problem of an AutoML job V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextClassificationJobConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TextClassificationJobConfig.Builder, TextClassificationJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO).memberName("CompletionCriteria")
            .getter(getter(TextClassificationJobConfig::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final SdkField<String> CONTENT_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentColumn").getter(getter(TextClassificationJobConfig::contentColumn))
            .setter(setter(Builder::contentColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentColumn").build()).build();

    private static final SdkField<String> TARGET_LABEL_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLabelColumn").getter(getter(TextClassificationJobConfig::targetLabelColumn))
            .setter(setter(Builder::targetLabelColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLabelColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD,
            CONTENT_COLUMN_FIELD, TARGET_LABEL_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private final String contentColumn;

    private final String targetLabelColumn;

    private TextClassificationJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.contentColumn = builder.contentColumn;
        this.targetLabelColumn = builder.targetLabelColumn;
    }

    /**
     * <p>
     * How long a job is allowed to run, or how many candidates a job is allowed to generate.
     * </p>
     * 
     * @return How long a job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public final AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    /**
     * <p>
     * The name of the column used to provide the sentences to be classified. It should not be the same as the target
     * column (Required).
     * </p>
     * 
     * @return The name of the column used to provide the sentences to be classified. It should not be the same as the
     *         target column (Required).
     */
    public final String contentColumn() {
        return contentColumn;
    }

    /**
     * <p>
     * The name of the column used to provide the class labels. It should not be same as the content column (Required).
     * </p>
     * 
     * @return The name of the column used to provide the class labels. It should not be same as the content column
     *         (Required).
     */
    public final String targetLabelColumn() {
        return targetLabelColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(contentColumn());
        hashCode = 31 * hashCode + Objects.hashCode(targetLabelColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextClassificationJobConfig)) {
            return false;
        }
        TextClassificationJobConfig other = (TextClassificationJobConfig) obj;
        return Objects.equals(completionCriteria(), other.completionCriteria())
                && Objects.equals(contentColumn(), other.contentColumn())
                && Objects.equals(targetLabelColumn(), other.targetLabelColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextClassificationJobConfig").add("CompletionCriteria", completionCriteria())
                .add("ContentColumn", contentColumn()).add("TargetLabelColumn", targetLabelColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        case "ContentColumn":
            return Optional.ofNullable(clazz.cast(contentColumn()));
        case "TargetLabelColumn":
            return Optional.ofNullable(clazz.cast(targetLabelColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextClassificationJobConfig, T> g) {
        return obj -> g.apply((TextClassificationJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextClassificationJobConfig> {
        /**
         * <p>
         * How long a job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * 
         * @param completionCriteria
         *        How long a job is allowed to run, or how many candidates a job is allowed to generate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * <p>
         * How long a job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }

        /**
         * <p>
         * The name of the column used to provide the sentences to be classified. It should not be the same as the
         * target column (Required).
         * </p>
         * 
         * @param contentColumn
         *        The name of the column used to provide the sentences to be classified. It should not be the same as
         *        the target column (Required).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentColumn(String contentColumn);

        /**
         * <p>
         * The name of the column used to provide the class labels. It should not be same as the content column
         * (Required).
         * </p>
         * 
         * @param targetLabelColumn
         *        The name of the column used to provide the class labels. It should not be same as the content column
         *        (Required).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLabelColumn(String targetLabelColumn);
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;

        private String contentColumn;

        private String targetLabelColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(TextClassificationJobConfig model) {
            completionCriteria(model.completionCriteria);
            contentColumn(model.contentColumn);
            targetLabelColumn(model.targetLabelColumn);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getContentColumn() {
            return contentColumn;
        }

        public final void setContentColumn(String contentColumn) {
            this.contentColumn = contentColumn;
        }

        @Override
        public final Builder contentColumn(String contentColumn) {
            this.contentColumn = contentColumn;
            return this;
        }

        public final String getTargetLabelColumn() {
            return targetLabelColumn;
        }

        public final void setTargetLabelColumn(String targetLabelColumn) {
            this.targetLabelColumn = targetLabelColumn;
        }

        @Override
        public final Builder targetLabelColumn(String targetLabelColumn) {
            this.targetLabelColumn = targetLabelColumn;
            return this;
        }

        @Override
        public TextClassificationJobConfig build() {
            return new TextClassificationJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
