/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelCardExportJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelCardExportJobRequest.Builder, CreateModelCardExportJobRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(CreateModelCardExportJobRequest::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(CreateModelCardExportJobRequest::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobName").getter(getter(CreateModelCardExportJobRequest::modelCardExportJobName))
            .setter(setter(Builder::modelCardExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build())
            .build();

    private static final SdkField<ModelCardExportOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ModelCardExportOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateModelCardExportJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ModelCardExportOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD,
            MODEL_CARD_VERSION_FIELD, MODEL_CARD_EXPORT_JOB_NAME_FIELD, OUTPUT_CONFIG_FIELD));

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final String modelCardExportJobName;

    private final ModelCardExportOutputConfig outputConfig;

    private CreateModelCardExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.outputConfig = builder.outputConfig;
    }

    /**
     * <p>
     * The name of the model card to export.
     * </p>
     * 
     * @return The name of the model card to export.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The version of the model card to export. If a version is not provided, then the latest version of the model card
     * is exported.
     * </p>
     * 
     * @return The version of the model card to export. If a version is not provided, then the latest version of the
     *         model card is exported.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * The name of the model card export job.
     * </p>
     * 
     * @return The name of the model card export job.
     */
    public final String modelCardExportJobName() {
        return modelCardExportJobName;
    }

    /**
     * <p>
     * The model card output configuration that specifies the Amazon S3 path for exporting.
     * </p>
     * 
     * @return The model card output configuration that specifies the Amazon S3 path for exporting.
     */
    public final ModelCardExportOutputConfig outputConfig() {
        return outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCardExportJobRequest)) {
            return false;
        }
        CreateModelCardExportJobRequest other = (CreateModelCardExportJobRequest) obj;
        return Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion())
                && Objects.equals(modelCardExportJobName(), other.modelCardExportJobName())
                && Objects.equals(outputConfig(), other.outputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelCardExportJobRequest").add("ModelCardName", modelCardName())
                .add("ModelCardVersion", modelCardVersion()).add("ModelCardExportJobName", modelCardExportJobName())
                .add("OutputConfig", outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "ModelCardExportJobName":
            return Optional.ofNullable(clazz.cast(modelCardExportJobName()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCardExportJobRequest, T> g) {
        return obj -> g.apply((CreateModelCardExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelCardExportJobRequest> {
        /**
         * <p>
         * The name of the model card to export.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The version of the model card to export. If a version is not provided, then the latest version of the model
         * card is exported.
         * </p>
         * 
         * @param modelCardVersion
         *        The version of the model card to export. If a version is not provided, then the latest version of the
         *        model card is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * The name of the model card export job.
         * </p>
         * 
         * @param modelCardExportJobName
         *        The name of the model card export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobName(String modelCardExportJobName);

        /**
         * <p>
         * The model card output configuration that specifies the Amazon S3 path for exporting.
         * </p>
         * 
         * @param outputConfig
         *        The model card output configuration that specifies the Amazon S3 path for exporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ModelCardExportOutputConfig outputConfig);

        /**
         * <p>
         * The model card output configuration that specifies the Amazon S3 path for exporting.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardExportOutputConfig.Builder}
         * avoiding the need to create one manually via {@link ModelCardExportOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardExportOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ModelCardExportOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ModelCardExportOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ModelCardExportOutputConfig)
         */
        default Builder outputConfig(Consumer<ModelCardExportOutputConfig.Builder> outputConfig) {
            return outputConfig(ModelCardExportOutputConfig.builder().applyMutation(outputConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelCardName;

        private Integer modelCardVersion;

        private String modelCardExportJobName;

        private ModelCardExportOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCardExportJobRequest model) {
            super(model);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            modelCardExportJobName(model.modelCardExportJobName);
            outputConfig(model.outputConfig);
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final String getModelCardExportJobName() {
            return modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final ModelCardExportOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ModelCardExportOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ModelCardExportOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCardExportJobRequest build() {
            return new CreateModelCardExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
