/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RecommendationJobOutputConfig.getter(RecommendationJobOutputConfig::kmsKeyId)).setter(RecommendationJobOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<RecommendationJobCompiledOutputConfig> COMPILED_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompiledOutputConfig").getter(RecommendationJobOutputConfig.getter(RecommendationJobOutputConfig::compiledOutputConfig)).setter(RecommendationJobOutputConfig.setter(Builder::compiledOutputConfig)).constructor(RecommendationJobCompiledOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompiledOutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, COMPILED_OUTPUT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final RecommendationJobCompiledOutputConfig compiledOutputConfig;

    private RecommendationJobOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.compiledOutputConfig = builder.compiledOutputConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final RecommendationJobCompiledOutputConfig compiledOutputConfig() {
        return this.compiledOutputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.compiledOutputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobOutputConfig)) {
            return false;
        }
        RecommendationJobOutputConfig other = (RecommendationJobOutputConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.compiledOutputConfig(), other.compiledOutputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobOutputConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("CompiledOutputConfig", (Object)this.compiledOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CompiledOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.compiledOutputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobOutputConfig, T> g) {
        return obj -> g.apply((RecommendationJobOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private RecommendationJobCompiledOutputConfig compiledOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobOutputConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.compiledOutputConfig(model.compiledOutputConfig);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final RecommendationJobCompiledOutputConfig.Builder getCompiledOutputConfig() {
            return this.compiledOutputConfig != null ? this.compiledOutputConfig.toBuilder() : null;
        }

        public final void setCompiledOutputConfig(RecommendationJobCompiledOutputConfig.BuilderImpl compiledOutputConfig) {
            this.compiledOutputConfig = compiledOutputConfig != null ? compiledOutputConfig.build() : null;
        }

        @Override
        public final Builder compiledOutputConfig(RecommendationJobCompiledOutputConfig compiledOutputConfig) {
            this.compiledOutputConfig = compiledOutputConfig;
            return this;
        }

        public RecommendationJobOutputConfig build() {
            return new RecommendationJobOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobOutputConfig> {
        public Builder kmsKeyId(String var1);

        public Builder compiledOutputConfig(RecommendationJobCompiledOutputConfig var1);

        default public Builder compiledOutputConfig(Consumer<RecommendationJobCompiledOutputConfig.Builder> compiledOutputConfig) {
            return this.compiledOutputConfig((RecommendationJobCompiledOutputConfig)((RecommendationJobCompiledOutputConfig.Builder)RecommendationJobCompiledOutputConfig.builder().applyMutation(compiledOutputConfig)).build());
        }
    }
}

