/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpaceResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeSpaceResponse.Builder, DescribeSpaceResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DescribeSpaceResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> SPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceArn").getter(getter(DescribeSpaceResponse::spaceArn)).setter(setter(Builder::spaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceArn").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(DescribeSpaceResponse::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeEfsFileSystemUid").getter(getter(DescribeSpaceResponse::homeEfsFileSystemUid))
            .setter(setter(Builder::homeEfsFileSystemUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemUid").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeSpaceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeSpaceResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeSpaceResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeSpaceResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField
            .<SpaceSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceSettings")
            .getter(getter(DescribeSpaceResponse::spaceSettings)).setter(setter(Builder::spaceSettings))
            .constructor(SpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            SPACE_ARN_FIELD, SPACE_NAME_FIELD, HOME_EFS_FILE_SYSTEM_UID_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD,
            CREATION_TIME_FIELD, FAILURE_REASON_FIELD, SPACE_SETTINGS_FIELD));

    private final String domainId;

    private final String spaceArn;

    private final String spaceName;

    private final String homeEfsFileSystemUid;

    private final String status;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final String failureReason;

    private final SpaceSettings spaceSettings;

    private DescribeSpaceResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceArn = builder.spaceArn;
        this.spaceName = builder.spaceName;
        this.homeEfsFileSystemUid = builder.homeEfsFileSystemUid;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.spaceSettings = builder.spaceSettings;
    }

    /**
     * <p>
     * The ID of the associated Domain.
     * </p>
     * 
     * @return The ID of the associated Domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The space's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The space's Amazon Resource Name (ARN).
     */
    public final String spaceArn() {
        return spaceArn;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * The ID of the space's profile in the Amazon Elastic File System volume.
     * </p>
     * 
     * @return The ID of the space's profile in the Amazon Elastic File System volume.
     */
    public final String homeEfsFileSystemUid() {
        return homeEfsFileSystemUid;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SpaceStatus
     */
    public final SpaceStatus status() {
        return SpaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SpaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A collection of space settings.
     * </p>
     * 
     * @return A collection of space settings.
     */
    public final SpaceSettings spaceSettings() {
        return spaceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(spaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemUid());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(spaceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpaceResponse)) {
            return false;
        }
        DescribeSpaceResponse other = (DescribeSpaceResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(spaceArn(), other.spaceArn())
                && Objects.equals(spaceName(), other.spaceName())
                && Objects.equals(homeEfsFileSystemUid(), other.homeEfsFileSystemUid())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(spaceSettings(), other.spaceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSpaceResponse").add("DomainId", domainId()).add("SpaceArn", spaceArn())
                .add("SpaceName", spaceName()).add("HomeEfsFileSystemUid", homeEfsFileSystemUid())
                .add("Status", statusAsString()).add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("SpaceSettings", spaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "SpaceArn":
            return Optional.ofNullable(clazz.cast(spaceArn()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "HomeEfsFileSystemUid":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemUid()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "SpaceSettings":
            return Optional.ofNullable(clazz.cast(spaceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpaceResponse, T> g) {
        return obj -> g.apply((DescribeSpaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpaceResponse> {
        /**
         * <p>
         * The ID of the associated Domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the associated Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The space's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param spaceArn
         *        The space's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceArn(String spaceArn);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * The ID of the space's profile in the Amazon Elastic File System volume.
         * </p>
         * 
         * @param homeEfsFileSystemUid
         *        The ID of the space's profile in the Amazon Elastic File System volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemUid(String homeEfsFileSystemUid);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SpaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SpaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceStatus
         */
        Builder status(SpaceStatus status);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * 
         * @param spaceSettings
         *        A collection of space settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSettings(SpaceSettings spaceSettings);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSettings.Builder} avoiding the need
         * to create one manually via {@link SpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #spaceSettings(SpaceSettings)}.
         * 
         * @param spaceSettings
         *        a consumer that will call methods on {@link SpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSettings(SpaceSettings)
         */
        default Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return spaceSettings(SpaceSettings.builder().applyMutation(spaceSettings).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String domainId;

        private String spaceArn;

        private String spaceName;

        private String homeEfsFileSystemUid;

        private String status;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private String failureReason;

        private SpaceSettings spaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpaceResponse model) {
            super(model);
            domainId(model.domainId);
            spaceArn(model.spaceArn);
            spaceName(model.spaceName);
            homeEfsFileSystemUid(model.homeEfsFileSystemUid);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            spaceSettings(model.spaceSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceArn() {
            return spaceArn;
        }

        public final void setSpaceArn(String spaceArn) {
            this.spaceArn = spaceArn;
        }

        @Override
        public final Builder spaceArn(String spaceArn) {
            this.spaceArn = spaceArn;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getHomeEfsFileSystemUid() {
            return homeEfsFileSystemUid;
        }

        public final void setHomeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
        }

        @Override
        public final Builder homeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return spaceSettings != null ? spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        @Override
        public DescribeSpaceResponse build() {
            return new DescribeSpaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
