/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EndpointConfigSummaryListCopier {
    static List<EndpointConfigSummary> copy(Collection<? extends EndpointConfigSummary> endpointConfigSummaryListParam) {
        List<EndpointConfigSummary> list;
        if (endpointConfigSummaryListParam == null || endpointConfigSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointConfigSummary> modifiableList = new ArrayList<>();
            endpointConfigSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointConfigSummary> copyFromBuilder(
            Collection<? extends EndpointConfigSummary.Builder> endpointConfigSummaryListParam) {
        List<EndpointConfigSummary> list;
        if (endpointConfigSummaryListParam == null || endpointConfigSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointConfigSummary> modifiableList = new ArrayList<>();
            endpointConfigSummaryListParam.forEach(entry -> {
                EndpointConfigSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointConfigSummary.Builder> copyToBuilder(
            Collection<? extends EndpointConfigSummary> endpointConfigSummaryListParam) {
        List<EndpointConfigSummary.Builder> list;
        if (endpointConfigSummaryListParam == null || endpointConfigSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointConfigSummary.Builder> modifiableList = new ArrayList<>();
            endpointConfigSummaryListParam.forEach(entry -> {
                EndpointConfigSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
