/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output object for a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringOutput.Builder, MonitoringOutput> {
    private static final SdkField<MonitoringS3Output> S3_OUTPUT_FIELD = SdkField
            .<MonitoringS3Output> builder(MarshallingType.SDK_POJO).memberName("S3Output")
            .getter(getter(MonitoringOutput::s3Output)).setter(setter(Builder::s3Output))
            .constructor(MonitoringS3Output::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final MonitoringS3Output s3Output;

    private MonitoringOutput(BuilderImpl builder) {
        this.s3Output = builder.s3Output;
    }

    /**
     * <p>
     * The Amazon S3 storage location where the results of a monitoring job are saved.
     * </p>
     * 
     * @return The Amazon S3 storage location where the results of a monitoring job are saved.
     */
    public final MonitoringS3Output s3Output() {
        return s3Output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringOutput)) {
            return false;
        }
        MonitoringOutput other = (MonitoringOutput) obj;
        return Objects.equals(s3Output(), other.s3Output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringOutput").add("S3Output", s3Output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Output":
            return Optional.ofNullable(clazz.cast(s3Output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringOutput, T> g) {
        return obj -> g.apply((MonitoringOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringOutput> {
        /**
         * <p>
         * The Amazon S3 storage location where the results of a monitoring job are saved.
         * </p>
         * 
         * @param s3Output
         *        The Amazon S3 storage location where the results of a monitoring job are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Output(MonitoringS3Output s3Output);

        /**
         * <p>
         * The Amazon S3 storage location where the results of a monitoring job are saved.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringS3Output.Builder} avoiding the
         * need to create one manually via {@link MonitoringS3Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringS3Output.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Output(MonitoringS3Output)}.
         * 
         * @param s3Output
         *        a consumer that will call methods on {@link MonitoringS3Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Output(MonitoringS3Output)
         */
        default Builder s3Output(Consumer<MonitoringS3Output.Builder> s3Output) {
            return s3Output(MonitoringS3Output.builder().applyMutation(s3Output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MonitoringS3Output s3Output;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringOutput model) {
            s3Output(model.s3Output);
        }

        public final MonitoringS3Output.Builder getS3Output() {
            return s3Output != null ? s3Output.toBuilder() : null;
        }

        public final void setS3Output(MonitoringS3Output.BuilderImpl s3Output) {
            this.s3Output = s3Output != null ? s3Output.build() : null;
        }

        @Override
        public final Builder s3Output(MonitoringS3Output s3Output) {
            this.s3Output = s3Output;
            return this;
        }

        @Override
        public MonitoringOutput build() {
            return new MonitoringOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
