/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessingS3CompressionType {
    NONE("None"),
    GZIP("Gzip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessingS3CompressionType> VALUE_MAP;
    private final String value;

    private ProcessingS3CompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessingS3CompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessingS3CompressionType> knownValues() {
        EnumSet<ProcessingS3CompressionType> knownValues = EnumSet.allOf(ProcessingS3CompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessingS3CompressionType.class, ProcessingS3CompressionType::toString);
    }
}

