/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggregationTransformationValue {
    SUM("sum"),
    AVG("avg"),
    FIRST("first"),
    MIN("min"),
    MAX("max"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggregationTransformationValue> VALUE_MAP;
    private final String value;

    private AggregationTransformationValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregationTransformationValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregationTransformationValue> knownValues() {
        EnumSet<AggregationTransformationValue> knownValues = EnumSet.allOf(AggregationTransformationValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggregationTransformationValue.class, AggregationTransformationValue::toString);
    }
}

