/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following
 * APIs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateProcessingJob</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateTrainingJob</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateTransformJob</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentConfig.Builder, ExperimentConfig> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(ExperimentConfig::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(ExperimentConfig::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> TRIAL_COMPONENT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentDisplayName").getter(getter(ExperimentConfig::trialComponentDisplayName))
            .setter(setter(Builder::trialComponentDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentDisplayName").build())
            .build();

    private static final SdkField<String> RUN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunName").getter(getter(ExperimentConfig::runName)).setter(setter(Builder::runName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD,
            TRIAL_NAME_FIELD, TRIAL_COMPONENT_DISPLAY_NAME_FIELD, RUN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String experimentName;

    private final String trialName;

    private final String trialComponentDisplayName;

    private final String runName;

    private ExperimentConfig(BuilderImpl builder) {
        this.experimentName = builder.experimentName;
        this.trialName = builder.trialName;
        this.trialComponentDisplayName = builder.trialComponentDisplayName;
        this.runName = builder.runName;
    }

    /**
     * <p>
     * The name of an existing experiment to associate with the trial component.
     * </p>
     * 
     * @return The name of an existing experiment to associate with the trial component.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * The name of an existing trial to associate the trial component with. If not specified, a new trial is created.
     * </p>
     * 
     * @return The name of an existing trial to associate the trial component with. If not specified, a new trial is
     *         created.
     */
    public final String trialName() {
        return trialName;
    }

    /**
     * <p>
     * The display name for the trial component. If this key isn't specified, the display name is the trial component
     * name.
     * </p>
     * 
     * @return The display name for the trial component. If this key isn't specified, the display name is the trial
     *         component name.
     */
    public final String trialComponentDisplayName() {
        return trialComponentDisplayName;
    }

    /**
     * <p>
     * The name of the experiment run to associate with the trial component.
     * </p>
     * 
     * @return The name of the experiment run to associate with the trial component.
     */
    public final String runName() {
        return runName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(runName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentConfig)) {
            return false;
        }
        ExperimentConfig other = (ExperimentConfig) obj;
        return Objects.equals(experimentName(), other.experimentName()) && Objects.equals(trialName(), other.trialName())
                && Objects.equals(trialComponentDisplayName(), other.trialComponentDisplayName())
                && Objects.equals(runName(), other.runName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentConfig").add("ExperimentName", experimentName()).add("TrialName", trialName())
                .add("TrialComponentDisplayName", trialComponentDisplayName()).add("RunName", runName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "TrialComponentDisplayName":
            return Optional.ofNullable(clazz.cast(trialComponentDisplayName()));
        case "RunName":
            return Optional.ofNullable(clazz.cast(runName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentConfig, T> g) {
        return obj -> g.apply((ExperimentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentConfig> {
        /**
         * <p>
         * The name of an existing experiment to associate with the trial component.
         * </p>
         * 
         * @param experimentName
         *        The name of an existing experiment to associate with the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * The name of an existing trial to associate the trial component with. If not specified, a new trial is
         * created.
         * </p>
         * 
         * @param trialName
         *        The name of an existing trial to associate the trial component with. If not specified, a new trial is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * The display name for the trial component. If this key isn't specified, the display name is the trial
         * component name.
         * </p>
         * 
         * @param trialComponentDisplayName
         *        The display name for the trial component. If this key isn't specified, the display name is the trial
         *        component name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentDisplayName(String trialComponentDisplayName);

        /**
         * <p>
         * The name of the experiment run to associate with the trial component.
         * </p>
         * 
         * @param runName
         *        The name of the experiment run to associate with the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runName(String runName);
    }

    static final class BuilderImpl implements Builder {
        private String experimentName;

        private String trialName;

        private String trialComponentDisplayName;

        private String runName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentConfig model) {
            experimentName(model.experimentName);
            trialName(model.trialName);
            trialComponentDisplayName(model.trialComponentDisplayName);
            runName(model.runName);
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getTrialName() {
            return trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getTrialComponentDisplayName() {
            return trialComponentDisplayName;
        }

        public final void setTrialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
        }

        @Override
        public final Builder trialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
            return this;
        }

        public final String getRunName() {
            return runName;
        }

        public final void setRunName(String runName) {
            this.runName = runName;
        }

        @Override
        public final Builder runName(String runName) {
            this.runName = runName;
            return this;
        }

        @Override
        public ExperimentConfig build() {
            return new ExperimentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
