/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationEdgeType {
    CONTRIBUTED_TO("ContributedTo"),
    ASSOCIATED_WITH("AssociatedWith"),
    DERIVED_FROM("DerivedFrom"),
    PRODUCED("Produced"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationEdgeType> VALUE_MAP;
    private final String value;

    private AssociationEdgeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationEdgeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationEdgeType> knownValues() {
        EnumSet<AssociationEdgeType> knownValues = EnumSet.allOf(AssociationEdgeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationEdgeType.class, AssociationEdgeType::toString);
    }
}

