/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details about the monitoring schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfig implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleConfig.Builder, ScheduleConfig> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(ScheduleConfig::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> DATA_ANALYSIS_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAnalysisStartTime").getter(getter(ScheduleConfig::dataAnalysisStartTime))
            .setter(setter(Builder::dataAnalysisStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAnalysisStartTime").build())
            .build();

    private static final SdkField<String> DATA_ANALYSIS_END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAnalysisEndTime").getter(getter(ScheduleConfig::dataAnalysisEndTime))
            .setter(setter(Builder::dataAnalysisEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAnalysisEndTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            DATA_ANALYSIS_START_TIME_FIELD, DATA_ANALYSIS_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final String dataAnalysisStartTime;

    private final String dataAnalysisEndTime;

    private ScheduleConfig(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.dataAnalysisStartTime = builder.dataAnalysisStartTime;
        this.dataAnalysisEndTime = builder.dataAnalysisEndTime;
    }

    /**
     * <p>
     * A cron expression that describes details about the monitoring schedule.
     * </p>
     * <p>
     * The supported cron expressions are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want to set the job to start every hour, use the following:
     * </p>
     * <p>
     * <code>Hourly: cron(0 * ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to start the job daily:
     * </p>
     * <p>
     * <code>cron(0 [00-23] ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, the following are valid cron expressions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To support running every 6, 12 hours, the following are also supported:
     * </p>
     * <p>
     * <code>cron(0 [00-23]/[01-24] ? * * *)</code>
     * </p>
     * <p>
     * For example, the following are valid cron expressions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from
     * the actual requested time to run the execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker will
     * pick a time for running every day.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time, without
     * recurring.
     * </p>
     * 
     * @return A cron expression that describes details about the monitoring schedule.</p>
     *         <p>
     *         The supported cron expressions are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you want to set the job to start every hour, use the following:
     *         </p>
     *         <p>
     *         <code>Hourly: cron(0 * ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want to start the job daily:
     *         </p>
     *         <p>
     *         <code>cron(0 [00-23] ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, the following are valid cron expressions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To support running every 6, 12 hours, the following are also supported:
     *         </p>
     *         <p>
     *         <code>cron(0 [00-23]/[01-24] ? * * *)</code>
     *         </p>
     *         <p>
     *         For example, the following are valid cron expressions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <ul>
     *         <li>
     *         <p>
     *         Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20
     *         minutes from the actual requested time to run the execution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker
     *         will pick a time for running every day.
     *         </p>
     *         </li>
     *         </ul>
     *         </note>
     *         <p>
     *         You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time,
     *         without recurring.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Sets the start time for a monitoring job window. Express this time as an offset to the times that you schedule
     * your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter.
     * Specify this offset in ISO 8601 duration format. For example, if you want to monitor the five hours of data in
     * your dataset that precede the start of each monitoring job, you would specify: <code>"-PT5H"</code>.
     * </p>
     * <p>
     * The start time that you specify must not precede the end time that you specify by more than 24 hours. You specify
     * the end time with the <code>DataAnalysisEndTime</code> parameter.
     * </p>
     * <p>
     * If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
     * </p>
     * 
     * @return Sets the start time for a monitoring job window. Express this time as an offset to the times that you
     *         schedule your monitoring jobs to run. You schedule monitoring jobs with the
     *         <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example,
     *         if you want to monitor the five hours of data in your dataset that precede the start of each monitoring
     *         job, you would specify: <code>"-PT5H"</code>.</p>
     *         <p>
     *         The start time that you specify must not precede the end time that you specify by more than 24 hours. You
     *         specify the end time with the <code>DataAnalysisEndTime</code> parameter.
     *         </p>
     *         <p>
     *         If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
     */
    public final String dataAnalysisStartTime() {
        return dataAnalysisStartTime;
    }

    /**
     * <p>
     * Sets the end time for a monitoring job window. Express this time as an offset to the times that you schedule your
     * monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter. Specify
     * this offset in ISO 8601 duration format. For example, if you want to end the window one hour before the start of
     * each monitoring job, you would specify: <code>"-PT1H"</code>.
     * </p>
     * <p>
     * The end time that you specify must not follow the start time that you specify by more than 24 hours. You specify
     * the start time with the <code>DataAnalysisStartTime</code> parameter.
     * </p>
     * <p>
     * If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
     * </p>
     * 
     * @return Sets the end time for a monitoring job window. Express this time as an offset to the times that you
     *         schedule your monitoring jobs to run. You schedule monitoring jobs with the
     *         <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example,
     *         if you want to end the window one hour before the start of each monitoring job, you would specify:
     *         <code>"-PT1H"</code>.</p>
     *         <p>
     *         The end time that you specify must not follow the start time that you specify by more than 24 hours. You
     *         specify the start time with the <code>DataAnalysisStartTime</code> parameter.
     *         </p>
     *         <p>
     *         If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
     */
    public final String dataAnalysisEndTime() {
        return dataAnalysisEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(dataAnalysisStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataAnalysisEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfig)) {
            return false;
        }
        ScheduleConfig other = (ScheduleConfig) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(dataAnalysisStartTime(), other.dataAnalysisStartTime())
                && Objects.equals(dataAnalysisEndTime(), other.dataAnalysisEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfig").add("ScheduleExpression", scheduleExpression())
                .add("DataAnalysisStartTime", dataAnalysisStartTime()).add("DataAnalysisEndTime", dataAnalysisEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "DataAnalysisStartTime":
            return Optional.ofNullable(clazz.cast(dataAnalysisStartTime()));
        case "DataAnalysisEndTime":
            return Optional.ofNullable(clazz.cast(dataAnalysisEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfig, T> g) {
        return obj -> g.apply((ScheduleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfig> {
        /**
         * <p>
         * A cron expression that describes details about the monitoring schedule.
         * </p>
         * <p>
         * The supported cron expressions are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you want to set the job to start every hour, use the following:
         * </p>
         * <p>
         * <code>Hourly: cron(0 * ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want to start the job daily:
         * </p>
         * <p>
         * <code>cron(0 [00-23] ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, the following are valid cron expressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To support running every 6, 12 hours, the following are also supported:
         * </p>
         * <p>
         * <code>cron(0 [00-23]/[01-24] ? * * *)</code>
         * </p>
         * <p>
         * For example, the following are valid cron expressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <ul>
         * <li>
         * <p>
         * Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes
         * from the actual requested time to run the execution.
         * </p>
         * </li>
         * <li>
         * <p>
         * We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker
         * will pick a time for running every day.
         * </p>
         * </li>
         * </ul>
         * </note>
         * <p>
         * You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time, without
         * recurring.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression that describes details about the monitoring schedule.</p>
         *        <p>
         *        The supported cron expressions are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you want to set the job to start every hour, use the following:
         *        </p>
         *        <p>
         *        <code>Hourly: cron(0 * ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want to start the job daily:
         *        </p>
         *        <p>
         *        <code>cron(0 [00-23] ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, the following are valid cron expressions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To support running every 6, 12 hours, the following are also supported:
         *        </p>
         *        <p>
         *        <code>cron(0 [00-23]/[01-24] ? * * *)</code>
         *        </p>
         *        <p>
         *        For example, the following are valid cron expressions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <ul>
         *        <li>
         *        <p>
         *        Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20
         *        minutes from the actual requested time to run the execution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon
         *        SageMaker will pick a time for running every day.
         *        </p>
         *        </li>
         *        </ul>
         *        </note>
         *        <p>
         *        You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time,
         *        without recurring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Sets the start time for a monitoring job window. Express this time as an offset to the times that you
         * schedule your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code>
         * parameter. Specify this offset in ISO 8601 duration format. For example, if you want to monitor the five
         * hours of data in your dataset that precede the start of each monitoring job, you would specify:
         * <code>"-PT5H"</code>.
         * </p>
         * <p>
         * The start time that you specify must not precede the end time that you specify by more than 24 hours. You
         * specify the end time with the <code>DataAnalysisEndTime</code> parameter.
         * </p>
         * <p>
         * If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
         * </p>
         * 
         * @param dataAnalysisStartTime
         *        Sets the start time for a monitoring job window. Express this time as an offset to the times that you
         *        schedule your monitoring jobs to run. You schedule monitoring jobs with the
         *        <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For
         *        example, if you want to monitor the five hours of data in your dataset that precede the start of each
         *        monitoring job, you would specify: <code>"-PT5H"</code>.</p>
         *        <p>
         *        The start time that you specify must not precede the end time that you specify by more than 24 hours.
         *        You specify the end time with the <code>DataAnalysisEndTime</code> parameter.
         *        </p>
         *        <p>
         *        If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAnalysisStartTime(String dataAnalysisStartTime);

        /**
         * <p>
         * Sets the end time for a monitoring job window. Express this time as an offset to the times that you schedule
         * your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter.
         * Specify this offset in ISO 8601 duration format. For example, if you want to end the window one hour before
         * the start of each monitoring job, you would specify: <code>"-PT1H"</code>.
         * </p>
         * <p>
         * The end time that you specify must not follow the start time that you specify by more than 24 hours. You
         * specify the start time with the <code>DataAnalysisStartTime</code> parameter.
         * </p>
         * <p>
         * If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
         * </p>
         * 
         * @param dataAnalysisEndTime
         *        Sets the end time for a monitoring job window. Express this time as an offset to the times that you
         *        schedule your monitoring jobs to run. You schedule monitoring jobs with the
         *        <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For
         *        example, if you want to end the window one hour before the start of each monitoring job, you would
         *        specify: <code>"-PT1H"</code>.</p>
         *        <p>
         *        The end time that you specify must not follow the start time that you specify by more than 24 hours.
         *        You specify the start time with the <code>DataAnalysisStartTime</code> parameter.
         *        </p>
         *        <p>
         *        If you set <code>ScheduleExpression</code> to <code>NOW</code>, this parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAnalysisEndTime(String dataAnalysisEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private String dataAnalysisStartTime;

        private String dataAnalysisEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfig model) {
            scheduleExpression(model.scheduleExpression);
            dataAnalysisStartTime(model.dataAnalysisStartTime);
            dataAnalysisEndTime(model.dataAnalysisEndTime);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getDataAnalysisStartTime() {
            return dataAnalysisStartTime;
        }

        public final void setDataAnalysisStartTime(String dataAnalysisStartTime) {
            this.dataAnalysisStartTime = dataAnalysisStartTime;
        }

        @Override
        public final Builder dataAnalysisStartTime(String dataAnalysisStartTime) {
            this.dataAnalysisStartTime = dataAnalysisStartTime;
            return this;
        }

        public final String getDataAnalysisEndTime() {
            return dataAnalysisEndTime;
        }

        public final void setDataAnalysisEndTime(String dataAnalysisEndTime) {
            this.dataAnalysisEndTime = dataAnalysisEndTime;
        }

        @Override
        public final Builder dataAnalysisEndTime(String dataAnalysisEndTime) {
            this.dataAnalysisEndTime = dataAnalysisEndTime;
            return this;
        }

        @Override
        public ScheduleConfig build() {
            return new ScheduleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
