/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoMlJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateAutoMlJobRequest.Builder, CreateAutoMlJobRequest> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(CreateAutoMlJobRequest::autoMLJobName))
            .setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<List<AutoMLChannel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<AutoMLChannel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(CreateAutoMlJobRequest::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<AutoMLOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(CreateAutoMlJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(AutoMLOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProblemType").getter(getter(CreateAutoMlJobRequest::problemTypeAsString))
            .setter(setter(Builder::problemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()).build();

    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobObjective")
            .getter(getter(CreateAutoMlJobRequest::autoMLJobObjective)).setter(setter(Builder::autoMLJobObjective))
            .constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<AutoMLJobConfig> AUTO_ML_JOB_CONFIG_FIELD = SdkField
            .<AutoMLJobConfig> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobConfig")
            .getter(getter(CreateAutoMlJobRequest::autoMLJobConfig)).setter(setter(Builder::autoMLJobConfig))
            .constructor(AutoMLJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateAutoMlJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Boolean> GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GenerateCandidateDefinitionsOnly")
            .getter(getter(CreateAutoMlJobRequest::generateCandidateDefinitionsOnly))
            .setter(setter(Builder::generateCandidateDefinitionsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateCandidateDefinitionsOnly")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoMlJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ModelDeployConfig> MODEL_DEPLOY_CONFIG_FIELD = SdkField
            .<ModelDeployConfig> builder(MarshallingType.SDK_POJO).memberName("ModelDeployConfig")
            .getter(getter(CreateAutoMlJobRequest::modelDeployConfig)).setter(setter(Builder::modelDeployConfig))
            .constructor(ModelDeployConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, PROBLEM_TYPE_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD,
            AUTO_ML_JOB_CONFIG_FIELD, ROLE_ARN_FIELD, GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD, TAGS_FIELD,
            MODEL_DEPLOY_CONFIG_FIELD));

    private final String autoMLJobName;

    private final List<AutoMLChannel> inputDataConfig;

    private final AutoMLOutputDataConfig outputDataConfig;

    private final String problemType;

    private final AutoMLJobObjective autoMLJobObjective;

    private final AutoMLJobConfig autoMLJobConfig;

    private final String roleArn;

    private final Boolean generateCandidateDefinitionsOnly;

    private final List<Tag> tags;

    private final ModelDeployConfig modelDeployConfig;

    private CreateAutoMlJobRequest(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.problemType = builder.problemType;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.autoMLJobConfig = builder.autoMLJobConfig;
        this.roleArn = builder.roleArn;
        this.generateCandidateDefinitionsOnly = builder.generateCandidateDefinitionsOnly;
        this.tags = builder.tags;
        this.modelDeployConfig = builder.modelDeployConfig;
    }

    /**
     * <p>
     * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     * </p>
     * 
     * @return Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDataConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of channel objects that describes the input data and its location. Each channel is a named input source.
     * Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV, Parquet. A minimum of 500 rows
     * is required for the training dataset. There is not a minimum number of rows required for the validation dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDataConfig} method.
     * </p>
     * 
     * @return An array of channel objects that describes the input data and its location. Each channel is a named input
     *         source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV, Parquet. A
     *         minimum of 500 rows is required for the training dataset. There is not a minimum number of rows required
     *         for the validation dataset.
     */
    public final List<AutoMLChannel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job.
     * Format(s) supported: CSV.
     * </p>
     * 
     * @return Provides information about encryption and the Amazon S3 output path needed to store artifacts from an
     *         AutoML job. Format(s) supported: CSV.
     */
    public final AutoMLOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * Defines the type of supervised learning problem available for the candidates. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
     * Amazon SageMaker Autopilot problem types and algorithm support</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return Defines the type of supervised learning problem available for the candidates. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"
     *         > Amazon SageMaker Autopilot problem types and algorithm support</a>.
     * @see ProblemType
     */
    public final ProblemType problemType() {
        return ProblemType.fromValue(problemType);
    }

    /**
     * <p>
     * Defines the type of supervised learning problem available for the candidates. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
     * Amazon SageMaker Autopilot problem types and algorithm support</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return Defines the type of supervised learning problem available for the candidates. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"
     *         > Amazon SageMaker Autopilot problem types and algorithm support</a>.
     * @see ProblemType
     */
    public final String problemTypeAsString() {
        return problemType;
    }

    /**
     * <p>
     * Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an
     * <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it. For , only
     * <code>Accuracy</code> is supported.
     * </p>
     * 
     * @return Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an
     *         <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it. For , only
     *         <code>Accuracy</code> is supported.
     */
    public final AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * <p>
     * A collection of settings used to configure an AutoML job.
     * </p>
     * 
     * @return A collection of settings used to configure an AutoML job.
     */
    public final AutoMLJobConfig autoMLJobConfig() {
        return autoMLJobConfig;
    }

    /**
     * <p>
     * The ARN of the role that is used to access the data.
     * </p>
     * 
     * @return The ARN of the role that is used to access the data.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Generates possible candidates without training the models. A candidate is a combination of data preprocessors,
     * algorithms, and algorithm parameter settings.
     * </p>
     * 
     * @return Generates possible candidates without training the models. A candidate is a combination of data
     *         preprocessors, algorithms, and algorithm parameter settings.
     */
    public final Boolean generateCandidateDefinitionsOnly() {
        return generateCandidateDefinitionsOnly;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web ServicesResources</a>.
     * Tag keys must be unique per resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     *         ServicesResources</a>. Tag keys must be unique per resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     * </p>
     * 
     * @return Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     */
    public final ModelDeployConfig modelDeployConfig() {
        return modelDeployConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(generateCandidateDefinitionsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelDeployConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoMlJobRequest)) {
            return false;
        }
        CreateAutoMlJobRequest other = (CreateAutoMlJobRequest) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName()) && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(problemTypeAsString(), other.problemTypeAsString())
                && Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(autoMLJobConfig(), other.autoMLJobConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(generateCandidateDefinitionsOnly(), other.generateCandidateDefinitionsOnly())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(modelDeployConfig(), other.modelDeployConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutoMlJobRequest").add("AutoMLJobName", autoMLJobName())
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("ProblemType", problemTypeAsString())
                .add("AutoMLJobObjective", autoMLJobObjective()).add("AutoMLJobConfig", autoMLJobConfig())
                .add("RoleArn", roleArn()).add("GenerateCandidateDefinitionsOnly", generateCandidateDefinitionsOnly())
                .add("Tags", hasTags() ? tags() : null).add("ModelDeployConfig", modelDeployConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ProblemType":
            return Optional.ofNullable(clazz.cast(problemTypeAsString()));
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "AutoMLJobConfig":
            return Optional.ofNullable(clazz.cast(autoMLJobConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "GenerateCandidateDefinitionsOnly":
            return Optional.ofNullable(clazz.cast(generateCandidateDefinitionsOnly()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ModelDeployConfig":
            return Optional.ofNullable(clazz.cast(modelDeployConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoMlJobRequest, T> g) {
        return obj -> g.apply((CreateAutoMlJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoMlJobRequest> {
        /**
         * <p>
         * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         * </p>
         * 
         * @param autoMLJobName
         *        Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * An array of channel objects that describes the input data and its location. Each channel is a named input
         * source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV, Parquet. A minimum
         * of 500 rows is required for the training dataset. There is not a minimum number of rows required for the
         * validation dataset.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of channel objects that describes the input data and its location. Each channel is a named
         *        input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV,
         *        Parquet. A minimum of 500 rows is required for the training dataset. There is not a minimum number of
         *        rows required for the validation dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig);

        /**
         * <p>
         * An array of channel objects that describes the input data and its location. Each channel is a named input
         * source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV, Parquet. A minimum
         * of 500 rows is required for the training dataset. There is not a minimum number of rows required for the
         * validation dataset.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of channel objects that describes the input data and its location. Each channel is a named
         *        input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV,
         *        Parquet. A minimum of 500 rows is required for the training dataset. There is not a minimum number of
         *        rows required for the validation dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(AutoMLChannel... inputDataConfig);

        /**
         * <p>
         * An array of channel objects that describes the input data and its location. Each channel is a named input
         * source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV, Parquet. A minimum
         * of 500 rows is required for the training dataset. There is not a minimum number of rows required for the
         * validation dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLChannel.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.AutoMLChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLChannel.Builder#build()} is called immediately
         * and its result is passed to {@link #inputDataConfig(List<AutoMLChannel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(java.util.Collection<AutoMLChannel>)
         */
        Builder inputDataConfig(Consumer<AutoMLChannel.Builder>... inputDataConfig);

        /**
         * <p>
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML
         * job. Format(s) supported: CSV.
         * </p>
         * 
         * @param outputDataConfig
         *        Provides information about encryption and the Amazon S3 output path needed to store artifacts from an
         *        AutoML job. Format(s) supported: CSV.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML
         * job. Format(s) supported: CSV.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLOutputDataConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(AutoMLOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link AutoMLOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(AutoMLOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * Defines the type of supervised learning problem available for the candidates. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
         * Amazon SageMaker Autopilot problem types and algorithm support</a>.
         * </p>
         * 
         * @param problemType
         *        Defines the type of supervised learning problem available for the candidates. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"
         *        > Amazon SageMaker Autopilot problem types and algorithm support</a>.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(String problemType);

        /**
         * <p>
         * Defines the type of supervised learning problem available for the candidates. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
         * Amazon SageMaker Autopilot problem types and algorithm support</a>.
         * </p>
         * 
         * @param problemType
         *        Defines the type of supervised learning problem available for the candidates. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"
         *        > Amazon SageMaker Autopilot problem types and algorithm support</a>.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(ProblemType problemType);

        /**
         * <p>
         * Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an
         * <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it. For , only
         * <code>Accuracy</code> is supported.
         * </p>
         * 
         * @param autoMLJobObjective
         *        Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an
         *        <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it. For ,
         *        only <code>Accuracy</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * <p>
         * Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an
         * <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it. For , only
         * <code>Accuracy</code> is supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobObjective.Builder} avoiding the
         * need to create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * <p>
         * A collection of settings used to configure an AutoML job.
         * </p>
         * 
         * @param autoMLJobConfig
         *        A collection of settings used to configure an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig);

        /**
         * <p>
         * A collection of settings used to configure an AutoML job.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobConfig.Builder} avoiding the
         * need to create one manually via {@link AutoMLJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobConfig(AutoMLJobConfig)}.
         * 
         * @param autoMLJobConfig
         *        a consumer that will call methods on {@link AutoMLJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobConfig(AutoMLJobConfig)
         */
        default Builder autoMLJobConfig(Consumer<AutoMLJobConfig.Builder> autoMLJobConfig) {
            return autoMLJobConfig(AutoMLJobConfig.builder().applyMutation(autoMLJobConfig).build());
        }

        /**
         * <p>
         * The ARN of the role that is used to access the data.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that is used to access the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Generates possible candidates without training the models. A candidate is a combination of data
         * preprocessors, algorithms, and algorithm parameter settings.
         * </p>
         * 
         * @param generateCandidateDefinitionsOnly
         *        Generates possible candidates without training the models. A candidate is a combination of data
         *        preprocessors, algorithms, and algorithm parameter settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         *        ServicesResources</a>. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         *        ServicesResources</a>. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * </p>
         * 
         * @param modelDeployConfig
         *        Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDeployConfig(ModelDeployConfig modelDeployConfig);

        /**
         * <p>
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDeployConfig.Builder} avoiding the
         * need to create one manually via {@link ModelDeployConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDeployConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDeployConfig(ModelDeployConfig)}.
         * 
         * @param modelDeployConfig
         *        a consumer that will call methods on {@link ModelDeployConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDeployConfig(ModelDeployConfig)
         */
        default Builder modelDeployConfig(Consumer<ModelDeployConfig.Builder> modelDeployConfig) {
            return modelDeployConfig(ModelDeployConfig.builder().applyMutation(modelDeployConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String autoMLJobName;

        private List<AutoMLChannel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private AutoMLOutputDataConfig outputDataConfig;

        private String problemType;

        private AutoMLJobObjective autoMLJobObjective;

        private AutoMLJobConfig autoMLJobConfig;

        private String roleArn;

        private Boolean generateCandidateDefinitionsOnly;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ModelDeployConfig modelDeployConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoMlJobRequest model) {
            super(model);
            autoMLJobName(model.autoMLJobName);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            problemType(model.problemType);
            autoMLJobObjective(model.autoMLJobObjective);
            autoMLJobConfig(model.autoMLJobConfig);
            roleArn(model.roleArn);
            generateCandidateDefinitionsOnly(model.generateCandidateDefinitionsOnly);
            tags(model.tags);
            modelDeployConfig(model.modelDeployConfig);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final List<AutoMLChannel.Builder> getInputDataConfig() {
            List<AutoMLChannel.Builder> result = AutoMLInputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<AutoMLChannel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(AutoMLChannel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<AutoMLChannel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> AutoMLChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getProblemType() {
            return problemType;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final AutoMLJobConfig.Builder getAutoMLJobConfig() {
            return autoMLJobConfig != null ? autoMLJobConfig.toBuilder() : null;
        }

        public final void setAutoMLJobConfig(AutoMLJobConfig.BuilderImpl autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig != null ? autoMLJobConfig.build() : null;
        }

        @Override
        public final Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getGenerateCandidateDefinitionsOnly() {
            return generateCandidateDefinitionsOnly;
        }

        public final void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
        }

        @Override
        public final Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ModelDeployConfig.Builder getModelDeployConfig() {
            return modelDeployConfig != null ? modelDeployConfig.toBuilder() : null;
        }

        public final void setModelDeployConfig(ModelDeployConfig.BuilderImpl modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig != null ? modelDeployConfig.build() : null;
        }

        @Override
        public final Builder modelDeployConfig(ModelDeployConfig modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoMlJobRequest build() {
            return new CreateAutoMlJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
