/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStepsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceRecommendationsJobStepsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListInferenceRecommendationsJobStepsResponse> {
    private static final SdkField<List<InferenceRecommendationsJobStep>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(ListInferenceRecommendationsJobStepsResponse.getter(ListInferenceRecommendationsJobStepsResponse::steps)).setter(ListInferenceRecommendationsJobStepsResponse.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceRecommendationsJobStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceRecommendationsJobStepsResponse.getter(ListInferenceRecommendationsJobStepsResponse::nextToken)).setter(ListInferenceRecommendationsJobStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InferenceRecommendationsJobStep> steps;
    private final String nextToken;

    private ListInferenceRecommendationsJobStepsResponse(BuilderImpl builder) {
        super(builder);
        this.steps = builder.steps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<InferenceRecommendationsJobStep> steps() {
        return this.steps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceRecommendationsJobStepsResponse)) {
            return false;
        }
        ListInferenceRecommendationsJobStepsResponse other = (ListInferenceRecommendationsJobStepsResponse)((Object)obj);
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceRecommendationsJobStepsResponse").add("Steps", this.hasSteps() ? this.steps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceRecommendationsJobStepsResponse, T> g) {
        return obj -> g.apply((ListInferenceRecommendationsJobStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<InferenceRecommendationsJobStep> steps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceRecommendationsJobStepsResponse model) {
            super(model);
            this.steps(model.steps);
            this.nextToken(model.nextToken);
        }

        public final List<InferenceRecommendationsJobStep.Builder> getSteps() {
            List<InferenceRecommendationsJobStep.Builder> result = InferenceRecommendationsJobStepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<InferenceRecommendationsJobStep.BuilderImpl> steps) {
            this.steps = InferenceRecommendationsJobStepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<InferenceRecommendationsJobStep> steps) {
            this.steps = InferenceRecommendationsJobStepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(InferenceRecommendationsJobStep ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<InferenceRecommendationsJobStep.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (InferenceRecommendationsJobStep)((InferenceRecommendationsJobStep.Builder)InferenceRecommendationsJobStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceRecommendationsJobStepsResponse build() {
            return new ListInferenceRecommendationsJobStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceRecommendationsJobStepsResponse> {
        public Builder steps(Collection<InferenceRecommendationsJobStep> var1);

        public Builder steps(InferenceRecommendationsJobStep ... var1);

        public Builder steps(Consumer<InferenceRecommendationsJobStep.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

