/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for notifications of inference results for asynchronous inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInferenceNotificationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInferenceNotificationConfig.Builder, AsyncInferenceNotificationConfig> {
    private static final SdkField<String> SUCCESS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuccessTopic").getter(getter(AsyncInferenceNotificationConfig::successTopic))
            .setter(setter(Builder::successTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessTopic").build()).build();

    private static final SdkField<String> ERROR_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorTopic").getter(getter(AsyncInferenceNotificationConfig::errorTopic))
            .setter(setter(Builder::errorTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorTopic").build()).build();

    private static final SdkField<List<String>> INCLUDE_INFERENCE_RESPONSE_IN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeInferenceResponseIn")
            .getter(getter(AsyncInferenceNotificationConfig::includeInferenceResponseInAsStrings))
            .setter(setter(Builder::includeInferenceResponseInWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeInferenceResponseIn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_TOPIC_FIELD,
            ERROR_TOPIC_FIELD, INCLUDE_INFERENCE_RESPONSE_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String successTopic;

    private final String errorTopic;

    private final List<String> includeInferenceResponseIn;

    private AsyncInferenceNotificationConfig(BuilderImpl builder) {
        this.successTopic = builder.successTopic;
        this.errorTopic = builder.errorTopic;
        this.includeInferenceResponseIn = builder.includeInferenceResponseIn;
    }

    /**
     * <p>
     * Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no
     * notification is sent on success.
     * </p>
     * 
     * @return Amazon SNS topic to post a notification to when inference completes successfully. If no topic is
     *         provided, no notification is sent on success.
     */
    public final String successTopic() {
        return successTopic;
    }

    /**
     * <p>
     * Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent
     * on failure.
     * </p>
     * 
     * @return Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification
     *         is sent on failure.
     */
    public final String errorTopic() {
        return errorTopic;
    }

    /**
     * <p>
     * The Amazon SNS topics where you want the inference response to be included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeInferenceResponseIn} method.
     * </p>
     * 
     * @return The Amazon SNS topics where you want the inference response to be included.
     */
    public final List<AsyncNotificationTopicTypes> includeInferenceResponseIn() {
        return AsyncNotificationTopicTypeListCopier.copyStringToEnum(includeInferenceResponseIn);
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeInferenceResponseIn property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIncludeInferenceResponseIn() {
        return includeInferenceResponseIn != null && !(includeInferenceResponseIn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SNS topics where you want the inference response to be included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeInferenceResponseIn} method.
     * </p>
     * 
     * @return The Amazon SNS topics where you want the inference response to be included.
     */
    public final List<String> includeInferenceResponseInAsStrings() {
        return includeInferenceResponseIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successTopic());
        hashCode = 31 * hashCode + Objects.hashCode(errorTopic());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIncludeInferenceResponseIn() ? includeInferenceResponseInAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceNotificationConfig)) {
            return false;
        }
        AsyncInferenceNotificationConfig other = (AsyncInferenceNotificationConfig) obj;
        return Objects.equals(successTopic(), other.successTopic()) && Objects.equals(errorTopic(), other.errorTopic())
                && hasIncludeInferenceResponseIn() == other.hasIncludeInferenceResponseIn()
                && Objects.equals(includeInferenceResponseInAsStrings(), other.includeInferenceResponseInAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AsyncInferenceNotificationConfig")
                .add("SuccessTopic", successTopic())
                .add("ErrorTopic", errorTopic())
                .add("IncludeInferenceResponseIn", hasIncludeInferenceResponseIn() ? includeInferenceResponseInAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessTopic":
            return Optional.ofNullable(clazz.cast(successTopic()));
        case "ErrorTopic":
            return Optional.ofNullable(clazz.cast(errorTopic()));
        case "IncludeInferenceResponseIn":
            return Optional.ofNullable(clazz.cast(includeInferenceResponseInAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceNotificationConfig, T> g) {
        return obj -> g.apply((AsyncInferenceNotificationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInferenceNotificationConfig> {
        /**
         * <p>
         * Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no
         * notification is sent on success.
         * </p>
         * 
         * @param successTopic
         *        Amazon SNS topic to post a notification to when inference completes successfully. If no topic is
         *        provided, no notification is sent on success.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successTopic(String successTopic);

        /**
         * <p>
         * Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is
         * sent on failure.
         * </p>
         * 
         * @param errorTopic
         *        Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no
         *        notification is sent on failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorTopic(String errorTopic);

        /**
         * <p>
         * The Amazon SNS topics where you want the inference response to be included.
         * </p>
         * 
         * @param includeInferenceResponseIn
         *        The Amazon SNS topics where you want the inference response to be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInferenceResponseInWithStrings(Collection<String> includeInferenceResponseIn);

        /**
         * <p>
         * The Amazon SNS topics where you want the inference response to be included.
         * </p>
         * 
         * @param includeInferenceResponseIn
         *        The Amazon SNS topics where you want the inference response to be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInferenceResponseInWithStrings(String... includeInferenceResponseIn);

        /**
         * <p>
         * The Amazon SNS topics where you want the inference response to be included.
         * </p>
         * 
         * @param includeInferenceResponseIn
         *        The Amazon SNS topics where you want the inference response to be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInferenceResponseIn(Collection<AsyncNotificationTopicTypes> includeInferenceResponseIn);

        /**
         * <p>
         * The Amazon SNS topics where you want the inference response to be included.
         * </p>
         * 
         * @param includeInferenceResponseIn
         *        The Amazon SNS topics where you want the inference response to be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInferenceResponseIn(AsyncNotificationTopicTypes... includeInferenceResponseIn);
    }

    static final class BuilderImpl implements Builder {
        private String successTopic;

        private String errorTopic;

        private List<String> includeInferenceResponseIn = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceNotificationConfig model) {
            successTopic(model.successTopic);
            errorTopic(model.errorTopic);
            includeInferenceResponseInWithStrings(model.includeInferenceResponseIn);
        }

        public final String getSuccessTopic() {
            return successTopic;
        }

        public final void setSuccessTopic(String successTopic) {
            this.successTopic = successTopic;
        }

        @Override
        public final Builder successTopic(String successTopic) {
            this.successTopic = successTopic;
            return this;
        }

        public final String getErrorTopic() {
            return errorTopic;
        }

        public final void setErrorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
        }

        @Override
        public final Builder errorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
            return this;
        }

        public final Collection<String> getIncludeInferenceResponseIn() {
            if (includeInferenceResponseIn instanceof SdkAutoConstructList) {
                return null;
            }
            return includeInferenceResponseIn;
        }

        public final void setIncludeInferenceResponseIn(Collection<String> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copy(includeInferenceResponseIn);
        }

        @Override
        public final Builder includeInferenceResponseInWithStrings(Collection<String> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copy(includeInferenceResponseIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeInferenceResponseInWithStrings(String... includeInferenceResponseIn) {
            includeInferenceResponseInWithStrings(Arrays.asList(includeInferenceResponseIn));
            return this;
        }

        @Override
        public final Builder includeInferenceResponseIn(Collection<AsyncNotificationTopicTypes> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copyEnumToString(includeInferenceResponseIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeInferenceResponseIn(AsyncNotificationTopicTypes... includeInferenceResponseIn) {
            includeInferenceResponseIn(Arrays.asList(includeInferenceResponseIn));
            return this;
        }

        @Override
        public AsyncInferenceNotificationConfig build() {
            return new AsyncInferenceNotificationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
