/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a trial component as returned by the <a>Search</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponent implements SdkPojo, Serializable, ToCopyableBuilder<TrialComponent.Builder, TrialComponent> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(TrialComponent::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(TrialComponent::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentArn").getter(getter(TrialComponent::trialComponentArn))
            .setter(setter(Builder::trialComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()).build();

    private static final SdkField<TrialComponentSource> SOURCE_FIELD = SdkField
            .<TrialComponentSource> builder(MarshallingType.SDK_POJO).memberName("Source").getter(getter(TrialComponent::source))
            .setter(setter(Builder::source)).constructor(TrialComponentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).memberName("Status").getter(getter(TrialComponent::status))
            .setter(setter(Builder::status)).constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(TrialComponent::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(TrialComponent::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TrialComponent::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(TrialComponent::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TrialComponent::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(TrialComponent::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TrialComponentParameterValue>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(TrialComponent::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("InputArtifacts")
            .getter(getter(TrialComponent::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("OutputArtifacts")
            .getter(getter(TrialComponent::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<TrialComponentMetricSummary>> METRICS_FIELD = SdkField
            .<List<TrialComponentMetricSummary>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(TrialComponent::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialComponentMetricSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentMetricSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(TrialComponent::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<TrialComponentSourceDetail> SOURCE_DETAIL_FIELD = SdkField
            .<TrialComponentSourceDetail> builder(MarshallingType.SDK_POJO).memberName("SourceDetail")
            .getter(getter(TrialComponent::sourceDetail)).setter(setter(Builder::sourceDetail))
            .constructor(TrialComponentSourceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetail").build()).build();

    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageGroupArn").getter(getter(TrialComponent::lineageGroupArn))
            .setter(setter(Builder::lineageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TrialComponent::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Parent>> PARENTS_FIELD = SdkField
            .<List<Parent>> builder(MarshallingType.LIST)
            .memberName("Parents")
            .getter(getter(TrialComponent::parents))
            .setter(setter(Builder::parents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parent> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RUN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunName").getter(getter(TrialComponent::runName)).setter(setter(Builder::runName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            DISPLAY_NAME_FIELD, TRIAL_COMPONENT_ARN_FIELD, SOURCE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, PARAMETERS_FIELD,
            INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, METRICS_FIELD, METADATA_PROPERTIES_FIELD, SOURCE_DETAIL_FIELD,
            LINEAGE_GROUP_ARN_FIELD, TAGS_FIELD, PARENTS_FIELD, RUN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialComponentName;

    private final String displayName;

    private final String trialComponentArn;

    private final TrialComponentSource source;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final Map<String, TrialComponentParameterValue> parameters;

    private final Map<String, TrialComponentArtifact> inputArtifacts;

    private final Map<String, TrialComponentArtifact> outputArtifacts;

    private final List<TrialComponentMetricSummary> metrics;

    private final MetadataProperties metadataProperties;

    private final TrialComponentSourceDetail sourceDetail;

    private final String lineageGroupArn;

    private final List<Tag> tags;

    private final List<Parent> parents;

    private final String runName;

    private TrialComponent(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.trialComponentArn = builder.trialComponentArn;
        this.source = builder.source;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metrics = builder.metrics;
        this.metadataProperties = builder.metadataProperties;
        this.sourceDetail = builder.sourceDetail;
        this.lineageGroupArn = builder.lineageGroupArn;
        this.tags = builder.tags;
        this.parents = builder.parents;
        this.runName = builder.runName;
    }

    /**
     * <p>
     * The name of the trial component.
     * </p>
     * 
     * @return The name of the trial component.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     * <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     *         <code>TrialComponentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial component.
     */
    public final String trialComponentArn() {
        return trialComponentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and job type of the source of the component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) and job type of the source of the component.
     */
    public final TrialComponentSource source() {
        return source;
    }

    /**
     * Returns the value of the Status property for this object.
     * 
     * @return The value of the Status property for this object.
     */
    public final TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * When the component was created.
     * </p>
     * 
     * @return When the component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Who created the trial component.
     * </p>
     * 
     * @return Who created the trial component.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the component was last modified.
     * </p>
     * 
     * @return When the component was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The hyperparameters of the component.
     */
    public final Map<String, TrialComponentParameterValue> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input artifacts of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifacts} method.
     * </p>
     * 
     * @return The input artifacts of the component.
     */
    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The output artifacts of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifacts} method.
     * </p>
     * 
     * @return The output artifacts of the component.
     */
    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics for the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics for the component.
     */
    public final List<TrialComponentMetricSummary> metrics() {
        return metrics;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * <p>
     * Details of the source of the component.
     * </p>
     * 
     * @return Details of the source of the component.
     */
    public final TrialComponentSourceDetail sourceDetail() {
        return sourceDetail;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lineage group resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lineage group resource.
     */
    public final String lineageGroupArn() {
        return lineageGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags that are associated with the component. You can use <a>Search</a> API to search on the
     *         tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParents() {
        return parents != null && !(parents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the parents of the component. A parent is a trial the component is associated with and the experiment
     * the trial is part of. A component might not have any parents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParents} method.
     * </p>
     * 
     * @return An array of the parents of the component. A parent is a trial the component is associated with and the
     *         experiment the trial is part of. A component might not have any parents.
     */
    public final List<Parent> parents() {
        return parents;
    }

    /**
     * <p>
     * The name of the experiment run.
     * </p>
     * 
     * @return The name of the experiment run.
     */
    public final String runName() {
        return runName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDetail());
        hashCode = 31 * hashCode + Objects.hashCode(lineageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParents() ? parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(runName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponent)) {
            return false;
        }
        TrialComponent other = (TrialComponent) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(trialComponentArn(), other.trialComponentArn()) && Objects.equals(source(), other.source())
                && Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && hasInputArtifacts() == other.hasInputArtifacts()
                && Objects.equals(inputArtifacts(), other.inputArtifacts()) && hasOutputArtifacts() == other.hasOutputArtifacts()
                && Objects.equals(outputArtifacts(), other.outputArtifacts()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(metadataProperties(), other.metadataProperties())
                && Objects.equals(sourceDetail(), other.sourceDetail())
                && Objects.equals(lineageGroupArn(), other.lineageGroupArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasParents() == other.hasParents()
                && Objects.equals(parents(), other.parents()) && Objects.equals(runName(), other.runName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponent").add("TrialComponentName", trialComponentName())
                .add("DisplayName", displayName()).add("TrialComponentArn", trialComponentArn()).add("Source", source())
                .add("Status", status()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("Parameters", hasParameters() ? parameters() : null)
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null)
                .add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("Metrics", hasMetrics() ? metrics() : null).add("MetadataProperties", metadataProperties())
                .add("SourceDetail", sourceDetail()).add("LineageGroupArn", lineageGroupArn())
                .add("Tags", hasTags() ? tags() : null).add("Parents", hasParents() ? parents() : null).add("RunName", runName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "TrialComponentArn":
            return Optional.ofNullable(clazz.cast(trialComponentArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "InputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "OutputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "SourceDetail":
            return Optional.ofNullable(clazz.cast(sourceDetail()));
        case "LineageGroupArn":
            return Optional.ofNullable(clazz.cast(lineageGroupArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Parents":
            return Optional.ofNullable(clazz.cast(parents()));
        case "RunName":
            return Optional.ofNullable(clazz.cast(runName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponent, T> g) {
        return obj -> g.apply((TrialComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponent> {
        /**
         * <p>
         * The name of the trial component.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         * <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial component.
         * </p>
         * 
         * @param trialComponentArn
         *        The Amazon Resource Name (ARN) of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentArn(String trialComponentArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and job type of the source of the component.
         * </p>
         * 
         * @param source
         *        The Amazon Resource Name (ARN) and job type of the source of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TrialComponentSource source);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and job type of the source of the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrialComponentSource.Builder} avoiding
         * the need to create one manually via {@link TrialComponentSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrialComponentSource.Builder#build()} is called immediately and
         * its result is passed to {@link #source(TrialComponentSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TrialComponentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TrialComponentSource)
         */
        default Builder source(Consumer<TrialComponentSource.Builder> source) {
            return source(TrialComponentSource.builder().applyMutation(source).build());
        }

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * Sets the value of the Status property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TrialComponentStatus.Builder} avoiding
         * the need to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * When the component was created.
         * </p>
         * 
         * @param creationTime
         *        When the component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Who created the trial component.
         * </p>
         * 
         * @param createdBy
         *        Who created the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the trial component.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the component was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the component was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The hyperparameters of the component.
         * </p>
         * 
         * @param parameters
         *        The hyperparameters of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TrialComponentParameterValue> parameters);

        /**
         * <p>
         * The input artifacts of the component.
         * </p>
         * 
         * @param inputArtifacts
         *        The input artifacts of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts);

        /**
         * <p>
         * The output artifacts of the component.
         * </p>
         * 
         * @param outputArtifacts
         *        The output artifacts of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts);

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * 
         * @param metrics
         *        The metrics for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<TrialComponentMetricSummary> metrics);

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * 
         * @param metrics
         *        The metrics for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(TrialComponentMetricSummary... metrics);

        /**
         * <p>
         * The metrics for the component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #metrics(List<TrialComponentMetricSummary>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<TrialComponentMetricSummary>)
         */
        Builder metrics(Consumer<TrialComponentMetricSummary.Builder>... metrics);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * Details of the source of the component.
         * </p>
         * 
         * @param sourceDetail
         *        Details of the source of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetail(TrialComponentSourceDetail sourceDetail);

        /**
         * <p>
         * Details of the source of the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrialComponentSourceDetail.Builder}
         * avoiding the need to create one manually via {@link TrialComponentSourceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrialComponentSourceDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceDetail(TrialComponentSourceDetail)}.
         * 
         * @param sourceDetail
         *        a consumer that will call methods on {@link TrialComponentSourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetail(TrialComponentSourceDetail)
         */
        default Builder sourceDetail(Consumer<TrialComponentSourceDetail.Builder> sourceDetail) {
            return sourceDetail(TrialComponentSourceDetail.builder().applyMutation(sourceDetail).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lineage group resource.
         * </p>
         * 
         * @param lineageGroupArn
         *        The Amazon Resource Name (ARN) of the lineage group resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageGroupArn(String lineageGroupArn);

        /**
         * <p>
         * The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the component. You can use <a>Search</a> API to search on
         *        the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the component. You can use <a>Search</a> API to search on
         *        the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of the parents of the component. A parent is a trial the component is associated with and the
         * experiment the trial is part of. A component might not have any parents.
         * </p>
         * 
         * @param parents
         *        An array of the parents of the component. A parent is a trial the component is associated with and the
         *        experiment the trial is part of. A component might not have any parents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parents(Collection<Parent> parents);

        /**
         * <p>
         * An array of the parents of the component. A parent is a trial the component is associated with and the
         * experiment the trial is part of. A component might not have any parents.
         * </p>
         * 
         * @param parents
         *        An array of the parents of the component. A parent is a trial the component is associated with and the
         *        experiment the trial is part of. A component might not have any parents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parents(Parent... parents);

        /**
         * <p>
         * An array of the parents of the component. A parent is a trial the component is associated with and the
         * experiment the trial is part of. A component might not have any parents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Parent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Parent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Parent.Builder#build()} is called immediately and its
         * result is passed to {@link #parents(List<Parent>)}.
         * 
         * @param parents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Parent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parents(java.util.Collection<Parent>)
         */
        Builder parents(Consumer<Parent.Builder>... parents);

        /**
         * <p>
         * The name of the experiment run.
         * </p>
         * 
         * @param runName
         *        The name of the experiment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runName(String runName);
    }

    static final class BuilderImpl implements Builder {
        private String trialComponentName;

        private String displayName;

        private String trialComponentArn;

        private TrialComponentSource source;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private List<TrialComponentMetricSummary> metrics = DefaultSdkAutoConstructList.getInstance();

        private MetadataProperties metadataProperties;

        private TrialComponentSourceDetail sourceDetail;

        private String lineageGroupArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<Parent> parents = DefaultSdkAutoConstructList.getInstance();

        private String runName;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponent model) {
            trialComponentName(model.trialComponentName);
            displayName(model.displayName);
            trialComponentArn(model.trialComponentArn);
            source(model.source);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            parameters(model.parameters);
            inputArtifacts(model.inputArtifacts);
            outputArtifacts(model.outputArtifacts);
            metrics(model.metrics);
            metadataProperties(model.metadataProperties);
            sourceDetail(model.sourceDetail);
            lineageGroupArn(model.lineageGroupArn);
            tags(model.tags);
            parents(model.parents);
            runName(model.runName);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getTrialComponentArn() {
            return trialComponentArn;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final TrialComponentSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TrialComponentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TrialComponentSource source) {
            this.source = source;
            return this;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            Map<String, TrialComponentParameterValue.Builder> result = TrialComponentParametersCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier
                    .copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final List<TrialComponentMetricSummary.Builder> getMetrics() {
            List<TrialComponentMetricSummary.Builder> result = TrialComponentMetricSummariesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<TrialComponentMetricSummary.BuilderImpl> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<TrialComponentMetricSummary> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TrialComponentMetricSummary... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TrialComponentMetricSummary.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> TrialComponentMetricSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final TrialComponentSourceDetail.Builder getSourceDetail() {
            return sourceDetail != null ? sourceDetail.toBuilder() : null;
        }

        public final void setSourceDetail(TrialComponentSourceDetail.BuilderImpl sourceDetail) {
            this.sourceDetail = sourceDetail != null ? sourceDetail.build() : null;
        }

        @Override
        public final Builder sourceDetail(TrialComponentSourceDetail sourceDetail) {
            this.sourceDetail = sourceDetail;
            return this;
        }

        public final String getLineageGroupArn() {
            return lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Parent.Builder> getParents() {
            List<Parent.Builder> result = ParentsCopier.copyToBuilder(this.parents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent... parents) {
            parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<Parent.Builder>... parents) {
            parents(Stream.of(parents).map(c -> Parent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRunName() {
            return runName;
        }

        public final void setRunName(String runName) {
            this.runName = runName;
        }

        @Override
        public final Builder runName(String runName) {
            this.runName = runName;
            return this;
        }

        @Override
        public TrialComponent build() {
            return new TrialComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
