/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How long a job is allowed to run, or how many candidates a job is allowed to generate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobCompletionCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLJobCompletionCriteria.Builder, AutoMLJobCompletionCriteria> {
    private static final SdkField<Integer> MAX_CANDIDATES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCandidates").getter(getter(AutoMLJobCompletionCriteria::maxCandidates))
            .setter(setter(Builder::maxCandidates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCandidates").build()).build();

    private static final SdkField<Integer> MAX_RUNTIME_PER_TRAINING_JOB_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRuntimePerTrainingJobInSeconds")
            .getter(getter(AutoMLJobCompletionCriteria::maxRuntimePerTrainingJobInSeconds))
            .setter(setter(Builder::maxRuntimePerTrainingJobInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRuntimePerTrainingJobInSeconds")
                    .build()).build();

    private static final SdkField<Integer> MAX_AUTO_ML_JOB_RUNTIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAutoMLJobRuntimeInSeconds")
            .getter(getter(AutoMLJobCompletionCriteria::maxAutoMLJobRuntimeInSeconds))
            .setter(setter(Builder::maxAutoMLJobRuntimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAutoMLJobRuntimeInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CANDIDATES_FIELD,
            MAX_RUNTIME_PER_TRAINING_JOB_IN_SECONDS_FIELD, MAX_AUTO_ML_JOB_RUNTIME_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxCandidates;

    private final Integer maxRuntimePerTrainingJobInSeconds;

    private final Integer maxAutoMLJobRuntimeInSeconds;

    private AutoMLJobCompletionCriteria(BuilderImpl builder) {
        this.maxCandidates = builder.maxCandidates;
        this.maxRuntimePerTrainingJobInSeconds = builder.maxRuntimePerTrainingJobInSeconds;
        this.maxAutoMLJobRuntimeInSeconds = builder.maxAutoMLJobRuntimeInSeconds;
    }

    /**
     * <p>
     * The maximum number of times a training job is allowed to run.
     * </p>
     * <p>
     * For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), the supported value is 1.
     * </p>
     * 
     * @return The maximum number of times a training job is allowed to run.</p>
     *         <p>
     *         For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), the supported value is 1.
     */
    public final Integer maxCandidates() {
        return maxCandidates;
    }

    /**
     * <p>
     * The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to run as
     * part of a hyperparameter tuning job. For more information, see the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html">StoppingCondition</a>
     * used by the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a> action.
     * </p>
     * <p>
     * For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), this field controls the runtime of the job
     * candidate.
     * </p>
     * 
     * @return The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to
     *         run as part of a hyperparameter tuning job. For more information, see the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html"
     *         >StoppingCondition</a> used by the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     *         >CreateHyperParameterTuningJob</a> action.</p>
     *         <p>
     *         For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), this field controls the runtime of
     *         the job candidate.
     */
    public final Integer maxRuntimePerTrainingJobInSeconds() {
        return maxRuntimePerTrainingJobInSeconds;
    }

    /**
     * <p>
     * The maximum runtime, in seconds, an AutoML job has to complete.
     * </p>
     * <p>
     * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended
     * gracefully. The AutoML job identifies the best model whose training was completed and marks it as the
     * best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment,
     * are not completed.
     * </p>
     * 
     * @return The maximum runtime, in seconds, an AutoML job has to complete.</p>
     *         <p>
     *         If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is
     *         ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as
     *         the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model
     *         deployment, are not completed.
     */
    public final Integer maxAutoMLJobRuntimeInSeconds() {
        return maxAutoMLJobRuntimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCandidates());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuntimePerTrainingJobInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxAutoMLJobRuntimeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobCompletionCriteria)) {
            return false;
        }
        AutoMLJobCompletionCriteria other = (AutoMLJobCompletionCriteria) obj;
        return Objects.equals(maxCandidates(), other.maxCandidates())
                && Objects.equals(maxRuntimePerTrainingJobInSeconds(), other.maxRuntimePerTrainingJobInSeconds())
                && Objects.equals(maxAutoMLJobRuntimeInSeconds(), other.maxAutoMLJobRuntimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLJobCompletionCriteria").add("MaxCandidates", maxCandidates())
                .add("MaxRuntimePerTrainingJobInSeconds", maxRuntimePerTrainingJobInSeconds())
                .add("MaxAutoMLJobRuntimeInSeconds", maxAutoMLJobRuntimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCandidates":
            return Optional.ofNullable(clazz.cast(maxCandidates()));
        case "MaxRuntimePerTrainingJobInSeconds":
            return Optional.ofNullable(clazz.cast(maxRuntimePerTrainingJobInSeconds()));
        case "MaxAutoMLJobRuntimeInSeconds":
            return Optional.ofNullable(clazz.cast(maxAutoMLJobRuntimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobCompletionCriteria, T> g) {
        return obj -> g.apply((AutoMLJobCompletionCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobCompletionCriteria> {
        /**
         * <p>
         * The maximum number of times a training job is allowed to run.
         * </p>
         * <p>
         * For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), the supported value is 1.
         * </p>
         * 
         * @param maxCandidates
         *        The maximum number of times a training job is allowed to run.</p>
         *        <p>
         *        For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), the supported value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCandidates(Integer maxCandidates);

        /**
         * <p>
         * The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to run
         * as part of a hyperparameter tuning job. For more information, see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html"
         * >StoppingCondition</a> used by the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
         * >CreateHyperParameterTuningJob</a> action.
         * </p>
         * <p>
         * For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), this field controls the runtime of the
         * job candidate.
         * </p>
         * 
         * @param maxRuntimePerTrainingJobInSeconds
         *        The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed
         *        to run as part of a hyperparameter tuning job. For more information, see the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html"
         *        >StoppingCondition</a> used by the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
         *        >CreateHyperParameterTuningJob</a> action.</p>
         *        <p>
         *        For V2 jobs (jobs created by calling <code>CreateAutoMLJobV2</code>), this field controls the runtime
         *        of the job candidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuntimePerTrainingJobInSeconds(Integer maxRuntimePerTrainingJobInSeconds);

        /**
         * <p>
         * The maximum runtime, in seconds, an AutoML job has to complete.
         * </p>
         * <p>
         * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended
         * gracefully. The AutoML job identifies the best model whose training was completed and marks it as the
         * best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model
         * deployment, are not completed.
         * </p>
         * 
         * @param maxAutoMLJobRuntimeInSeconds
         *        The maximum runtime, in seconds, an AutoML job has to complete.</p>
         *        <p>
         *        If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is
         *        ended gracefully. The AutoML job identifies the best model whose training was completed and marks it
         *        as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot
         *        model deployment, are not completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAutoMLJobRuntimeInSeconds(Integer maxAutoMLJobRuntimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxCandidates;

        private Integer maxRuntimePerTrainingJobInSeconds;

        private Integer maxAutoMLJobRuntimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobCompletionCriteria model) {
            maxCandidates(model.maxCandidates);
            maxRuntimePerTrainingJobInSeconds(model.maxRuntimePerTrainingJobInSeconds);
            maxAutoMLJobRuntimeInSeconds(model.maxAutoMLJobRuntimeInSeconds);
        }

        public final Integer getMaxCandidates() {
            return maxCandidates;
        }

        public final void setMaxCandidates(Integer maxCandidates) {
            this.maxCandidates = maxCandidates;
        }

        @Override
        public final Builder maxCandidates(Integer maxCandidates) {
            this.maxCandidates = maxCandidates;
            return this;
        }

        public final Integer getMaxRuntimePerTrainingJobInSeconds() {
            return maxRuntimePerTrainingJobInSeconds;
        }

        public final void setMaxRuntimePerTrainingJobInSeconds(Integer maxRuntimePerTrainingJobInSeconds) {
            this.maxRuntimePerTrainingJobInSeconds = maxRuntimePerTrainingJobInSeconds;
        }

        @Override
        public final Builder maxRuntimePerTrainingJobInSeconds(Integer maxRuntimePerTrainingJobInSeconds) {
            this.maxRuntimePerTrainingJobInSeconds = maxRuntimePerTrainingJobInSeconds;
            return this;
        }

        public final Integer getMaxAutoMLJobRuntimeInSeconds() {
            return maxAutoMLJobRuntimeInSeconds;
        }

        public final void setMaxAutoMLJobRuntimeInSeconds(Integer maxAutoMLJobRuntimeInSeconds) {
            this.maxAutoMLJobRuntimeInSeconds = maxAutoMLJobRuntimeInSeconds;
        }

        @Override
        public final Builder maxAutoMLJobRuntimeInSeconds(Integer maxAutoMLJobRuntimeInSeconds) {
            this.maxAutoMLJobRuntimeInSeconds = maxAutoMLJobRuntimeInSeconds;
            return this;
        }

        @Override
        public AutoMLJobCompletionCriteria build() {
            return new AutoMLJobCompletionCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
