/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of <code>Domain</code> configuration settings to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainSettingsForUpdate.Builder, DomainSettingsForUpdate> {
    private static final SdkField<RStudioServerProDomainSettingsForUpdate> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<RStudioServerProDomainSettingsForUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("RStudioServerProDomainSettingsForUpdate")
            .getter(getter(DomainSettingsForUpdate::rStudioServerProDomainSettingsForUpdate))
            .setter(setter(Builder::rStudioServerProDomainSettingsForUpdate))
            .constructor(RStudioServerProDomainSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RStudioServerProDomainSettingsForUpdate").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_IDENTITY_CONFIG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleIdentityConfig")
            .getter(getter(DomainSettingsForUpdate::executionRoleIdentityConfigAsString))
            .setter(setter(Builder::executionRoleIdentityConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleIdentityConfig")
                    .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(DomainSettingsForUpdate::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD,
                    EXECUTION_ROLE_IDENTITY_CONFIG_FIELD, SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

    private final String executionRoleIdentityConfig;

    private final List<String> securityGroupIds;

    private DomainSettingsForUpdate(BuilderImpl builder) {
        this.rStudioServerProDomainSettingsForUpdate = builder.rStudioServerProDomainSettingsForUpdate;
        this.executionRoleIdentityConfig = builder.executionRoleIdentityConfig;
        this.securityGroupIds = builder.securityGroupIds;
    }

    /**
     * <p>
     * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
     * </p>
     * 
     * @return A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
     */
    public final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate() {
        return rStudioServerProDomainSettingsForUpdate;
    }

    /**
     * <p>
     * The configuration for attaching a SageMaker user profile name to the execution role as a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     * <code>InService</code> or <code>Pending</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionRoleIdentityConfig} will return {@link ExecutionRoleIdentityConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #executionRoleIdentityConfigAsString}.
     * </p>
     * 
     * @return The configuration for attaching a SageMaker user profile name to the execution role as a <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     *         >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     *         <code>InService</code> or <code>Pending</code> state.
     * @see ExecutionRoleIdentityConfig
     */
    public final ExecutionRoleIdentityConfig executionRoleIdentityConfig() {
        return ExecutionRoleIdentityConfig.fromValue(executionRoleIdentityConfig);
    }

    /**
     * <p>
     * The configuration for attaching a SageMaker user profile name to the execution role as a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     * <code>InService</code> or <code>Pending</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionRoleIdentityConfig} will return {@link ExecutionRoleIdentityConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #executionRoleIdentityConfigAsString}.
     * </p>
     * 
     * @return The configuration for attaching a SageMaker user profile name to the execution role as a <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     *         >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     *         <code>InService</code> or <code>Pending</code> state.
     * @see ExecutionRoleIdentityConfig
     */
    public final String executionRoleIdentityConfigAsString() {
        return executionRoleIdentityConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
     * between Domain-level apps and user apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
     *         communication between Domain-level apps and user apps.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rStudioServerProDomainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleIdentityConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettingsForUpdate)) {
            return false;
        }
        DomainSettingsForUpdate other = (DomainSettingsForUpdate) obj;
        return Objects.equals(rStudioServerProDomainSettingsForUpdate(), other.rStudioServerProDomainSettingsForUpdate())
                && Objects.equals(executionRoleIdentityConfigAsString(), other.executionRoleIdentityConfigAsString())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSettingsForUpdate")
                .add("RStudioServerProDomainSettingsForUpdate", rStudioServerProDomainSettingsForUpdate())
                .add("ExecutionRoleIdentityConfig", executionRoleIdentityConfigAsString())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RStudioServerProDomainSettingsForUpdate":
            return Optional.ofNullable(clazz.cast(rStudioServerProDomainSettingsForUpdate()));
        case "ExecutionRoleIdentityConfig":
            return Optional.ofNullable(clazz.cast(executionRoleIdentityConfigAsString()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSettingsForUpdate, T> g) {
        return obj -> g.apply((DomainSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSettingsForUpdate> {
        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * </p>
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate);

        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RStudioServerProDomainSettingsForUpdate.Builder} avoiding the need to create one manually via
         * {@link RStudioServerProDomainSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RStudioServerProDomainSettingsForUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)}.
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        a consumer that will call methods on {@link RStudioServerProDomainSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)
         */
        default Builder rStudioServerProDomainSettingsForUpdate(
                Consumer<RStudioServerProDomainSettingsForUpdate.Builder> rStudioServerProDomainSettingsForUpdate) {
            return rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate.builder()
                    .applyMutation(rStudioServerProDomainSettingsForUpdate).build());
        }

        /**
         * <p>
         * The configuration for attaching a SageMaker user profile name to the execution role as a <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         * <code>InService</code> or <code>Pending</code> state.
         * </p>
         * 
         * @param executionRoleIdentityConfig
         *        The configuration for attaching a SageMaker user profile name to the execution role as a <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         *        >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         *        <code>InService</code> or <code>Pending</code> state.
         * @see ExecutionRoleIdentityConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRoleIdentityConfig
         */
        Builder executionRoleIdentityConfig(String executionRoleIdentityConfig);

        /**
         * <p>
         * The configuration for attaching a SageMaker user profile name to the execution role as a <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         * <code>InService</code> or <code>Pending</code> state.
         * </p>
         * 
         * @param executionRoleIdentityConfig
         *        The configuration for attaching a SageMaker user profile name to the execution role as a <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         *        >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         *        <code>InService</code> or <code>Pending</code> state.
         * @see ExecutionRoleIdentityConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRoleIdentityConfig
         */
        Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

        private String executionRoleIdentityConfig;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettingsForUpdate model) {
            rStudioServerProDomainSettingsForUpdate(model.rStudioServerProDomainSettingsForUpdate);
            executionRoleIdentityConfig(model.executionRoleIdentityConfig);
            securityGroupIds(model.securityGroupIds);
        }

        public final RStudioServerProDomainSettingsForUpdate.Builder getRStudioServerProDomainSettingsForUpdate() {
            return rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate.BuilderImpl rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate
                    .build() : null;
        }

        @Override
        public final Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate;
            return this;
        }

        public final String getExecutionRoleIdentityConfig() {
            return executionRoleIdentityConfig;
        }

        public final void setExecutionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
        }

        @Override
        public final Builder executionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
            return this;
        }

        @Override
        public final Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig(executionRoleIdentityConfig == null ? null : executionRoleIdentityConfig.toString());
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        @Override
        public DomainSettingsForUpdate build() {
            return new DomainSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
