/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies conditions for stopping a job. When a job reaches a stopping condition limit, SageMaker ends the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobStoppingConditions implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobStoppingConditions.Builder, RecommendationJobStoppingConditions> {
    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInvocations").getter(getter(RecommendationJobStoppingConditions::maxInvocations))
            .setter(setter(Builder::maxInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()).build();

    private static final SdkField<List<ModelLatencyThreshold>> MODEL_LATENCY_THRESHOLDS_FIELD = SdkField
            .<List<ModelLatencyThreshold>> builder(MarshallingType.LIST)
            .memberName("ModelLatencyThresholds")
            .getter(getter(RecommendationJobStoppingConditions::modelLatencyThresholds))
            .setter(setter(Builder::modelLatencyThresholds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatencyThresholds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelLatencyThreshold> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelLatencyThreshold::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_INVOCATIONS_FIELD,
            MODEL_LATENCY_THRESHOLDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxInvocations;

    private final List<ModelLatencyThreshold> modelLatencyThresholds;

    private RecommendationJobStoppingConditions(BuilderImpl builder) {
        this.maxInvocations = builder.maxInvocations;
        this.modelLatencyThresholds = builder.modelLatencyThresholds;
    }

    /**
     * <p>
     * The maximum number of requests per minute expected for the endpoint.
     * </p>
     * 
     * @return The maximum number of requests per minute expected for the endpoint.
     */
    public final Integer maxInvocations() {
        return maxInvocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelLatencyThresholds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelLatencyThresholds() {
        return modelLatencyThresholds != null && !(modelLatencyThresholds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local
     * communication time taken to send the request and to fetch the response from the container of a model and the time
     * taken to complete the inference in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelLatencyThresholds} method.
     * </p>
     * 
     * @return The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the
     *         local communication time taken to send the request and to fetch the response from the container of a
     *         model and the time taken to complete the inference in the container.
     */
    public final List<ModelLatencyThreshold> modelLatencyThresholds() {
        return modelLatencyThresholds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelLatencyThresholds() ? modelLatencyThresholds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobStoppingConditions)) {
            return false;
        }
        RecommendationJobStoppingConditions other = (RecommendationJobStoppingConditions) obj;
        return Objects.equals(maxInvocations(), other.maxInvocations())
                && hasModelLatencyThresholds() == other.hasModelLatencyThresholds()
                && Objects.equals(modelLatencyThresholds(), other.modelLatencyThresholds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobStoppingConditions").add("MaxInvocations", maxInvocations())
                .add("ModelLatencyThresholds", hasModelLatencyThresholds() ? modelLatencyThresholds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxInvocations":
            return Optional.ofNullable(clazz.cast(maxInvocations()));
        case "ModelLatencyThresholds":
            return Optional.ofNullable(clazz.cast(modelLatencyThresholds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobStoppingConditions, T> g) {
        return obj -> g.apply((RecommendationJobStoppingConditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobStoppingConditions> {
        /**
         * <p>
         * The maximum number of requests per minute expected for the endpoint.
         * </p>
         * 
         * @param maxInvocations
         *        The maximum number of requests per minute expected for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInvocations(Integer maxInvocations);

        /**
         * <p>
         * The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local
         * communication time taken to send the request and to fetch the response from the container of a model and the
         * time taken to complete the inference in the container.
         * </p>
         * 
         * @param modelLatencyThresholds
         *        The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the
         *        local communication time taken to send the request and to fetch the response from the container of a
         *        model and the time taken to complete the inference in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLatencyThresholds(Collection<ModelLatencyThreshold> modelLatencyThresholds);

        /**
         * <p>
         * The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local
         * communication time taken to send the request and to fetch the response from the container of a model and the
         * time taken to complete the inference in the container.
         * </p>
         * 
         * @param modelLatencyThresholds
         *        The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the
         *        local communication time taken to send the request and to fetch the response from the container of a
         *        model and the time taken to complete the inference in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLatencyThresholds(ModelLatencyThreshold... modelLatencyThresholds);

        /**
         * <p>
         * The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local
         * communication time taken to send the request and to fetch the response from the container of a model and the
         * time taken to complete the inference in the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold.Builder#build()} is called
         * immediately and its result is passed to {@link #modelLatencyThresholds(List<ModelLatencyThreshold>)}.
         * 
         * @param modelLatencyThresholds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelLatencyThresholds(java.util.Collection<ModelLatencyThreshold>)
         */
        Builder modelLatencyThresholds(Consumer<ModelLatencyThreshold.Builder>... modelLatencyThresholds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxInvocations;

        private List<ModelLatencyThreshold> modelLatencyThresholds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobStoppingConditions model) {
            maxInvocations(model.maxInvocations);
            modelLatencyThresholds(model.modelLatencyThresholds);
        }

        public final Integer getMaxInvocations() {
            return maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final List<ModelLatencyThreshold.Builder> getModelLatencyThresholds() {
            List<ModelLatencyThreshold.Builder> result = ModelLatencyThresholdsCopier.copyToBuilder(this.modelLatencyThresholds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelLatencyThresholds(Collection<ModelLatencyThreshold.BuilderImpl> modelLatencyThresholds) {
            this.modelLatencyThresholds = ModelLatencyThresholdsCopier.copyFromBuilder(modelLatencyThresholds);
        }

        @Override
        public final Builder modelLatencyThresholds(Collection<ModelLatencyThreshold> modelLatencyThresholds) {
            this.modelLatencyThresholds = ModelLatencyThresholdsCopier.copy(modelLatencyThresholds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelLatencyThresholds(ModelLatencyThreshold... modelLatencyThresholds) {
            modelLatencyThresholds(Arrays.asList(modelLatencyThresholds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelLatencyThresholds(Consumer<ModelLatencyThreshold.Builder>... modelLatencyThresholds) {
            modelLatencyThresholds(Stream.of(modelLatencyThresholds)
                    .map(c -> ModelLatencyThreshold.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendationJobStoppingConditions build() {
            return new RecommendationJobStoppingConditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
