/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointMetadata.Builder, EndpointMetadata> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(EndpointMetadata::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(EndpointMetadata::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointStatus").getter(getter(EndpointMetadata::endpointStatusAsString))
            .setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(EndpointMetadata::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_CONFIG_NAME_FIELD, ENDPOINT_STATUS_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointName;

    private final String endpointConfigName;

    private final String endpointStatus;

    private final String failureReason;

    private EndpointMetadata(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointStatus = builder.endpointStatus;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the endpoint.
     * </p>
     * 
     * @return The name of the endpoint.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of the endpoint configuration.
     * </p>
     * 
     * @return The name of the endpoint configuration.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * <p>
     * The status of the endpoint. For possible values of the status of an endpoint, see
     * <a>EndpointSummary$EndpointStatus</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The status of the endpoint. For possible values of the status of an endpoint, see
     *         <a>EndpointSummary$EndpointStatus</a>.
     * @see EndpointStatus
     */
    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(endpointStatus);
    }

    /**
     * <p>
     * The status of the endpoint. For possible values of the status of an endpoint, see
     * <a>EndpointSummary$EndpointStatus</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The status of the endpoint. For possible values of the status of an endpoint, see
     *         <a>EndpointSummary$EndpointStatus</a>.
     * @see EndpointStatus
     */
    public final String endpointStatusAsString() {
        return endpointStatus;
    }

    /**
     * <p>
     * If the status of the endpoint is <code>Failed</code>, or the status is <code>InService</code> but update
     * operation fails, this provides the reason why it failed.
     * </p>
     * 
     * @return If the status of the endpoint is <code>Failed</code>, or the status is <code>InService</code> but update
     *         operation fails, this provides the reason why it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointMetadata)) {
            return false;
        }
        EndpointMetadata other = (EndpointMetadata) obj;
        return Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(endpointConfigName(), other.endpointConfigName())
                && Objects.equals(endpointStatusAsString(), other.endpointStatusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointMetadata").add("EndpointName", endpointName())
                .add("EndpointConfigName", endpointConfigName()).add("EndpointStatus", endpointStatusAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointMetadata, T> g) {
        return obj -> g.apply((EndpointMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointMetadata> {
        /**
         * <p>
         * The name of the endpoint.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of the endpoint configuration.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * The status of the endpoint. For possible values of the status of an endpoint, see
         * <a>EndpointSummary$EndpointStatus</a>.
         * </p>
         * 
         * @param endpointStatus
         *        The status of the endpoint. For possible values of the status of an endpoint, see
         *        <a>EndpointSummary$EndpointStatus</a>.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The status of the endpoint. For possible values of the status of an endpoint, see
         * <a>EndpointSummary$EndpointStatus</a>.
         * </p>
         * 
         * @param endpointStatus
         *        The status of the endpoint. For possible values of the status of an endpoint, see
         *        <a>EndpointSummary$EndpointStatus</a>.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(EndpointStatus endpointStatus);

        /**
         * <p>
         * If the status of the endpoint is <code>Failed</code>, or the status is <code>InService</code> but update
         * operation fails, this provides the reason why it failed.
         * </p>
         * 
         * @param failureReason
         *        If the status of the endpoint is <code>Failed</code>, or the status is <code>InService</code> but
         *        update operation fails, this provides the reason why it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String endpointName;

        private String endpointConfigName;

        private String endpointStatus;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointMetadata model) {
            endpointName(model.endpointName);
            endpointConfigName(model.endpointConfigName);
            endpointStatus(model.endpointStatus);
            failureReason(model.failureReason);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public EndpointMetadata build() {
            return new EndpointMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
