/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of recommended deployment configurations for the model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentRecommendation.Builder, DeploymentRecommendation> {
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationStatus").getter(getter(DeploymentRecommendation::recommendationStatusAsString))
            .setter(setter(Builder::recommendationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationStatus").build())
            .build();

    private static final SdkField<List<RealTimeInferenceRecommendation>> REAL_TIME_INFERENCE_RECOMMENDATIONS_FIELD = SdkField
            .<List<RealTimeInferenceRecommendation>> builder(MarshallingType.LIST)
            .memberName("RealTimeInferenceRecommendations")
            .getter(getter(DeploymentRecommendation::realTimeInferenceRecommendations))
            .setter(setter(Builder::realTimeInferenceRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeInferenceRecommendations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeInferenceRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeInferenceRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_STATUS_FIELD,
            REAL_TIME_INFERENCE_RECOMMENDATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationStatus;

    private final List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations;

    private DeploymentRecommendation(BuilderImpl builder) {
        this.recommendationStatus = builder.recommendationStatus;
        this.realTimeInferenceRecommendations = builder.realTimeInferenceRecommendations;
    }

    /**
     * <p>
     * Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to provide a
     * default recommendation for the model using the information provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationStatus} will return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationStatusAsString}.
     * </p>
     * 
     * @return Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
     *         provide a default recommendation for the model using the information provided.
     * @see RecommendationStatus
     */
    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(recommendationStatus);
    }

    /**
     * <p>
     * Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to provide a
     * default recommendation for the model using the information provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationStatus} will return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationStatusAsString}.
     * </p>
     * 
     * @return Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
     *         provide a default recommendation for the model using the information provided.
     * @see RecommendationStatus
     */
    public final String recommendationStatusAsString() {
        return recommendationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the RealTimeInferenceRecommendations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRealTimeInferenceRecommendations() {
        return realTimeInferenceRecommendations != null && !(realTimeInferenceRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
     * >RealTimeInferenceRecommendation</a> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRealTimeInferenceRecommendations}
     * method.
     * </p>
     * 
     * @return A list of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
     *         >RealTimeInferenceRecommendation</a> items.
     */
    public final List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations() {
        return realTimeInferenceRecommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationStatusAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRealTimeInferenceRecommendations() ? realTimeInferenceRecommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentRecommendation)) {
            return false;
        }
        DeploymentRecommendation other = (DeploymentRecommendation) obj;
        return Objects.equals(recommendationStatusAsString(), other.recommendationStatusAsString())
                && hasRealTimeInferenceRecommendations() == other.hasRealTimeInferenceRecommendations()
                && Objects.equals(realTimeInferenceRecommendations(), other.realTimeInferenceRecommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DeploymentRecommendation")
                .add("RecommendationStatus", recommendationStatusAsString())
                .add("RealTimeInferenceRecommendations",
                        hasRealTimeInferenceRecommendations() ? realTimeInferenceRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationStatus":
            return Optional.ofNullable(clazz.cast(recommendationStatusAsString()));
        case "RealTimeInferenceRecommendations":
            return Optional.ofNullable(clazz.cast(realTimeInferenceRecommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentRecommendation, T> g) {
        return obj -> g.apply((DeploymentRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentRecommendation> {
        /**
         * <p>
         * Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
         * provide a default recommendation for the model using the information provided.
         * </p>
         * 
         * @param recommendationStatus
         *        Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
         *        provide a default recommendation for the model using the information provided.
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder recommendationStatus(String recommendationStatus);

        /**
         * <p>
         * Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
         * provide a default recommendation for the model using the information provided.
         * </p>
         * 
         * @param recommendationStatus
         *        Status of the deployment recommendation. <code>NOT_APPLICABLE</code> means that SageMaker is unable to
         *        provide a default recommendation for the model using the information provided.
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder recommendationStatus(RecommendationStatus recommendationStatus);

        /**
         * <p>
         * A list of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
         * >RealTimeInferenceRecommendation</a> items.
         * </p>
         * 
         * @param realTimeInferenceRecommendations
         *        A list of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
         *        >RealTimeInferenceRecommendation</a> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeInferenceRecommendations(Collection<RealTimeInferenceRecommendation> realTimeInferenceRecommendations);

        /**
         * <p>
         * A list of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
         * >RealTimeInferenceRecommendation</a> items.
         * </p>
         * 
         * @param realTimeInferenceRecommendations
         *        A list of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
         *        >RealTimeInferenceRecommendation</a> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeInferenceRecommendations(RealTimeInferenceRecommendation... realTimeInferenceRecommendations);

        /**
         * <p>
         * A list of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html"
         * >RealTimeInferenceRecommendation</a> items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #realTimeInferenceRecommendations(List<RealTimeInferenceRecommendation>)}.
         * 
         * @param realTimeInferenceRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realTimeInferenceRecommendations(java.util.Collection<RealTimeInferenceRecommendation>)
         */
        Builder realTimeInferenceRecommendations(
                Consumer<RealTimeInferenceRecommendation.Builder>... realTimeInferenceRecommendations);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationStatus;

        private List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentRecommendation model) {
            recommendationStatus(model.recommendationStatus);
            realTimeInferenceRecommendations(model.realTimeInferenceRecommendations);
        }

        public final String getRecommendationStatus() {
            return recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final List<RealTimeInferenceRecommendation.Builder> getRealTimeInferenceRecommendations() {
            List<RealTimeInferenceRecommendation.Builder> result = RealTimeInferenceRecommendationsCopier
                    .copyToBuilder(this.realTimeInferenceRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRealTimeInferenceRecommendations(
                Collection<RealTimeInferenceRecommendation.BuilderImpl> realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations = RealTimeInferenceRecommendationsCopier
                    .copyFromBuilder(realTimeInferenceRecommendations);
        }

        @Override
        public final Builder realTimeInferenceRecommendations(
                Collection<RealTimeInferenceRecommendation> realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations = RealTimeInferenceRecommendationsCopier.copy(realTimeInferenceRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder realTimeInferenceRecommendations(RealTimeInferenceRecommendation... realTimeInferenceRecommendations) {
            realTimeInferenceRecommendations(Arrays.asList(realTimeInferenceRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder realTimeInferenceRecommendations(
                Consumer<RealTimeInferenceRecommendation.Builder>... realTimeInferenceRecommendations) {
            realTimeInferenceRecommendations(Stream.of(realTimeInferenceRecommendations)
                    .map(c -> RealTimeInferenceRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeploymentRecommendation build() {
            return new DeploymentRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
